// Persistence of Vision Ray Tracer Include File
// File: bisbee.inc
// Vers: 3.5 for Macintosh
// Desc: Warp Nacelles for Tucson Class Starship
// Last: 07 August 2003
// Auth: Dawn McKnight (d-mcknight@cox.net)

#ifndef ( NavLight )
	#include "navlight.inc"
#end

#ifndef ( T_Glass3 )
	#include "glass.inc"
#end

#ifndef(Hull_texture)
   #include "bistex.inc"
#end

#ifndef (T_Copper_3C)
	#include "metals.inc"
#end

//__________________ This section defines the Nacelle forward of the cones______

#local BisBus =
	difference {
		sphere {
			<0, 0, 0>
			3.0306
			}
		
		plane {
			z
			0
			}
		
		texture { Bussard_texture scale 2.2 }		
			
		} // close difference Bussard 

#local Control_Element = 
union {
	difference {
		torus {
			3.4515
			0.3367
			rotate 90*x
			}
		
		plane {
			-x
			0
			}
		
		plane {
			x
			0
			rotate 50*z
			}
		
		} // close difference 
		
	sphere {
		<0, 0, 0>
		 0.3367
		 translate 3.4515*y
		 }

	sphere {
		<0, 0, 0>
		 0.3367
		 translate 3.4515*y
		 rotate 50*z
		 }

	texture { Coil_texture }

}

#local Control_Coil = union {
	#local CCE = 0;
	#while ( CCE < 5 )
		object { Control_Element rotate (CCE*72)*z }
		#local CCE = CCE + 1;	
	#end
	}

#local FrontCylA =
	cylinder {
		<0, 0, -0.8>
		<0, 0, -2.69391>
		3.7041
		texture { Hull_texture }
		}

#local FrontCylB = 
	cylinder {
		<0, 0, 0>
		<0, 0, -2.6939>
		3.4515		
		texture { HazeGrey }
		}
		
#local ArrayOfCones = union {
	#local CAC = 0;
	
	#while (CAC < 4)
		cone {
			<0, 0, 0>
			3.5778
			<0, 0, -2.84>
			0
			open
			texture {T_Copper_3C}
			translate (-2.6939 -(0.4209*CAC))*z
			}
		
		#local CAC = CAC + 1;
	#end
}// close union
		
#local BisNacelleFront = union {
	object { BisBus }
	object { FrontCylA }
	object { FrontCylB }
	object { Control_Coil translate -0.4*z }
	object { ArrayOfCones }
	}
	
//____________ This section defines the cylinders aft of the cones _____________
	
#local CylA = difference {
	cylinder {
		<0, 0, -2>
		<0, 0, 14.8163>
		3.7041
		}
		
	plane {
		z
		0
		rotate 37*x
		translate 2.3571*z
		}

	texture { Hull_texture }
	
	} // close difference CylA		

#local CylB = difference {
	cylinder {
		<0, 0, -3>
		<0, 0, 14.8>
		3.4515
		}
		
	plane {
		z
		0
		rotate 37*x
		translate 1.0102*z
		}
	
	texture { HazeGrey }
	
	} // close difference CylA	
	
#local CylC = merge {
	cylinder {
		<0, 0, 14.8>
		<0, 0, -50.8469>
		3.1989
		}
		
	sphere {
		<0, 0, 0>
		1
		scale <3.1989, 3.1989, 8.4183>
		translate -50.8469*z
		}

	texture { Hull_texture }
		
}	

#local AftTubes = union {
	object { CylA }
	object { CylB }
	object { CylC }
}	

//__________ This section defines the 'box' on the sides of the nacelles

#local NacStep =
	superellipsoid {
		<0.05, 0.05>
		scale <3.83, 2.6939, 32.8316>
		translate -14.17*z
		texture { Stripe_texture }
		}

#local LouvreBoxOne = difference {
	
	box {
		<-0.3367, -1.6837, -5.5561>
		<0.3367, 1.6837, 5.5561>
		}
		
	plane {
		z
		0
		rotate 48*x
		translate -3.9*z
		}
	
	} // close difference LouvreBoxOne
	
#local LouvreBoxTwo = 
	difference {
		object { LouvreBoxOne }
		
		plane {
			-z
			0
			rotate 32*x
			translate 4.3776*z
			}
	} // close difference LouvreBoxTwo				

#local LBoxShape = merge {
	
	object { LouvreBoxTwo }
	
	cylinder {
		<0, 1.6837, -2.0204>
		<0, 1.6837, 5.3878>
		0.3367
		}
		
	cylinder {
		<0, -1.6837, -5.7245>
		<0, -1.6837, 3.1989>
		0.3367
		}
		
	cylinder {
		<0, -2.3771, 0>
		<0, 2.3771, 0>
		0.3367
		rotate 48*x
		translate -3.9*z
		}
	
	cylinder {
		<0, -2.1087, 0>
		<0, 2.1487, 0>
		0.3367
		rotate 32*x				
		translate 4.3776*z
		}
		
	sphere {
		<0, 1.6837, -2.0204>
		0.3367
		}
	
	sphere {
		<0, 1.6837, 5.3878>
		0.3367
		}
	
	sphere {
		<0, -1.6837, -5.7245>
		0.3367
		}
		
	sphere {
		<0, -1.6837, 3.1989>
		0.3367
		}
		
	} // close LBoxShape	
	
#local Slat =
	box {
		<-0.01, -2, -6>
		<0.01, 2, 6>
		}
		

#local Louvres = union {

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z }
		}
		
	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate 0.2*y }
		}

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate -0.2*y }
		}

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate 0.4*y }
		}

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate -0.4*y }
		}

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate 0.6*y }
		}

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate -0.6*y }
		}

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate 0.8*y }
		}

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate -0.8*y }
		}

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate 1.0*y }
		}

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate -1.0*y }
		}

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate 1.2*y }
		}
		
	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate -1.2*y }
		}

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate 1.4*y }
		}
		
	intersection {
		object { LBoxShape }		
		object { Slat rotate 45*z translate -1.4*y }
		}
		
	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate 1.6*y }
		}	
	
	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate -1.6*y }
		}
		
	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate 1.8*y }
		}

	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate -1.8*y }
		}
		
	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate 2*y }
		}
		
	intersection {
		object { LBoxShape }
		object { Slat rotate 45*z translate -2*y } 
		}

	texture { T_Chrome_2A }
	} // close intersection Louvres

#local VentBox = union {
	
	difference {
		object { LBoxShape }
		cone { <3, 0, -6>, 6, <3, 0, 6>, 0}
		texture { HazeGrey }
		}
		
	object { Louvres scale 0.9999 }
	
	} // close union VentBox
		
#local MountBox = difference {
union {
	cylinder {
		<0, 0, -8.4184>
		<0, 0, 8.4184>
		1.6837
		}
		
	sphere {
		<0, 0, 0>
		1.6837
		scale <1, 1, 1.35>
		translate -8.4184*z
		}

	sphere {
		<0, 0, 0>
		1.6837
		scale <1, 1, 1.35>
		translate 8.4184*z
		}
	} // close union
	
	plane { x, 0 }
	
} // close difference MountBox

#local BoxCutter = union {
	box {
		<-0.01, -1.3470, -23>
		<4, 1.3470, -80>
		} // close box

	cylinder {
		<-0.01, 0, 0>
		<4, 0, 0>
		1.347
		scale 1.35*z
		translate -23*z
		}
	
	box {
		<0.01, -1.347, 0>
		<-4, 1.347, -80>
		} // close box

	cylinder {
		<0.01, 0, 0>
		<-4, 0, 0>
		1.347
		scale <1, 1, 1.35>
		//translate -8.45*z
		}// close cylinder

	} // close union BoxCutter

#local NacStepTwo =
union {
	difference {	
		superellipsoid {
			<0.05, 0.05>
			scale <3.4515, 1.6837, 32.8316>
			translate -20.17*z
			texture { HazeGrey }
			} // close superellipsoid

		plane { z, 0 translate -50*z texture { HazeGrey } }
		
		} // close difference

	superellipsoid {
		<1, 0.05>
		rotate 90*y
		scale <3.4515, 1.6837, 2.273>
		translate -50*z
		texture { HazeGrey }
		} // close superellipsoid

	} // close union NacStepTwo


#local SideBoxes = union {

	difference {
		object { NacStep }
		object { 
			LBoxShape
			translate <3.83, 0, 11.45>
			texture { Hull_texture }	
			} // close LBoxShape
		
		object {
			LBoxShape
			translate <-3.83, 0, 11.45>
			texture { Hull_texture }
			} // close LBoxShape
			
		object { MountBox translate <3.4515, 0, -8.45> texture { HazeGrey } }
		object { BoxCutter texture { Stripe_texture } }
		} // close difference
		
	object { VentBox scale <1, 0.9, 0.9> translate <3.83, 0, 11.45> }
	object { VentBox scale <-1, 0.9, 0.9> translate <-3.83, 0, 11.45> }
	object { MountBox scale <0.8 0.8, 0.95> translate <3.4515, 0, -8.45> texture {Hull_texture} }

	difference {
		object { NacStepTwo }
		object { BoxCutter scale <1, 0.7424, 0.8> texture {HazeGrey} } 
		} // close difference 
	
	} // close union SideBoxes

//_________________________the intercoolers_____________________________________

#local Intercooler = union {
	difference {
		union {
			cylinder {
				<0, 0, 2.5>
				<0, 0, -2.5>
				0.5
				} // close cylinder
			
			sphere {
				<0, 0, 0>
				0.5
				scale <1, 1, 1.35>
				translate 2.5*z
				} // close sphere
			
			} // close union

		cone {
			<0, 0, -3>
			0.55
			<0, -0.2, 2.5>
			0
			} // close cone

		} // close difference

		union {
			cylinder {
				<0, 0, 0>
				<0, 0, -40>
				0.4
				}

			sphere {
				<0, 0, 0>
				0.4
				scale <1, 1, 2.6316>
				translate -40*z
				}
			
			} // close union
		texture { Coil_texture }
		} // close union Intercooler

//__________________________the glowing tube inside the Nacelle ________________

#local BisGlow = merge {
	
	box {
		<2.9463, 1.5, 3>
		<-2.9463, -1.5, -49.113>
		} // close box

	cylinder {
		<0, 1.5, 0>
		<0, -1.5, 0>
		2.9463
		scale <1, 1, 2.6316>
		translate -49.113*z
		} // close cylinder
	
	texture { Glow_texture }
	
	} // close union InnerTube

//________________________ The ship's commissioning penant decal ________

#local BaseSFShield = // the familiar delta shield
        prism {
                linear_sweep // stays the same size throughout width
                cubic_spline 
                -0.5,        // height 1
                0.5,        // height 2
                10,          // number of points
                <-4, 4>, // control point 1
                <5, 0>, // this is the point that has to match
                <-0.6, -3>,
                <-8, -4.9>,
                <-9.8, -4.8>,
                <-5, -1>,
                <-11, 5>,
                <-4, 4>,
                <5, 0> // matched
                <-0.6, -3> // control point 2
                sturm
                scale 0.9*z
                } // close prism

#local SFBox1 = difference { // and now, the red stripe...

        box {
                <-4.99, -0.5, -4.4>,
                <-184, 0.5, 4.4>
                } // close box

        object { BaseSFShield scale 2*y } // makes the end that fits against the shield
						// have the same curve

        box { <-4, -1, -5>, <-8.5, 1, -3.5> } // these both cut off excess 'bits'
        box { <-4, -1, 5>, <-8, 1, 3.5> }

        translate -2*x
        } // close difference

#local SFStripe = union {
	difference {

		object { 
			BaseSFShield 
			scale <0.25, 1, 0.25>
			rotate -90*y
			translate <0, -3.1989, -5>
			}
		
		object { CylC pigment {color Yellow} }
		pigment { color Yellow }

		} // close difference

		difference {

			difference {
				object { SFBox1 }
				object { SFBox1 scale <0.9, 1.1, 0.9> translate -2*x } // hollow the stripe
				box {<-288, -1, -5>, <-165, 1, 5> } // cut the end off
				scale <0.25, 1, 0.25>
				rotate -90*y
				translate <0, -3.1989, -5>
				} // close difference
			
			object { CylC pigment {color Red} }

			pigment { color Red }
			} // close difference

        } // close union SFStripe

#local NacDecalP = union {

	difference {
		text {
			ttf "MicrogB.ttf"
			"NCC 84722"
			1.0
			0
			scale <8, 8, 1>
			rotate -90*x
			rotate 180*y
			translate -55*x
			translate -0.5*y
			translate -2.5*z
			scale <0.25, 1, 0.25>
			rotate -90*y
			translate <0, -3.1989, -5> 
			}
			
		object { CylC pigment {color Black} }
		pigment { color Black }
		} // close difference
		
	object { SFStripe }

	} // close union NacDecalP


#local NacDecalS = union {

	difference {
		text {
			ttf "MicrogB.ttf"
			"NCC 84722"
			1.0
			0
			scale <8, 8, 1>
			rotate -90*x
			//rotate 180*y
			translate -115*x
			translate -0.5*y
			translate 3*z
			scale <0.25, 1, 0.25>
			rotate -90*y
			translate <0, -3.1989, -5> 
			}
			
		object { CylC pigment {color Black} }
		pigment { color Black }
		} // close difference
		
	object { SFStripe }

	} // close union NacDecalS

//________________________ the spotlight ____________________________

#local SpotCyl = 
union {

	cylinder {
		<0, 0, 0>
		<0, 0, -1>
		.1263
		open
		texture { Stripe_texture }
		} // close cylinder
		
	sphere {
		0
		.1263
		texture { Stripe_texture }
		}
		
	sphere {
		<0, 0, -0.89>
		.1
		texture { Light_texture }
		}
		
	translate <0, -3.4515, -0.7>
	
	}

//______________________ puts the Nacelle together _______________________
	
#local CutFront =
	difference {
		object { BisNacelleFront translate 19.1939*z rotate 29*z }
		object { LBoxShape translate <-3.8, 0, 11.45> } 
		object { LBoxShape translate <3.8, 0, 11.45> } 
		} // close difference CutFront
	
#local CutAft =
	difference {
		object { AftTubes }
		object { LBoxShape translate <-3.8, 0, 11.45> } 
		object { LBoxShape translate <3.8, 0, 11.45> } 
		object { BoxCutter scale <1, 0.7424, 0.8>  } 
		}


#local Nacelle = union {
	object  { CutFront }
        object { CutAft }
	object { BisGlow }
	object { SideBoxes }

	object { Intercooler translate <0, 3.1989, 0> rotate -20*z }
	object { Intercooler translate <0, 3.1989, 0> rotate 20*z }
	object { SpotCyl }
	
	light_source {
		<0, -13, 15.75>
		color (White * 2)
		spotlight
		radius 11
		falloff 13
		tightness 5
		point_at <0, -3.1989, -19.25>
		}
	
	} // close union BisNacelle

#local PORT_Nacelle = 
	union { 

		difference {
			object { Nacelle }
			object { NacDecalP translate 0.0001*y}
			}

		object {
			NavLight ( Red )
			scale 15
			rotate 90*z
			translate <-3.8301, 0, 4>
			}

		} // close union Port_Nacelle

#local STBD_Nacelle =
	union { 

		difference {
			object { Nacelle scale -1*x }
			object { NacDecalS translate 0.0001*y}
			}

		object {
			NavLight ( Green )
			scale 15
			rotate -90*z
			translate <3.8301, 0, 4>
			}

		} // close union STBD_Nacelle

//_____________________ From here down, we're working with the pylons ______

#local Pylon_Cone =
	cone {
		<-5.4, 0, 0>
		12
		<30, 0, 0>
		6
		scale <1, 0.14, 1>
		texture { Hull_texture }
		}
		

#local ArrayOfBoxes = 
		intersection {

			object { Pylon_Cone texture { Stripe_texture } }
						
			#local AoB = 0 ;
			#local RoB = 0 ;
			union {
			#while (RoB < 2)
			
				#while ( AoB < 4 )
					superellipsoid {
						<0.3, 0.3>
						scale <1.25, 15, 1.25>
						rotate -25*y
						translate (2+(3.5*RoB))*z
						#if (RoB < 1)
							translate (6.5+(3.5*AoB))*x
						#else
							translate (4.75+(3.5*AoB))*x
						#end
						}
					#local AoB = AoB + 1;
					#end
				
				#local AoB = 0;
				#local RoB = RoB + 1;
				#end 
				
			} // close union 
		
		texture { Stripe_texture } 	
		
		} // close intersection
		

#local Pylon_One = difference {
	
	object { Pylon_Cone texture {Hull_texture} }
	
	difference {	
		
		box {
			<2, 0, 13>
			<14, 12, -25>
			rotate -25*y
			rotate 20*x
			translate 10*x
			translate -5*z
			texture { Hull_texture }
			} // close box
			
		plane {
			-z
			0.01			
			texture { Stripe_texture }
			rotate 45*x
			translate -3*z
			} // close plane
			
			
		box {
			< -0.5, -1.1, 3 >
			< 0.5, 12.1, -15.1 >
			rotate -25*y
			translate 14.5*x
			texture { Stripe_texture }
			} // close box
				
		box {
			< -0.5, -1.1, 3 >
			< 0.5, 12.1, -15.1 >
			rotate -25*y
			translate 19.5*x
			texture { Stripe_texture }
			} // close box
		
		translate -4*x
		} // close inner difference
		
	} // close outer difference STBDPylon_One
		
#local Pylon_Two = union {

	object { Pylon_One }
	
	object { Pylon_Cone scale 0.999 texture { t_grille } }
	
	object { ArrayOfBoxes translate 0.02*y texture {Stripe_texture} }
	
	} // close STBDPylon_Two 


#local RotatedPylon =
	difference {
		object { Pylon_Two rotate 25*y }
		plane { -x, 0 translate 24.5*x }
		}
		
#local ChoppedPylon =
	difference {
		object { RotatedPylon rotate 29*z }
		plane { x, 0 }
		} 


#declare STBDWing = union {
	object { ChoppedPylon }
	object { STBD_Nacelle translate <24.4, 0, 0> rotate 29*z }
	}; // close STBDWing 
	
#declare PORTWing = union {
	object { ChoppedPylon scale -1*x }
	object { PORT_Nacelle translate <-24.4, 0, 0> rotate -29*z }
	}; // close PortWing 
