// Persistence of Vision Ray Tracer Include File
// File: lock.inc
// Vers: 3.5 for Macintosh
// Desc: Star Fleet standard airlock
// Last: 07 August 2003
// Auth: Dawn McKnight (d-mcknight@cox.net)


#ifndef (Blue)
	#include "colors.inc"
#end

#ifndef (T_Copper_3C)
	#include "metals.inc"
#end

#ifndef (p_trek_blood)
	#include "fjtech.inc"
#end

#local LatchCube =
	box {
		<-0.03, -0.03, -0.03>
		<0.03, 0.03, 0.03>
		translate 1.28*y
		translate 0.05*z
		} // close box LatchCube

#local MainLock =
	cylinder {
		<0, 0, 0.1>
		<0, 0, -1>
		1.25
		texture { Stripe_texture }
		}

#local TrimRing =	
	difference {
		cylinder {
			<0, 0, 0.12>
			<0, 0, -1>
			1.1
			}
	
		plane {
			y
			0
			translate -0.9*y
			}
	
		} // close TrimRing 

#local GlowBalls = union {
	
	#local GBC = 0;
	
	#while (GBC < 8)
		sphere {
			<0, 1.175, 0.1>
			0.03
			rotate (22.5+(45*GBC))*z
			texture { pigment { color White } finish { ambient 0.9 diffuse 0.1 } }
			}
		
		#local GBC = GBC + 1;
	#end 
	} // close union GlowBalls

#local TrimDetails = union {	
	box {
		<-0.005, 1.0999, 0.11>
		<0.005, -0.8999, 0.13>
		texture { Stripe_texture }
		}
	
	box {
		<-0.1, -1, 0.09>
		<0.1, -1.1, 0.11>
		}
	
	} // close union TrimDetails

#local LockChamber =
	difference {
		cylinder {
			<0, 0, 0.15>
			<0, 0, -1>
			0.75
			texture { Stripe_texture }
			}
			
		box {
			<-0.2, -0.8, 0>
			<0.2, 0.8, 0.16>
			texture { Stripe_texture }
			}
		
		plane {
			-z
			0
			translate 0.13*z
			texture { Hull_texture }
			}
		
		} // close difference LockChamber
	
#local LockLight = difference {
	
	difference {
		cylinder {
			<0, 0, 0.104>
			<0, 0, 0.116>
			1.1001
			}
		
		plane {
			y
			0
			translate -0.7*y
			}
		} // close inner difference
		
	plane {
		-y
		0
		translate 0.7*y
		}
		
	texture { pigment { color White } finish { ambient 0.9 diffuse 0.1 } }
	} // close difference LockLight

#local Latches = union {	
	#local LCC = 0;

	#while (LCC < 36)
		object {
			LatchCube
			rotate (10*LCC)*z
			texture { Stripe_texture }
			}
	
		#local LCC = LCC + 1;
	#end
	} //end union Latches
	
#local RedTrim = difference {
	
	cylinder {
		<0, 0, 0.0001>
		<0, 0, -1>
		1.45
		}
		
	difference {
		cylinder {
			<0, 0, 0.1>
			<0, 0, -1.1>
			1.4
			}
		
		cylinder {
			<0, 0, 0.11>
			<0, 0, -1.2>
			1.35
			}
		} // close inner difference
		
	cylinder {
		<0, 0, 0.1>
		<0, 0, -1.1>
		1.27
		}
		
	box {
		<-0.2, -1.5, -1.1>
		<0.2, 1.5, 1>
		}
		
	box {
		<-1.5, -0.2, -1.1>
		<1.5, 0.2, 1>
		}
		
	pigment { p_trek_blood }
	
	} // close difference RedTrim

#local HullText = union {
	
	text {
		ttf "MicrogB.ttf"
		"NCC 84722"
		1,
		0
		scale <0.2, 0.2, 1>
		translate <-2.77, -0.06, -0.999>
		pigment { p_trek_black }
		}
	
	text {
		ttf "MicrogB.ttf"
		"BISBEE"
		1,
		0
		scale <0.2, 0.2, 1>
		translate <1.27, -0.06, -0.999>
		pigment { p_trek_black }
		}

	} // close HullText
		
#local PowerCoupling = union {
	cylinder {
		<0, 0, 0.01>
		<0, 0, -0.5>
		0.25
		texture { Stripe_texture }
		}
		
	cylinder {
		<0, 0.125, 0.0101>
		<0, 0.125, -0.1>
		0.05
		pigment { p_trek_red }
		}
		
	cylinder {
		<0, -0.125, 0.0101>
		<0, -0.125, -0.1>
		0.05
		pigment { p_trek_black }
		}
		
	cylinder {
		<0.125, 0, 0.0101>
		<0.125, 0, -0.1>
		0.05
		pigment { p_trek_yellow }
		}
		
	cylinder {
		<-0.125, 0, 0.0101>
		<-0.125, 0, -0.1>
		0.05
		pigment { p_trek_green }
		}
		
	cylinder {
		<0, 0.125, 0.02>
		<0, 0.125, -0.1>
		0.0375
		texture { T_Copper_3C }
		}
		
	cylinder {
		<0, -0.125, 0.02>
		<0, -0.125, -0.1>
		0.0375
		texture { T_Copper_3C }
		}
		
	cylinder {
		<0.125, 0, 0.02>
		<0.125, 0, -0.1>
		0.0375
		texture { T_Copper_3C }
		}
		
	cylinder {
		<-0.125, 0, 0.02>
		<-0.125, 0, -0.1>
		0.0375
		texture { T_Copper_3C }
		}
		
	} // close union PowerCoupling
	
#local EVAHandle = merge {
	cylinder {
		<0, 0, 0.01>
		<0, 0, -0.2>
		0.15
		texture { Stripe_texture }
		}
		
	difference {
		sphere {
			<0, 0, 0>
			0.13
			}
			
		cylinder {
			<0, 0.14, 0.01>
			<0, -0.14, 0.01>
			0.03
			texture { Stripe_texture }
			}
			
		} // close inner difference
		
	} // close EVAHandle
	

#declare RoundLock = union {

object { MainLock }
object { TrimRing }
object { GlowBalls }
object { TrimDetails }
object { LockChamber }
object { LockLight }
object { Latches }
object { RedTrim }
object { HullText }
object { PowerCoupling scale <0.5, 0.5, 1> translate <1.75, 0.5, 0> }
object { EVAHandle rotate -30*z translate 1.75*x rotate 30*z }
object { EVAHandle rotate -60*z translate 1.75*x rotate 60*z }
object { EVAHandle rotate -120*z translate 1.75*x rotate 120*z }
object { EVAHandle rotate -150*z translate 1.75*x rotate 150*z }
object { EVAHandle rotate 60*z translate 1.75*x rotate -60*z }
object { EVAHandle rotate 120*z translate 1.75*x rotate -120*z }
light_source { 
	<0, 0, -2>, 
	Gray50
	spotlight
	radius 20
	falloff 40
	point_at 0
	} 

} // close union RoundLock
