// trekcolr.inc -- POV-Ray #include file for "standard" Star Trek (original
//   series) colours.
//
// Uniform Color Code -- Starfleet Specification
// Star Fleet Technical Order, authenticated Stardate 7407.04
//   (refer to TM:379260-0, TO:00:10:10)
//
// These values were arrived at by scanning the appropriate page from the
//  technical manual, copying down the RGB values for each colour, and
//  then converting those values into decimal.
//
//==============================================================================
// Numeric colour codes.  Indicated in the technical manual in the format
//  "NSFxxUC", where "xx" is the two-digit colour code.
//

#declare p_trek_01 = pigment { colour rgb <0.650980, 0.670588, 0.690196>}; // silver
#declare p_trek_02 = pigment { colour rgb <0.843137, 0.811765, 0.803922>}; // antimony
#declare p_trek_03 = pigment { colour rgb <0.647059, 0.603922, 0.270588>}; // gold
#declare p_trek_04 = pigment { colour rgb <0.701961, 0.603922, 0.392157>}; // bronze
#declare p_trek_05 = pigment { colour rgb <0.776471, 0.619608, 0.494118>}; // copper
#declare p_trek_06 = pigment { colour rgb <1.000000, 1.000000, 1.000000>}; // white
#declare p_trek_07 = pigment { colour rgb <0.941176, 0.862745, 0.666667>}; // ivory
#declare p_trek_08 = pigment { colour rgb <0.960784, 0.670588, 0.631373>}; // sand
#declare p_trek_09 = pigment { colour rgb <0.670588, 0.000000, 0.000000>}; // blood
#declare p_trek_10 = pigment { colour rgb <0.933333, 0.000000, 0.007843>}; // red
#declare p_trek_11 = pigment { colour rgb <0.964706, 0.537255, 0.043137>}; // orange
#declare p_trek_12 = pigment { colour rgb <0.956863, 0.866667, 0.003922>}; // yellow
#declare p_trek_13 = pigment { colour rgb <0.894118, 0.627451, 0.070588>}; // tenne
#declare p_trek_14 = pigment { colour rgb <0.470588, 0.737255, 0.219608>}; // olive
#declare p_trek_15 = pigment { colour rgb <0.215686, 0.549020, 0.215686>}; // green
#declare p_trek_16 = pigment { colour rgb <0.690196, 0.862745, 0.882353>}; // sky_blue
#declare p_trek_17 = pigment { colour rgb <0.298039, 0.439216, 0.670588>}; // ultramarine
#declare p_trek_18 = pigment { colour rgb <0.352941, 0.247059, 0.588235>}; // blue
#declare p_trek_19 = pigment { colour rgb <0.215686, 0.000000, 0.243137>}; // indigo
#declare p_trek_20 = pigment { colour rgb <0.000000, 0.427451, 0.482353>}; // midnight
#declare p_trek_21 = pigment { colour rgb <0.392157, 0.000000, 0.207843>}; // violet
#declare p_trek_22 = pigment { colour rgb <0.945098, 0.929412, 0.690196>}; // corn
#declare p_trek_23 = pigment { colour rgb <0.968627, 0.823529, 0.662745>}; // tan
#declare p_trek_24 = pigment { colour rgb <0.501961, 0.000000, 0.011765>}; // brown
#declare p_trek_25 = pigment { colour rgb <0.701961, 0.701961, 0.690196>}; // nude
#declare p_trek_26 = pigment { colour rgb <0.643137, 0.000000, 0.345098>}; // purple
#declare p_trek_27 = pigment { colour rgb <0.600000, 0.615686, 0.196078>}; // oxide
#declare p_trek_28 = pigment { colour rgb <0.780392, 0.780392, 0.721569>}; // taupe
#declare p_trek_29 = pigment { colour rgb <0.580392, 0.600000, 0.619608>}; // platinum
#declare p_trek_30 = pigment { colour rgb <0.725490, 0.882353, 0.831373>}; // gray
#declare p_trek_31 = pigment { colour rgb <0.533333, 0.713725, 0.745098>}; // bluegray
#declare p_trek_32 = pigment { colour rgb <0.000000, 0.000000, 0.000000>}; // black

//==============================================================================
// Named colour codes -- makes the POV-Ray source easier to read...
//
#declare p_trek_silver      = pigment { colour rgb <0.650980, 0.670588, 0.690196>}; // 01
#declare p_trek_antimony    = pigment { colour rgb <0.843137, 0.811765, 0.803922>}; // 02
#declare p_trek_gold        = pigment { colour rgb <0.647059, 0.603922, 0.270588>}; // 03
#declare p_trek_bronze      = pigment { colour rgb <0.701961, 0.603922, 0.392157>}; // 04
#declare p_trek_copper      = pigment { colour rgb <0.776471, 0.619608, 0.494118>}; // 05
#declare p_trek_white       = pigment { colour rgb <1.000000, 1.000000, 1.000000>}; // 06
#declare p_trek_ivory       = pigment { colour rgb <0.941176, 0.862745, 0.666667>}; // 07
#declare p_trek_sand        = pigment { colour rgb <0.960784, 0.670588, 0.631373>}; // 08
#declare p_trek_blood       = pigment { colour rgb <0.670588, 0.000000, 0.000000>}; // 09
#declare p_trek_red         = pigment { colour rgb <0.933333, 0.000000, 0.007843>}; // 10
#declare p_trek_orange      = pigment { colour rgb <0.964706, 0.537255, 0.043137>}; // 11
#declare p_trek_yellow      = pigment { colour rgb <0.956863, 0.866667, 0.003922>}; // 12
#declare p_trek_tenne       = pigment { colour rgb <0.894118, 0.627451, 0.070588>}; // 13
#declare p_trek_olive       = pigment { colour rgb <0.470588, 0.737255, 0.219608>}; // 14
#declare p_trek_green       = pigment { colour rgb <0.215686, 0.549020, 0.215686>}; // 15
#declare p_trek_sky_blue    = pigment { colour rgb <0.690196, 0.862745, 0.882353>}; // 16
#declare p_trek_ultramarine = pigment { colour rgb <0.298039, 0.439216, 0.670588>}; // 17
#declare p_trek_blue        = pigment { colour rgb <0.352941, 0.247059, 0.588235>}; // 18
#declare p_trek_indigo      = pigment { colour rgb <0.215686, 0.000000, 0.243137>}; // 19
#declare p_trek_midnight    = pigment { colour rgb <0.000000, 0.427451, 0.482353>}; // 20
#declare p_trek_violet      = pigment { colour rgb <0.392157, 0.000000, 0.207843>}; // 21
#declare p_trek_corn        = pigment { colour rgb <0.945098, 0.929412, 0.690196>}; // 22
#declare p_trek_tan         = pigment { colour rgb <0.968627, 0.823529, 0.662745>}; // 23
#declare p_trek_brown       = pigment { colour rgb <0.501961, 0.000000, 0.011765>}; // 24
#declare p_trek_nude        = pigment { colour rgb <0.701961, 0.701961, 0.690196>}; // 25
#declare p_trek_purple      = pigment { colour rgb <0.643137, 0.000000, 0.345098>}; // 26
#declare p_trek_oxide       = pigment { colour rgb <0.600000, 0.615686, 0.196078>}; // 27
#declare p_trek_taupe       = pigment { colour rgb <0.780392, 0.780392, 0.721569>}; // 28
#declare p_trek_platinum    = pigment { colour rgb <0.580392, 0.600000, 0.619608>}; // 29
#declare p_trek_grey        = pigment { colour rgb <0.725490, 0.882353, 0.831373>}; // 30
#declare p_trek_bluegrey    = pigment { colour rgb <0.533333, 0.713725, 0.745098>}; // 31
#declare p_trek_black       = pigment { colour rgb <0.000000, 0.000000, 0.000000>}; // 32