/*
 * bistex.inc (bisbee.pov)
 *
 * POV-Ray texture descscriptions for the starship U.S.S. Bisbee
 * NCC-84722
 *
 * Some textures 
 * Copyright (c) 1992-1996 Ville Saari
 *   EMail: vs@iki.fi
 *
 * Some textures Written April 1998 by Jeff Lee <shipbrk@gate.net>
 *
 *
 *	Modified for use with Dawn McKnight's Bisbee model
 *
 *		email: d-mcknight@cox.net
 *
 */
 
 #ifndef (p_trek_brown)
 	#include "fjtech.inc"
 #end

#ifndef (F_MetalA)
	#include "metals.inc"
#end

#ifndef (Black)
	#include "colors.inc"
#end

#ifndef (Bis_Nacelle_Rotate)
	#declare Bis_Nacelle_Rotate = 0.5;
#end

/*
 * Colours for the hull of the starship
 */

#declare Hullcol    = color rgb .83;
#declare Stripegray = color rgb .67;
#declare Detailgray = color Gray40;


/*
 * Default texture
 */

default
   {
   pigment { color Hullcol }

   finish
      {
      specular 0.6
      roughness 0.005
      ambient 0.01
      diffuse 0.99
      }
   }

//====================================================================================
// Finishes.  If Quick is defined, no reflection is used, to speed up rendering.
//

#declare f_metallic1 = finish { specular 0.9 roughness 0.05 metallic };

#declare f_metallic2 = finish { phong 0.5 phong_size 25 metallic };

#declare f_metallic3 = finish { phong 1.0 phong_size 200 metallic

  #ifndef (Quick)

    reflection 0.2

  #end

};

#declare f_metallic4 = finish {

  ambient 0.20 diffuse 0.55 brilliance 4.5

  specular 0.8 roughness 0.011 metallic

  #ifndef (Quick)

    reflection 0.6

  #end

};





/*
 * Luminous textures
 */
 
#ifndef (bisbee_power_off)

#declare Window_texture = texture
   {
   pigment { rgb <.27, .33, .33> }

   finish
      {
      ambient 1
      diffuse 0
      specular 0
      }
   };

#declare Light_texture = texture
   {
   pigment { color White }

   finish
      {
      ambient 1
      diffuse 0
      specular 0
      }
   };

//___ Playing with this bussard collector texture, lifted from Jeff Lee's Enterprise code

//------------------------------------------------------------------------------------
// t_NacTip5a: Mostly red, with a tint of orange.  If Quick is defined, this is the
// texture that is used if E1701_Nacelle_Type is set to 2 (the default).
//

#declare p_NacTip5a = pigment { colour rgb <1,0.33,0> }



//------------------------------------------------------------------------------------
// t_NacTip5b: extremely bright orange.
// t_NacTip5c: clear.
// t_NacTip5d: transparent glowing yellow.
// t_NacTip5e: transparent glowing green.
// t_NacTip5f: transparent glowing cyan.
//

#ifndef (Quick)

  #declare p_NacTip5b = pigment { colour rgb <3,2.00,0> }

  #declare p_NacTip5c = pigment { colour rgbt <1,1,1,1> }

  #declare p_NacTip5d = pigment { colour rgbt <2,2,0,0.45> }

  #declare p_NacTip5e = pigment { colour rgbt <0,2,0,0.55> }

  #declare p_NacTip5f = pigment { colour rgbt <0,2,2,0.65> }



//------------------------------------------------------------------------------------
// t_NacTip5g: used for making the "star" on the nacelle.
//

  #declare p_NacTip5g = pigment {

    wood

    pigment_map {

      [0.00 p_NacTip5b]

      [0.20 p_NacTip5c]

      [1.00 p_NacTip5c]

    }

    scale <1.5,4,4>

    translate y*0.65

  }



//------------------------------------------------------------------------------------
// t_NacTip5h: Glowing splotch of yellow which rotates around nacelle tip.
// t_NacTip5i: Glowing splotch of green  which rotates around nacelle tip.
// t_NacTip5j: Glowing splotch of cyan   which rotates around nacelle tip.
//

  #declare p_NacTip5h = pigment {

    wood

    pigment_map {

      [0.00 p_NacTip5d]

      [0.35 p_NacTip5c]

      [1.00 p_NacTip5c]

    }

    scale <4,4,4>

    translate y*0.5

    rotate z*120

  }



  #declare p_NacTip5i = pigment {

    wood

    pigment_map {

      [0.00 p_NacTip5e]

      [0.40 p_NacTip5c]

      [1.00 p_NacTip5c]

    }

    scale <4,4,4>

    translate y*0.60

    rotate z*240

  }



  #declare p_NacTip5j = pigment {

    wood

    pigment_map {

      [0.00 p_NacTip5f]

      [0.35 p_NacTip5c]

      [1.00 p_NacTip5c]

    }

    scale <4,4,4>

    translate y*0.50

  }

#end



//------------------------------------------------------------------------------------
// t_NacTip5Port and t_NacTip5Starboard: Layered textures.  The "stars" stay in place,
// while the glowing splotches rotate around the nacelle tips.  The two textures
// rotate in opposite directions.  If Quick is defined, the textures are just a plain
// red.
//

#ifdef (Quick)

  #declare t_NacTip5Port = texture { pigment { p_NacTip5a }}

  #declare t_NacTip5Starboard = texture { pigment { p_NacTip5a }}

#else

  #declare t_NacTip5Port = 

    texture { pigment { p_NacTip5a } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5a } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5g } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5g rotate z* 72 } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5g rotate z*144 } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5g rotate z*216 } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5g rotate z*288 } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5h rotate z*360*Bis_Nacelle_Rotate} finish { ambient 0.4 }}

    texture { pigment { p_NacTip5i rotate z*360*Bis_Nacelle_Rotate} finish { ambient 0.4 }}

    texture { pigment { p_NacTip5j rotate z*360*Bis_Nacelle_Rotate}

      finish { ambient 0.4 specular 1.0 roughness 0.005 reflection 0.2 }

    }



  #declare t_NacTip5Starboard = 

    texture { pigment { p_NacTip5a } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5a } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5g } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5g rotate z* 72 } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5g rotate z*144 } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5g rotate z*216 } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5g rotate z*288 } finish { ambient 0.4 }}

    texture { pigment { p_NacTip5h rotate z*360*-Bis_Nacelle_Rotate} finish { ambient 0.4 }}

    texture { pigment { p_NacTip5i rotate z*360*-Bis_Nacelle_Rotate} finish { ambient 0.4 }}

    texture { pigment { p_NacTip5j rotate z*360*-Bis_Nacelle_Rotate}

      finish { ambient 0.4 specular 1.0 roughness 0.005 reflection 0.2 }

    }



#end

#declare Bussard_texture = t_NacTip5Starboard;

//====================================================================================
//====================================================================================


/*   
#declare Bussard_texture = 
		texture {
			pigment {	
				gradient z
				scale 3.0306
				color_map {
					[0.0 color Scarlet transmit 0.25]
					[0.3 color Firebrick transmit 0.25]
					[0.7 color Red transmit 0.25]
					[1.0 color OrangeRed transmit 0.25]
					} // close color_map
				} // close pigment// texture pigment/normal pattern
			finish  {
			    ambient 0.8
			    diffuse 0.4
			    reflection 0.1
			    specular 0.8
			    roughness 0.003
			    phong 1
			    phong_size 400
				} // close finish
				
			} // close texture
*/

#declare Glow_texture = texture {
		pigment {
			gradient y
			frequency 2
			color_map {
				[0.0 color Blue]
				[0.5 color CadetBlue]
				[1.0 color Blue]
				} // close color_map
			scallop_wave
			} // close pigment
		finish { ambient 0.9 diffuse 0.1 }
		} // close Glow_texture
   
#end // end of luminous textures with power on


#ifdef(bisbee_power_off)

#declare Window_texture = texture
   {
   pigment { color Black }

   finish
      {
      ambient 0
      diffuse 0
      specular 0
      }
   };

#declare Light_texture = texture
   {
   pigment { color rgbf <1, 1, 1, .9> }

   finish
      {
      reflection .3
      specular 1
      roughness 0.001
      }
   };

#end

/*
 * Starship hull texture
 */

#declare Hull_pigment = pigment
   {
   color Hullcol
   };

#declare Hull_normal = normal
   {
   bumps 0.04
   scale 0.3
   };

#declare Hull_texture = texture
   {
   pigment { Hull_pigment }
   normal { Hull_normal }
   };

#declare Stripe_texture = texture
	{ pigment { color Stripegray } normal { Hull_normal } };
	
#declare Coil_texture = texture
	{ pigment { color Blue } finish { F_MetalA } };
	
#declare HazeGrey = // This is the BB_Tex from "First Strike at Pearl" renamed.
texture {
	pigment { color rgb <121, 140, 150>/255 }
	finish {
		ambient <.5,.77,1>*.1
		diffuse .6
		phong .5
		phong_size 10
		} // close finish
	normal { bumps .07 scale 7 }
	}; // close texture 


#declare t_grille = texture { // taken from Jeff Lee's Enterprise code

  pigment { Detailgray }

    finish { phong 0.5 phong_size 25 metallic }

    normal { gradient x 0.1 frequency 20 translate <-100,0,0> }

}; // close t_grille

#declare t_deflec_tex = 
	texture { // t1
		pigment {
			radial
			rotate -90*x
			color_map {
				[0.0 color White ]
				[1.0 color Blue ]

				} // close color_map
			triangle_wave
			frequency 80

			} // close pigment
			finish { ambient 0.8 diffuse 0.6 }
		}; // close t1



#declare t_sensor_dish = texture {

  pigment { p_trek_brown }

  finish { f_metallic3 }

};

#declare t_sensor_antenna = texture {

  pigment { p_trek_silver }

  finish { f_metallic3 }

}


#declare t_sensor_bay = texture {

  pigment { p_trek_copper }

  finish { f_metallic4 }

}

