// Persistence of Vision Ray Tracer Include File
// File: bisbee.inc
// Vers: 3.5 for Macintosh
// Desc: Tucson Class Starship
// Date: 30 June 2002
// Last: 07 August 2003
// Auth: Dawn McKnight (d-mcknight@cox.net)

/*

POV-Ray Scene Description file for Tucson class starships.  
Originally written to represent USS Bisbee, it can easily be
modified to allow for any ship of the class to be  presented.

This file, this ship, and the author owe a great debt of gratitude
to Mr. Ville Saari, and his 'Big E' project, from which I have stollen
(with his permission) various details and inspiration.

Likewise Mr. Jeff Lee, who permitted me the pleasure of looking at the code 
for his original series Enterprise.

Tony LaVigne was of immense help with mathematics... without him, the windows
in the saucer section would never have been placed properly.

The remainder of the work is mine.  Anything you may find pleasing about
the ship is likely to be borrowed from someone else; anything you dislike, probably mine.

The Tucson class is inspired by a drawing found on page 118 of the
book 'Star Trek: The Next Generation.  Sketchbook for the Movies Generations
and First Contact.'

It has been substantially altered, and becomes an original work.  You may use 
this model in any scene for personal use; it may not be modified, nor used for
any commercial purpose, without written permission from the author.

Scale: 1 unit = 1 meter

*/

#ifndef (Blue)
	#include "colors.inc"
#end

#ifndef(Cylinder_Y)
   #include "shapes.inc"
#end

#ifndef(Hull_texture)
   #include "bistex.inc"
#end

#ifndef (T_Yellow_Glass)
	#include "glass.inc"
#end 

#ifndef (NavLight)
	#include "navlight.inc"
#end 



#include "bistex.inc"
#include "lock.inc"
#include "navlight.inc"
#include "saucer.inc"
#include "sechull.inc"
#include "nacelle.inc"


#declare Tucson	= union {			
	object { Sec_Hull }
	object { Saucer }
	object { STBDWing translate <17.4, 3, -50> }
	object { PORTWing translate <-17.4, 3, -50> }
	} // close union Tucson 
