//*****************************************************************************************************************************
// scene environment
//*****************************************************************************************************************************
#version unofficial MegaPov 0.7;
#declare pov = <-10,5,-10>;     
#declare poi =  <-5,0,-5>;
            
global_settings {
	max_trace_level 128
}

#declare _landscape = function { "ridgedmf",<0.5,1.2,10,1,1> }

#declare T_Rock = texture {
	pigment {
		//function { _landscape(x,y,z)-y }
		rgb 1
		
	}
	finish {
		diffuse 1
		ambient 0
	}
}

#local r25=seed(25);
#local xc=-40;
#while (xc<=40)
	#local zc=-40;
	#while (zc<=40)
		isosurface {
			function {
				_landscape(x*2,0,z*2)/5-y
			}
			//eval
			max_gradient 10
			accuracy 0.001
			sign -1
			contained_by { box { <xc-0.45,-10,zc-0.45>,<xc+0.45,1,zc+0.45> } }
			texture { T_Rock }
			hollow
			translate y*rand(r25)
		}
		#local zc=zc+1;
	#end
	#local xc=xc+1;
#end

#include "hsi_rgb.inc"
#local r26=seed(26);
#local r25=seed(25);
#local xc=-40;
#while (xc<=40)
	#local zc=-40;
	#while (zc<=40)
		box { <xc-0.445,-10,zc-0.445>,<xc+0.445,1,zc+0.445>
			interior {
				ior 1.5
				fade_distance 0.5
				fade_color hsi2rgb(<rand(r26),1,1>)
				fade_power 2
			}
			texture {
				pigment {
					rgbt 1
				}
				finish {
					diffuse 1
					ambient 0
					specular 1
				}
			}
			hollow
			translate y*rand(r25)
		}
		#local zc=zc+1;
	#end
	#local xc=xc+1;
#end

camera {
  location pov
  sky vrotate(y,z*10)
  right vrotate(x*4/3,z*10)
  look_at poi
}        

light_source { y*100 rgb 1 }

fog {
	fog_type 1
	distance vlength(poi-pov)
	colour rgb 0
}
