#version 3.7;
global_settings{ assumed_gamma 1.0 }
#default{ finish{ ambient 1 diffuse 0 emission 0}} 
#include "gradients.inc"
#include "functions.inc"
#include "math.inc"
// +a0.1 +w800 +h800

/*==
Together with func_studio.inc a simple studio to play with functions
and patters. The function used should be named Test and Pf is the 
function pattern used to show what a function does. For complex stuff
like blending pattern functions it's not realy suitable.

The main square shows the modified (scaled) pattern. The left side box
shows continuation of unmodified Input pattern. The first box at the
bottom shows gadient as modified by functions. The second box at the
bottom shows an unmodiefied gradient and, if switched on, thefrequency
of densities, ranged 0-1 based on maximum density count.

Scale, float: scales the pattern
ShowCurve, true/false: shows the resulting curve of the function
Frequency, true/false: shows an indication of the frequency of densities.
Grid, true/false: shows a 10x10 grid
==*/


/*
Identity function
out=in, takes a pattern function as input and
does not modify it for output
*/

#declare Test = function(Pf){Pf}; 
 
/*
G_smoothstep, G_smootherstep, G_smootheststep(val,low,high)
everything below the low value will be white, above the
high val will be black. In between will be a gadient,
smoothness depends on the chosen function
*/

//#declare Test = function(Pf){G_smoothstep(Pf,0.3,0.7)};

/*
a value of 0 for low and 1 for high manipulates contrast, 
but there is no way to infuence the curve
*/

//#declare Test = function(Pf){G_smoothstep(Pf,0,1)};

/*
a better way to manipulate contrast is with the gain function
G_gain(val,gain). Gain 1 gives the identity curve seen above out = in
gain >1 give an contrast increase (S-curve)
gain <1 and >0 gives a contrast decrease
*/

//#declare Test = function(Pf){G_gain(Pf,1)};
//#declare Test = function(Pf){G_gain(Pf,3)};
//#declare Test = function(Pf){G_gain(Pf,.7)};

/*
'selecting' a certain range, pusing everthing outside to black. 
Selecting multiple ranges or ranges with overlap and tone down
the second peak.
*/

//#declare Test  = function(Pf){
//   ((G_smoothstep(Pf,0.2,0.3)-G_smoothstep(Pf,0.3,0.8)))
//};

//#declare Test  = function(Pf){
//   (G_smoothstep(Pf,0.1,0.15)-G_smoothstep(Pf,0.15,0.2))
//  +(G_smoothstep(Pf,0.4,0.6)-G_smoothstep(Pf,0.7,.9))
//};

//#declare Test  = function(Pf){
//   (G_smoothstep(Pf,0.3,0.4)-G_smoothstep(Pf,0.4,0.5))
//  +(G_smoothstep(Pf,0.45,0.55)-G_smoothstep(Pf,0.55,0.65))*0.5
//};

/*
Instead of using multiple smoothsteps use a cubic_pulse function.
G_cubic_pulse(Pf,Centre,Half_Width)
*/

//#declare Test  = function(Pf){
//  G_cubic_pulse(Pf,.5,.1)
//}

//#declare Test  = function(Pf){
//  // G_step_in pushes everything 'selected' by G_cubic to white
//  // the 0.15 multiplier pushes that selected range back to 0-0.15
//  G_step_in(G_cubic_pulse(Pf,.2,.1),0) 
// +G_cubic_pulse(Pf,.5,.1)*0.15
// +G_cubic_pulse(Pf,.8,.1)
// +(G_cubic_pulse(Pf,.95,.1)*0.5)
//}

//#declare Input = f_gradientX;
#declare Input = f_noise3d;
//#declare Input = f_checker;
//#declare Input = f_wood;
//#declare Input = f_agate;
//#declare Input = f_leopard;
//#declare Input = function{
//  (1-G_smootherstep(f_noise3d(x*3,y*3,z),0,f_wood(x,y,z)))
//  +
//  (G_smootherstep(f_noise3d(x*3,y*3,z),f_wood(x,y,z)*0.3,1)*f_granite(x,y,z))
//};

#declare Scale = .1;
#declare ShowCurve = true;
#declare Frequency = true;
#declare Grid = false;

// apply the test function to the input pattern
#declare pTest = pigment {function{
    Test(Input(x,y,z))
  }
  //warp{turbulence 0.6 octaves 10}
  //warp{turbulence 0.4 octaves 10 lambda 0.3 omega 0.3}
  //rotate<0,90,0>
  scale Scale
}
#declare gTest = pigment {function{Test(f_gradientX(x,y,z))}}

// applies the Test function to the input pattern
// generates the image 
#include "func_studio.inc"