
// switch for curve
#if (ShowCurve = true)
  #declare Curve = function(I){Test(I)};
#end

//main box, shows the modified (scaled) pattern
box {
  <0,0,0>, <1,1,0>
  texture {pigment{pTest}}
  translate<-0.5,-0.5,0>
}

// left side box
// shows continuation of unmodified Input pattern
box {
  <0,0,0>, <.2,1,0>
  texture {pigment{function{Input(x,y,z)} scale Scale translate x*0.21}}
  translate<-0.71,-.5,0>
}

// bottom, shows gadient as modified by functions
box {
  <0,0,0>, <1,.1,0>
  texture {pigment{gTest}}
  translate<-0.5,-.62,0>
}

// bottom, shows unmodiefied gradient and frequency of
// values, ranged 0-1 based on maximum count. 
box {
  <0,0,0>, <1,.1,0>
  texture {pigment{function{f_gradientX(x,y,z)}}}
  translate<-0.5,-.74,0>
}

// plots the curve of the function(s)
#ifdef(Curve)
  #for (I,0,1,0.0001)
    sphere{
      <I, Curve(I),0>,0.005 no_shadow 
      translate <-0.5,-0.5,0>pigment{rgb <.75,0,0>}
    }
  #end
#end

// 10x10 grid 
#if(Grid=true)
  #for(Y,0,1,0.1)
    cylinder{<0,Y,0>,<1,Y,0>,0.002 no_shadow translate<-0.5,-0.5,0>}
  #end                                                           
  #for (X,0,1,0.1)                                               
    cylinder{<X,0,0>,<X,1,0>,0.002 no_shadow translate<-0.5,-0.5,0>}
  #end
#end 

// frequency of values (indicative)
#if (Frequency)
  #declare Grays = array[256];
  #declare DimGrays = dimension_size(Grays,1)-1; 
  #for(I,0,DimGrays,1)
    #declare Grays[I]=0;
  #end
  #declare Res = 400;
  #declare Points = Res*Res;
  #declare Step = 1/Res;
  #declare HalfPixel = 1/(2*Res);
  #for(X,HalfPixel,1-HalfPixel,Step)
    #for(Y,HalfPixel,1-HalfPixel,Step)
      #declare Val = floor(Test(Input(X/Scale,Y/Scale,0))*255);
      #declare Grays[Val]=Grays[Val]+1;
    #end
  #end 
  #declare Max = 0;
  #for(I,0,DimGrays,1)
    #if (Max<Grays[I])
      #declare Max = Grays[I];
    #end
  #end
  #for(I,0,DimGrays,1)
    cylinder{
      <-0.5+ I/256    ,(adj_range2(Grays[I],0,Max,0,0.1))-0.74,-1>,
      <-0.5+ (I+1)/256,(adj_range2(Grays[I],0,Max,0,0.1))-0.74,-1>,
      0.003 
      pigment{rgb x}
    }
  #end
#end

camera {
  orthographic
  location <-0.1,-0.125,-1>
  look_at  <-0.1,-0.125,0>
  angle 65
  right    x*image_width/image_height
} 


