// (C) 2004 Rafal Maj Raf256 www.raf256.com  
// +a0.03 +am2 +r2  
// 0.10~

#local OPT_TEST = 0;


#if (OPT_TEST)
  camera { location <0,0,-60> look_at 0 angle 60 }
  light_source { <-50,80,-90> rgb 1 }
  global_settings { max_trace_level 250 }
#end






#macro makeBohrium(_L,_SEED) 
#local RND = seed(_SEED);
#local _T = 42;

union {

#macro makeNucleus(C,_L) 

  sphere { 0 1.0    
    //pigment { rgb C*.7+<.2,.1,.2> filter .8 transmit .2 }
    pigment { rgb C*.7+<.3,.2,.3> filter 0 transmit 0 }  
    
    finish { ambient .3 phong .8 phong_size 60 }
    
    /*interior { 
      fade_color .020 * (C*0.3+0.7)
      fade_power 2
      fade_distance 2/_L
      media { 
        emission .020 * (C*0.3+0.7) * _L
        density { 
          bozo color_map{[0 rgb .2][.5 rgb .6][1 rgb 1]}
          warp { turbulence 2 octaves 5 lambda 1.3 omega 0.3 }
          translate 47-_T
        }
        scale .4
      }
    }
    hollow
    */
  }
  
  #if (0) // glow
  sphere { 
    0 3
    //pigment { rgbf 1 }
    pigment { rgb .020 * (C*0.3+0.7) }
    
    interior { 
      //fade_color .020 * (C*0.3+0.7)
      //fade_power 2
      //fade_distance 1/_L
      /*media { 
        emission .0003 * (C*0.7+0.3) * _L
        density { 
          bozo color_map{[0 rgb .2][.5 rgb .6][1 rgb 1]}
          warp { turbulence 2 octaves 5 lambda 1.3 omega 0.3 }
          translate 47-_T+<34,75,32>
        }
        scale .4
      }*/
    }
    hollow
  }
  #end 
   
  
  #macro makeQuark(R,C,_L)  
  sphere { 
    x*0.55 .20 rotate z*120*R
    pigment { rgbf 1 }  
    interior { 
      /*media { 
        emission .35*(0.5 + C*0.5) * _L  *3
        density { 
          bozo color_map{[0 rgb 0][.5 rgb .4][1 rgb 1]}
          scale .5
          warp { turbulence 2 octaves 5 lambda 1.5 omega 0.5 }
          translate -2+_T
        }
        scale .8
      }*/
    }
    hollow
  }
  #end
  
  /*union {
    makeQuark(0,x,_L)
    makeQuark(1,y,_L)
    makeQuark(2,z,_L)
    rotate <rand(RND),rand(RND)*0,rand(RND)> * 360
  } */   
#end // makeNucleus(C)

  
 /*union { 
 #local I=0; #while (I<=50)
      #local C=x; #if (rand(RND)<.5) #local C=z; #end
      union { 
        makeNucleus(C , _L) 
        translate x*3+0.3*rand(RND)  
        rotate y*rand(RND)*180
        rotate x*rand(RND)*360 
      }
  #local I=I+1; #end    
  }*/
  
  
  union {
    #local I=0; #while (I<280)
      #local C=x; #if (rand(RND)<.5) #local C=z; #end
      #local Y=rand(RND)*2-1;
      #local RY = pow(1-pow(Y,2), 1/2);
      #local W = vrotate(x*RY,  y*rand(RND)*360) + y*Y*1;
      object { 
        makeNucleus(C , _L*pow(3,2)) 
        scale 1/3 * (1.10 + 0.16 * rand(RND) )
        translate W*2  
      }
    #local I=I+1; #end     
  }
  
   
  
}

#end


#if (OPT_TEST)
  object { 
    makeBohrium(1, 1000+clock)
    scale 5
  }
  
#end






