// (C) 2004 Rafal Maj Raf256 www.raf256.com/povray/
// ver 0.40.10 (miles >7)

// aspect ratio is 1,066666
// +w320 +h300 
// +w533 +h500

// +FP +w533 +h500 +a0.03 +am2 +r2 +SC0.0 +EC1.0 +SR0.5 +ER1.0
// +SC0.0 +EC1.0 +SR0.0 +ER1.0
// +FP +w1066 +h1000 +a0.03 +am2 +r2 +SC0.0 +EC1.0 +SR0.0 +ER1.0


// --- needed files ---
#declare NEED_INC_DETECTOR = "share/detector.v50.inc";
#declare NEED_INC_BOHRIUM = "share/bohrium.v20.inc";
#declare NEED_TTF_ARIAL_BLK = "ariblk.ttf";

#declare NEED_IMG_NIEWODN = "data/niewodn_c3.png"  
#declare NEED_IMG_BGR_TUNEL = "data/bgr/lumi-tunel1.png"; 
#declare NEED_IMG_BGR_CER = "data//bgr/cer5.png";

#declare NEED_HF_NIEWODN = "data/niewodn_hf.png"  
#declare NEED_HF_IFJ = "data/ifj_hn2.png";
#declare NEED_HF_KRAKOW = "data/krakow.png";         

// --- setup environment ---
#declare ENVIR_WIN = 0; // <-- where from take fonts, windows=1 other=0

// --- setup quality ---
#declare QQ_AREA = 0; // 2
#declare QQ_RAD  = 0; // 2
#declare QQ_HF   = 0; // 1=smooth
#declare QQ_ENVT = 0; // 1 bacground textures

// --- setup objects ---
#declare QO_Bohrium = 1; 
  #declare QO_Bohrium_Electrons_1 = 1;
  #declare QO_Bohrium_Electrons_2 = 1;
#declare QO_Detector = 1; 
#declare QO_Groove = 1;
#declare QO_I = 0;
  #declare QO_I_Point = 1;
#declare QO_F = 0;
#declare QO_J = 0;
  #declare QO_J_Point = 1;

// --- setup mode ---
#declare QMOD_Contour = 0;

#if (1) // BiG (or small)
  #declare CfgHoleR=0.18; 
#else
  #declare CfgHoleR=0.20; // bigger holes are for small version of image probably
#end

#if (QMOD_Contour) // only main contours
  #declare QO_Bohrium = 0;  
  #declare QO_Detector = 0;
  #declare QO_Groove = 0;
  #declare QQ_RAD   = 0;  
  #declare QQ_AREA  = 0;  
  #declare QQ_ENVT  = 0;
#end


#macro RES_FONT(_S) 
  #if (ENVIR_WIN) _S #else concat("data_win/",_S) #end
#end

#macro POO() pigment {rgb x} finish {ambient .3} #end

camera {
  location <0, 0, -30>
  look_at <0,0,0>
  translate <1.5,0,0>
  angle 43
  up y*1
  right x*(image_width/image_height)
}
                
#local DAF_AMB=0.2;
global_settings {
  assumed_gamma 2.2
  max_trace_level 32
  adc_bailout 1/128
  
  #if (QQ_RAD)  #local DAF_AMB=0;
    #if (QQ_RAD=1)
      radiosity { 
        count 100 error_bound 1.50 max_sample 5  media 1 normal 1
        pretrace_start 1/64  pretrace_end 1/96  low_error_factor 0.80
        recursion_limit 3 adc_bailout 1/40 minimum_reuse 0.015
      }
    #end  
    #if (QQ_RAD=2)
      radiosity { 
        count 250 error_bound 0.90 max_sample 20  media 1 normal 1
        pretrace_start 1/64  pretrace_end 1/120  low_error_factor 0.80
        recursion_limit 3 adc_bailout 1/90 minimum_reuse 0.008    
      }
    #end  
    #if (QQ_RAD=3)
      radiosity { 
        count 800 error_bound 0.50 max_sample 50  media 1 normal 1
        pretrace_start 1/64  pretrace_end 1/200  low_error_factor 0.80
        recursion_limit 3 adc_bailout 1/120 minimum_reuse 0.006    
      }
    #end  
    #if (QQ_RAD=4)
      radiosity { 
        count 900 error_bound 0.40 max_sample 80  media 1 normal 1
        pretrace_start 1/64  pretrace_end 1/250  low_error_factor 0.70
        recursion_limit 4 adc_bailout 1/200 minimum_reuse 0.004
      }
    #end  
    #if (QQ_RAD=5)
      radiosity { 
        count 1600 error_bound 0.30 max_sample 100  media 1 normal 1
        pretrace_start 1/64  pretrace_end 1/300  low_error_factor 0.70
        recursion_limit 5 adc_bailout 1/230 minimum_reuse 0.003
      }
    #end  
  #end
}
default { finish { ambient DAF_AMB } }

background { rgb .1 }

#local TEX1 = NEED_IMG_BGR_TUNEL; 
#local TEX2 = NEED_IMG_BGR_CER;

sphere { 0 2000
  pigment { 
    uv_mapping
    #if (QQ_ENVT)  image_map { png TEX1 } #else rgb .4 #end
    //translate 1/2    
    scale 1/2  
  } 
  finish { diffuse 0 ambient .82 }
  hollow
}

#if (1)
box { -1000,+1000
  pigment { 
    uv_mapping
    #if (QQ_ENVT)  image_map { png TEX2 transmit all .5 } #else rgb .4 #end
    //translate 1/2  scale 1/2  
  } 
  finish { diffuse 0 ambient .82 }
  hollow
}
#end



plane { z,1 
  pigment {
    spherical
    scale 35
    color_map{[0 rgb .3][.5 rgb 1][1 rgb 1]}
  }  
  finish { diffuse .85 
    #if (QMOD_Contour) ambient 1
    #else ambient .4 
    #end
    brilliance .3 
  }
  hollow
}

light_source {
  <-400,700,-600>
  rgb 1  
  #if (QQ_AREA) 
    area_light x*1200 y*1200, 
    #if (QQ_AREA=1) 12,12  adaptive 1 #end
    #if (QQ_AREA=2) 24,24  adaptive 3 #end
    orient circular jitter  
  #end
}



union {
  #local DEP =0.18;
  #local DEP2=0.12;  #local R2 = 0.122;
  
  
  #if (QO_I | QO_I_Point)
  union { // i       
  
    #local C=<0.10,0.50,0>;  #local BallC1=C; // i *
    #if (QO_I_Point)
    difference {    
      union {
        cone { C+z*DEP2, 0.12 C, 0.12 }   sphere { 0 0.12 scale <1,1,.5> translate C }
      }     
      sphere { 0 R2 scale <1,1,1> translate C-z*0.10 }
    }
    #end // i *
    
    #if (QO_I) // j (ttf/main)
    difference { 
      box { <0,0,0> <0.20,0.50,DEP> }
      cone { C+z*DEP+z*0.01, CfgHoleR C-z*0.01,  CfgHoleR }
    }
    #end // i (ttf/main)
    
    #local Move_I = <-0.2,0,0>; 
    translate Move_I
  }
  #end
  
  #if (QO_F)
  difference { // f
    text { ttf RES_FONT(NEED_TTF_ARIAL_BLK) "f" DEP, 0  translate<  0  ,  0  , 0 >  }
    
    #if (QO_Groove) // --- groove F ---
    height_field { 
      png NEED_HF_IFJ
      
      #if (QQ_HF) smooth #end
      rotate -x*90
      scale <1,1,-1>
      scale .23*<1.00, 1.10, 0.25> translate < 0.075, 0.20 ,0> translate -z*0
    }
    
    height_field { 
      png NEED_HF_KRAKOW
      #if (QQ_HF) smooth #end
      rotate -x*90
      scale <1,1,-1>
      scale .13*<1.00, 0.33, 0.09> translate < 0.110, 0.26 - 0.05 ,0> translate -z*0
    }
    #end // --- groove F ---
    
        
    box { <0,-.1,-.2> <.2,1,.2> translate x*-.125 }
    box { <0,-.1,-.2> <.2,.53,.2> translate x*+0.272 }
  }     
  box { 0,1
    rotate -x*90
    translate -y*.5
    scale <1,2,-0.9>
    scale .23*<0.85, 1.10, 0.25> translate < 0.075, 0.26 ,0> translate +z*0.01
    pigment { rgb <0.1, 0.22, 1.0>*0.7 }
    finish { ambient .33 diffuse .7 metallic .8 brilliance 2 }
  }   
  #end
  
  
  
  #if (0)
  height_field { png NEED_HF_NIEWODN
  //box { 0,1
    pigment { image_map { png NEED_IMG_NIEWODN } rotate x*90 }
    //smooth
    rotate -x*90
    scale <1,1,1>
    scale .15*<1.00, 1.30, 0.10> translate < 0.10 , 0.05 ,0> translate -z*0.000
  }
  #end

  
   
  #if (QO_J | QO_J_Point)
  union { // j    
  
    #local C=<0.00,0.30,0>;  #local BallC2=C;   
    #if (QO_J_Point) // j *
    difference {    
      union {
        cone { C+z*DEP2, 0.12 C, 0.12 }   sphere { 0 0.12 scale <1,1,.5> translate C }
      }               
      sphere { 0 R2 scale <1,1,1> translate C-z*0.10 }
    }  
    #end // j *
    
    #if (QO_J) // j (ttf)
    difference {
      intersection {
        union {
          difference { 
            text { ttf RES_FONT(NEED_TTF_ARIAL_BLK) "j" DEP, 0  translate<  0  ,  0  , 0 >  scale <2, .6, 1> }  
            box { <0,-.15,-.2> <.15,0,.2> translate x*-0.0 }
            box { <0,-.20,-.2> <.3,.5,.2> translate x*0.38 }
            box { <0,.3,-.2> <.2,.5,.2> translate x*0.2 }
          }
          scale <1.1 ,1 ,1>
          translate -x*0.04
        }  
        union {
          cylinder { +z*DEP+z*0.01, -z*0.01, 0.22  scale<1,1.1,1> translate <0.22,0.12,0> }
          cylinder { +z*DEP+z*0.01, -z*0.01, 0.22  scale<1,1.1,1> translate <0.19,0.30,0> }
        }
        translate <-0.30,0,0>
        scale <1.30, 0.95, 1>  
      }
      cone { C+z*DEP+z*0.01,  CfgHoleR C-z*0.01,  CfgHoleR }
    }
    #end // j (ttf)
        
    #local Move_J = <+0.45,-0.10,0>; 
    translate Move_J     
  }
  #end
  
  #local traCycl = transform {
    rotate x*90
    scale <0.8, 0.32 , 0.45>
    translate <0.15, 0.35, 0.02>
  }
  
  difference { // cyclotron rings - Balls
  
    union { // cyclotron rings
    
    
      /*difference { // outer cyclotron - nails etc
        union {  
          torus { 0.6 .005 translate <-1.5,0,0> / 50}
          transform { traCycl }
          translate <0,4,0>/50
        }
        box { 
          <-0.08,-0.023, -0.10>, <+0.03,+0.021,+0.20> 
          rotate x*45  translate < 0.65, 0.36, 0> 
        }
        pigment { rgb .6 }   
        hollow
      }*/
          
  
      difference { // outer cyclotron
        difference {  torus { .6 .04 }  torus { .6 .03 }   transform { traCycl }  }
        box { 
          <-0.08,-0.022, -0.10>, <+0.03,+0.015,+0.20> 
          rotate x*45  translate < 0.65, 0.36, 0> 
        }   
        hollow
      }
      
      difference { // inner cyclotron
        difference {  torus { .6 .02 }  torus { .6 .011 }   transform { traCycl }  }
        box { 
          <-0.08,-0.02/2, -0.08>, <+0.03,+0.02/2,+0.15> 
          rotate x*45  
          translate < 0.65, 0.36, 0> 
        }   
        hollow
        pigment { rgb .8*<.2, 1, .45> }
        finish { specular .5 roughness 0.003  metallic  brilliance 1.5  
          reflection { .2 metallic } 
          diffuse .7
        }
      }
        
      #local C = <1.0, 0.6, 0.01>;  
      union { // beems i+o
        torus { .6 .005 // beem-i
          pigment { rgbf 1 }
          interior{media{
              emission C * 110
              density { bozo color_map{[0 rgb .1][1 rgb 1]} scale .008 }
          }}hollow
        }
        torus { .6 .011 // beem-o
          pigment { rgbf 1 }
          interior{media{
              emission C * 30
              density { bozo color_map{[0 rgb .1][1 rgb 1]} scale .009 translate 3 }
          }}hollow
        }
        torus { .6 .018 // beem-oo
          pigment { rgbf 1 }
          interior{media{
              emission C * 0.005
              density { bozo color_map{[0 rgb .1][1 rgb 1]} scale .020 }
          }}hollow
        }

        // beem-glow-sphere(s)        
          sphere { 0 .040 
            pigment { rgbf 1 }
            interior{media{emission <1,.9,.3> * .1
            density { bozo color_map{[0 rgb 0][.5 rgb .3][1 rgb 1]} scale .010 }}}
            scale <0.8,1,1>  translate x*.6 + z*0.030 
            hollow
          }  
        
        
        transform { traCycl }
      } // beems i+o
      
      
    } // cyclotron rings
    
    union { // balls holes
      sphere { 0 R2 scale <1,1,1> translate Move_I+BallC1-z*0.10 }
      sphere { 0 R2 scale <1,1,1> translate Move_J+BallC2-z*0.10 }      
    }  
    
  } // cyclotron rings - balls holes 
   
  
  #if (0)
  light_source { 
    <0.60,0,0> + <-1,0,+1>*0.015 .3 transform { traCycl } 
    fade_power 2  fade_distance 1
  }
  light_source { 
    <0.60,0,0> + <+1,0,-1>*0.015 .3 transform { traCycl } 
    fade_power 2  fade_distance 1
  }
  #end
    
  translate <-.1,-.2,0>
  scale 20*<1 , 1, .3>
  
  pigment { rgb <0.25, 0.65, 1.0> }
  finish { 
    diffuse .8 brilliance 1.1 ambient .21 reflection { .23 .38 metallic .35 }
    specular 0.6 roughness 0.006
  }
}
  



#if (QO_Detector) // ================= QO_Detector

#declare OPT_LIGHT = QQ_AREA * 0;
#include NEED_INC_DETECTOR

union {
  object { 
    objDetector 
    scale .08  
  }
  #local C = <1, 0.9, 0.3>      * 0.050;      
  #local C2=(<1, 0.9, 0.3>+0.4) * 0.050;      
  
  /*sphere { 0 1 pigment { rgbf 1 } // glow
    interior{media{
        emission C * 0.01
        density { bozo color_map{[0 rgb .1][1 rgb 1]} scale .04 translate -34 }
  }}hollow}
  
  sphere { 0 0.4 pigment { rgbf 1 } // glow
    interior{media{
        emission C * 0.40
        density { bozo color_map{[0 rgb .1][1 rgb 1]} scale .08 }
  }}hollow}
  */  


  sphere { 0 1 pigment { rgbf 1 } // glow
    interior{media{
        emission C2 * 35
        density { spherical }
  }} scale 0.37 hollow}
  
  sphere { 0 1 pigment { rgbf 1 } // glow
    interior{media{
        emission C * 70
        density { bozo color_map{[0 rgb 0][1 rgb 1]} scale .3}
  }} scale 0.15 hollow}
  
  scale 1.2

  
  translate <+6.93,-0,0> - z*0.85
}

#end  // ================= QO_Detector 




#if (QO_Bohrium) // ================= QO_Bohrium


#include NEED_INC_BOHRIUM
union {
  
  object { // atom
    makeBohrium(8,1006)
    clipped_by { sphere { 0 3 } }
    bounded_by { clipped_by }
    scale .45
  }
  
  sphere { // inner fill of atom 
    0 1 
    pigment { rgb <1, 0.7, 0.9> transmit .6  }
    finish { ambient .5 diffuse 0 }
    interior {
      media {
        density { spherical color_map{[0 rgb .5][1 rgb 1]}}
        emission 0.01*<1,.5,1>
      }
    }
    scale .8
    hollow
  }
  
  #if (QO_Bohrium_Electrons_1 | QO_Bohrium_Electrons_2)  // electrons
  union {
    /*
    torus { 1.8 .042 rotate x*(90+45) rotate y*+80  scale <1, 1, .75> }
    torus { 1.8 .042 rotate x*(90+45) rotate y*-80  scale <1, 1, .75> }
    torus { 1.7 .042 rotate x*(90+80+5) rotate y*-00  scale <1, 1, .75> }
    */
    
    
    #local C  = < 1.0, 0.9 , 0.06>; // color - media
    #local CR = < 1.0, 0.5 , 0.04>; // color - media / red
    #local C2 = <0.70, 0.70, 0.30, 0.40, .20>; // color - pigment rgbft
    #local RR = 0.040;
    
    #local RND = seed(6546); // err
    
    
    #local A1=0;
    #macro makeTrak(R, RX,RY,RZ,ERR)
      torus { R 0.60*RR*ERR rotate x*RX rotate +y*RY rotate z*RZ  hollow }
      
      torus { R 1.20*RR*ERR rotate x*RX rotate +y*RY rotate z*RZ  hollow 
        pigment { rgbf 1 }
        interior {media{ emission <1,.7,.02>*1}}
      }

      torus { R 2.30*RR*ERR rotate x*RX rotate +y*RY rotate z*RZ  hollow 
        pigment { rgbf 1 }
        interior {
          media { 
            emission <1,.4,.01>*20
            density {
              bozo
              color_map{[0 rgb .03][.5 rgb .03][.8 rgb 0.10][1 rgb 1]}
              scale .3
            }
          }
        }
      }
    #end
    
    #macro makeElectron()
    union {
      sphere { 0 1+0.02*rand(RND) pigment { rgbt <1,1,.3,.7> } interior { media { emission 7.0*CR  density {spherical} } } scale 0.120  }
      sphere { 0 1+0.02*rand(RND) pigment { rgbf 1 } interior { media { emission 1.3*CR+0.2 density {spherical} } } scale 0.330  }
    }    
    #end
        
    #if (QO_Bohrium_Electrons_2)
      makeTrak(3, 90,90,  0+A1, 1.01)
      makeTrak(3, 90,90, 60+A1, 1.02)
      makeTrak(3, 90,90,120+A1, 1.03)
      
      object { makeElectron() translate x*3.0 rotate y*+27 rotate x*(90) rotate +y*90 rotate  z*(A1+0) }
      object { makeElectron() translate x*3.0 rotate y*-65 rotate x*(90) rotate +y*90 rotate  z*(A1+0) }
      
      object { makeElectron() translate x*3.0 rotate y*+19 rotate x*(90) rotate +y*90 rotate  z*(A1+60) }
      object { makeElectron() translate x*3.0 rotate y*-98 rotate x*(90) rotate +y*90 rotate  z*(A1+60) }
      
      object { makeElectron() translate x*3.0 rotate y*+45 rotate x*(90) rotate +y*90 rotate  z*(A1+120) }
      object { makeElectron() translate x*3.0 rotate y*-235 rotate x*(90) rotate +y*90 rotate  z*(A1+120) }      
    #end  
    
    #if (QO_Bohrium_Electrons_1)
      #local A2=0;                                                            
      makeTrak(1.4, 90,0,0, 0.99)
      
      object { makeElectron() translate x*1.4 rotate z*(50) }      
      object { makeElectron() translate x*1.4 rotate z*(50+180) }      
    #end  

    
    pigment { rgbft C2 }
    finish { diffuse 0 ambient .8 }
    interior { media { emission 0.4*C } }
    hollow
  }
  #end
  
  translate <-4,6,0> - z*1.30 + <0.21, -0.22, 0>
}


#end // ================= QO_Bohrium
