// Persistence of Vision Ray Tracer Scene Description File
// File: SBBasic.pov
// Vers: 3.5
// Desc: SimBall example file: Stack of balls with spinning bottom ball
// Date: 2003.10.29
// Auth: Alain Ducharme
//
// Command line for animation:
// +kff180

#version 3.5;

#include "simballs.inc"
#include "quaternions.inc"

global_settings {
  assumed_gamma 1.0
}

default { texture { pigment { color rgb 1 } finish { ambient 0.1 specular 0 roughness 1 } } }

camera {
  location  <0, 1.75, -5>
  angle     53
  right     x*image_width/image_height
  look_at   <0.0, 1.1, 0.0>
}

light_source { <-1,2,-2.25> color rgb <1, 1, 1> fade_distance 3 fade_power 2 }

#declare SimTime = 6;           // Simulation time in seconds
#declare SimStep = 1/200;       // Seconds between simulation steps
#declare FrameStep = clock_delta*SimTime;

SetNumBalls(6)

#declare S1 = seed(42);
// Initialize Balls
#declare I = 0;
#declare CH = 0; // Current height
#while (I < NumBalls)
  #declare RM = 0.15+(6-I)/50;  // Radius and Mass
  #declare Bg[I] = G;           // Gravity
  #declare Br[I] = RM;          // Radius
  #declare Bm[I] = RM;          // Mass
  #declare Bp[I] = <rand(S1)*0.0001,CH+RM,0>;  // Initial Position
  #declare Bv[I] = <0,0,0>;     // Initial Velocity
  #declare Bw[I] = <0,(I?0:10),0>;  // Initial Angular Velocity in circles
  #declare Bo[I] = <0,0,0,1>;   // Initial Orientation: quaternion, must be normalized
  #declare Bc[I] = 0.8;         // Coefficient of restitution (bounciness)
  #declare Bu[I] = 0.9;         // Coefficient of friction (slipperiness)
  #declare CH = CH + 2*RM;
  #declare I = I + 1;
#end

LoadBalls()

// Declare collision objects
#declare Room = <4/2,3,4/2>;  // Room dimensions (xz/2 for convenience)
#declare Wall = 0.1;          // Wall thickness
// Draw collision object(s)
box { <-Room.x,-Wall,-Room.z>, <Room.x,0,Room.z> }                  // Floor
box { <-Room.x,Room.y,-Room.z>, <Room.x,Room.y+Wall,Room.z> }       // Ceiling
//box { <-Room.x,0,-Room.z>, <Room.x,Room.y,-Room.z-Wall> no_image }  // Front
box { <-Room.x,0,Room.z>, <Room.x,Room.y,Room.z+Wall> }             // Back
box { <-Room.x,0,-Room.z>, <-Room.x-Wall,Room.y,Room.z> }           // Left
box { <Room.x,0,-Room.z>, <Room.x+Wall,Room.y,Room.z> }             // Right

// Sim Loop
#declare Time = 0;
#while (Time < FrameStep)
  #declare I = 0;
  #while (I < NumBalls)
    VelPos()
    B2B()

    // Start Collisions with Immovable objects
    #if (Bp[I].y < (Br[I])) // Floor
      ImmoYColl(0.8,0.9,<Bp[I].x,Br[I],Bp[I].z>)
    #end

    #if (Bp[I].y > (Room.y-Br[I])) // Ceiling
      #declare Bv[I] = -Bv[I];
      ImmoYColl(0.8,0.9,<Bp[I].x,Room.y-Br[I],Bp[I].z>)
      #declare Bv[I] = -Bv[I];
    #end

    #if (Bp[I].x > Room.x-Br[I]) // Right
      ImmoColl(-x,0.8,0.9,<Room.x-Br[I],Bp[I].y,Bp[I].z>)
    #end

    #if (Bp[I].x < -Room.x+Br[I]) // Left
      ImmoColl(x,0.8,0.9,<-Room.x+Br[I],Bp[I].y,Bp[I].z>)
    #end

    #if (Bp[I].z > Room.z-Br[I]) // Front
      ImmoColl(-z,0.8,0.9,<Bp[I].x,Bp[I].y,Room.z-Br[I]>)
    #end

    #if (Bp[I].z < -Room.z+Br[I]) // Back
      ImmoColl(z,0.8,0.9,<Bp[I].x,Bp[I].y,-Room.z+Br[I]>)
    #end

    // Increment ball's orientation
//  QInc(Bo[I],Bw[I]/Br[I],SimStep)

    #declare I = I + 1;
  #end // #while (I < NumBalls)
  #declare Time = Time + SimStep;
#end // #while (Time < FrameStep)
// End of Sim Loop

// Save ball data and draw spheres
OpenSBFile()
#declare I = 0;
#while (I < NumBalls)

  // Increment ball's orientation
  // This should be in the Sim loop but in most cases it will look ok here
  // It saves on computations here; use it in Sim loop instead for more precision
  QInc(Bo[I],Bw[I]/Br[I],FrameStep)
                   
  // Draw sphere
  sphere { <0 0 0> Br[I]
    texture {
      pigment { uv_mapping checker color rgb <1, 1, 1>, color rgb <1,0,0> scale 0.15 }
      finish { specular 0.9 roughness 0.02 }
    }
//    scale Br[I]   // Could set radius to 1 above and scale here depending on how you want to handle texture
    // Set orientation
    QMatrix(Bo[I])
    translate Bp[I]
  }

  // Write ball data
  WriteBall()

  #declare I = I + 1;
#end
CloseSBFile()
