// Persistence of Vision Ray Tracer Scene Description File
// File: sbbasic.pov
// Vers: 3.5
// Desc: SimBalls basic example file, Ball with floor and wall boundaries
// Date: 2003.10.29
// Auth: Alain Ducharme
//
// Command line for animation:
// +kff60

#version 3.5;

#include "simballs.inc"
#include "quaternions.inc"

global_settings {
  assumed_gamma 1.0
}

default { texture { pigment { color rgb 1 } finish { ambient 0.1 specular 0 roughness 1 } } }

camera {
  location  <0, 1.75, -5>
  angle     53
  right     x*image_width/image_height
  look_at   <0.0, 1.1, 0.0>
}

light_source { <-1,2,-2.25> color rgb <1, 1, 1> fade_distance 3 fade_power 2 }

#declare SimTime = 2;             // Simulation time in seconds
#declare SimStep = 1/100;         // Seconds between simulation steps
#declare FrameStep = clock_delta*SimTime; // Seconds betweem frames

SetNumBalls(1)  // Set the number of SimBalls

// Initialize ball parameters
#declare I = 0;
#while (I < NumBalls)
  #declare Bg[I] = G;             // Gravity (G is declared in simballs.inc)
  #declare Br[I] = 0.5;           // Radius
  #declare Bm[I] = 1;             // Mass
  #declare Bp[I] = <-1,Br[I],0>;  // Initial Position
  #declare Bv[I] = <5,0,0>;       // Initial Velocity
  #declare Bw[I] = <0,0,-5>;      // Initial Angular Velocity in circles
  #declare Bo[I] = <0,0,0,1>;     // Initial Orientation: quaternion, must be normalized
  #declare Bc[I] = 0.9;           // Coefficient of restitution (bounciness)
  #declare Bu[I] = 0.5;           // Coefficient of friction (slipperiness)
  #declare I = I + 1;
#end

LoadBalls() // Load previous frame's simball data from file

// Declare collision objects
#declare Wall = 2;

// Draw collision object(s)
plane { y,0 finish { ambient 0 } }
plane { x, Wall finish { ambient 0 } }

// Sim Loop
#declare Time = 0;
#while (Time < FrameStep)
  #declare I = 0;
  #while (I < NumBalls)
    VelPos()  // Update ball velocity & position
    B2B()     // Detect & process ball to ball collisions

    // Collisions with Immovable objects
    #if (Bp[I].y < (Br[I])) // Floor
      ImmoYColl(0.8,0.5,<Bp[I].x,Br[I],Bp[I].z>)
    #end

    #if (Bp[I].x > Wall-Br[I]) // Wall
      ImmoColl(-x,0.8,0.5,<Wall-Br[I],Bp[I].y,Bp[I].z>)
    #end

    // Increment ball's orientation
//    QInc(Bo[I],Bw[I]/Br[I],SimStep)

    #declare I = I + 1;
  #end // #while (I < NumBalls)
  #declare Time = Time + SimStep;
#end // #while (Time < FrameStep)
// End of Sim Loop

// Save ball data and draw spheres
OpenSBFile()
#declare I = 0;
#while (I < NumBalls)

  // Increment ball's orientation
  // This should be in the Sim loop but in most cases it will look ok here
  // It saves on computations here; use it in Sim loop (with SimStep) for more precision
  QInc(Bo[I],Bw[I]/Br[I],FrameStep)
                   
  // Draw sphere
  sphere { <0 0 0> Br[I]
    texture {
      pigment { uv_mapping checker color rgb <1, 1, 1>, color rgb <1,0,0> scale 0.15 }
      finish { specular 0.9 roughness 0.02 }
    }
//    scale Br[I]   // Could set radius to 1 above and scale here depending on how you want to handle texture

    QMatrix(Bo[I])  // Set orientation
    translate Bp[I] // Set Position
  }

  // Write ball data
  WriteBall()

  #declare I = I + 1;
#end
CloseSBFile()
