camera { location <0,0,-10> look_at 0 }

light_source { <5,10,-20> color rgb 1}

// 125 spheres, with their "place in grid", "real place" and speed stored in arrays

#declare Grid=array[125] 
#declare Place=array[125]
#declare Speed=array[125]

#declare Num=0;


#declare x_dim=1;
#declare y_dim=1;
#declare z_dim=1;

#while (z_dim<6)
#while (y_dim<6)
#while (x_dim<6)

// The cube is born.

#declare Grid[Num]=<x_dim,y_dim,z_dim>;

#declare Num=Num+1;

#declare x_dim=x_dim+1;
#end
#declare x_dim=1;
#declare y_dim=y_dim+1;
#end
#declare y_dim=1;
#declare z_dim=z_dim+1;
#end



//////////////////////////

// At the first frame, the cube is placed, and values are written to a file. 


#if (clock=0)

#fopen data "data.txt" write
#declare Num=0;
#while (Num<125)

#declare Place[Num]=Grid[Num]-<3,3,3>;
#declare Speed[Num]=<0,0,0>;

#write (data, Place[Num], ", ", Speed[Num], ", " )

#declare Num=Num+1;
#end


#fclose data

#end
//////////////////////////

//////////////////////////

// It seems that I need to fill the empty arrays up first, otherwise an error occurs. 
// It doesn't really matter, since the correct values are in the file already.

#if (clock>0)
#declare Num=0;
#while (Num<125)
#declare Place[Num]=<0,0,0>;
#declare Speed[Num]=<0,0,0>;
#declare Num=Num+1;
#end


//////////////////////////

// The values are read now.

#fopen data "data.txt" read
#declare Num=0;
#while (Num<125)

#read (data, Place[Num], Speed[Num])
#declare Num=Num+1;
#end
#fclose data
#end
//////////////////////////

// For more accuracy we'll have 20 steps for each frame (a). 
// The value dt controls the overall speed of the animation (more or less).

#declare dt=1/3;
#declare a=0;
#while (a<20)


#declare acc=array[125]
#declare Num=0;
#while (Num<125)
#declare acc[Num]=<0,0,0>;
#declare Num=Num+1;
#end

//////////////////////////

// Here the forces of the springs and the accelerations are calculated. 
// If the distance between two connected spheres is higher than one, the springs pull, if smaller they push.
// I hope that this is readable, I don't want to go into details now... :)


#declare Num=0;
#while (Num<125)

#if (Num<125) 
 #if (Grid[Num].x<5)
 
 #declare dist=Place[Num]-Place[Num+1];
 #declare dist_norm=vnormalize(dist);
 #declare dist_length=vlength(dist);
 #declare force=0.07*(dist_length-1)*dist_norm;

 #declare acc[Num]=acc[Num]-force;
 #declare acc[Num+1]=acc[Num+1]+force;
 #end
#end 
 //////////////////////////
#if (Num<120) 
 #if (Grid[Num].y<5)
 
 #declare dist=Place[Num]-Place[Num+5];
 #declare dist_norm=vnormalize(dist);
 #declare dist_length=vlength(dist);
 #declare force=0.07*(dist_length-1)*dist_norm;

 #declare acc[Num]=acc[Num]-force;
 #declare acc[Num+5]=acc[Num+5]+force;
 #end
#end 
 //////////////////////////

#if (Num<100) 
 #if (Grid[Num].z<5)
 
 #declare dist=Place[Num]-Place[Num+25];
 #declare dist_norm=vnormalize(dist);
 #declare dist_length=vlength(dist);
 #declare force=0.07*(dist_length-1)*dist_norm;

 #declare acc[Num]=acc[Num]-force;
 #declare acc[Num+25]=acc[Num+25]+force;
 #end
#end

#declare Num=Num+1;
#end

//////////////////////////

// Speeds and movements calculated, and a little "friction" added.

#declare Num=0;
#while (Num<125)
#declare Speed[Num]=Speed[Num]+acc[Num]*dt;
#declare Speed[Num]=Speed[Num]*0.9975; // "friction"

#declare Place[Num]=Place[Num]+Speed[Num]*dt;


#declare place=Place[Num];
#declare speed=Speed[Num];

// If a sphere hits a wall, it bounces back.

#if (place.x>3.9)
#declare place=place-<(place.x-3.9)*2,0,0>;
#declare speed=speed*<-1,1,1>;
#end

#if (place.y>3.9)
#declare place=place-<0,(place.y-3.9)*2,0>;
#declare speed=speed*<1,-1,1>;
#end

#if (place.z>3.9)
#declare place=place-<0,0,(place.z-3.9)*2>;
#declare speed=speed*<1,1,-1>;
#end


#if (place.x<-3.9)
#declare place=place+<(-3.9-place.x)*2,0,0>;
#declare speed=speed*<-1,1,1>;
#end

#if (place.y<-3.9)
#declare place=place+<0,(-3.9-place.y)*1.1,0>;
#declare speed=speed*<1,-1,1>;
#end

#if (place.z<-3.9)
#declare place=place+<0,0,(-3.9-place.z)*2>;
#declare speed=speed*<1,1,-1>;
#end    

// Gravity.
#declare speed=speed-<0,clock/200,0>;

#declare Place[Num]=place;
#declare Speed[Num]=speed;

#declare Num=Num+1;
#end

#declare a=a+1;
#end

//////////////////////////

// The objects are placed.

#declare Num=0;
#while (Num<125)
sphere { Place[Num] ,0.05 pigment {color rgb 1} }

#if (Num<125)
#if (Grid[Num].x<5)
cylinder {Place[Num] Place[Num+1] 0.04 pigment {color rgb <1,0,0>}  }
#end
#end
#if (Num<120)
#if (Grid[Num].y<5)
cylinder {Place[Num] Place[Num+5] 0.04 pigment {color rgb <1,0,0>}  } 
#end
#end
#if (Num<100)
#if (Grid[Num].z<5)
cylinder {Place[Num] Place[Num+25] 0.04 pigment {color rgb <1,0,0>} } 
#end
#end

#declare Num=Num+1;
#end            
//////////////////////////

// Values are written to the file.

#fopen data "data.txt" write
#declare Num=0;
#while (Num<125)

#write (data, Place[Num],", ", Speed[Num], ", ")

#declare Num=Num+1;
#end

#fclose data

//////////////////////

// Walls.

plane {-z, -4 pigment {color rgb 1} no_shadow}
plane {-y, -4 pigment {color rgb 1} no_shadow} 
plane {-x, -4 pigment {color rgb 1} no_shadow} 

plane {x, -4 pigment {color rgb 1} no_shadow}
plane {y, -4 pigment {color rgb 1} no_shadow} 