#version 3.5;
#include "param.inc"

global_settings {assumed_gamma 1.0}

camera {location <0,5,-17> look_at <0,-2, 0>} 
light_source { <500,500,-500> rgb <1,0.9,0.8> }
light_source { <-100,100,-500> rgb <0.3,0.3,0.5> }

//steiner
#declare Fx=function(u,v){2*u*cos(v)*((1-u^2)^(1/2))}
#declare Fy=function(u,v){2*u*sin(v)*((1-u^2)^(1/2))}
#declare Fz=function(u,v){1-2*(u^2)*(cos(v)^2)}      

object { 
   Parametric(
      <FromU(0),ToU(1)>,
      <FromV(0),2*pi>,
      50,100,""
   )
   uv_mapping
   pigment{checker color rgb <0,0,0.2> color rgb <1,0.85,0.85> scale 0.1}
   finish{specular 0.4}
   scale 7
   rotate <135,0,0>
   rotate <0,-25,0>
}


