#version 3.5;
#include "param.inc"

global_settings {assumed_gamma 1.0}

//steiner
#declare Fx= function(U,V){2*U*cos(V)*((1-U^2)^(1/2))}
#declare Fy= function(U,V){2*U*sin(V)*((1-U^2)^(1/2))}
#declare Fz= function(U,V){1-2*(U^2)*(cos(V)^2)}      

// 0 < U < 1
#declare Umin= FromU(0);
#declare Umax= ToU(1);
// 0 < V =<2*pi
#declare Vmin= FromV(0);
#declare Vmax= 2*pi;

#declare Iter_U= 50;
#declare Iter_V= 100;
//#declare WriteReadMesh = "steiner_mesh.msh"
Parametric()

camera {location <0,5,-17> look_at <0,-2, 0>} 
light_source { <500,500,-500> rgb <1,0.9,0.8> }
light_source { <-100,100,-500> rgb <0.3,0.3,0.5> }

object{ 
   Surface
   uv_mapping
   pigment {
      marble
      turbulence <0.3,0,0>
      translate <-0.5,0,0>
      scale <0.05,1,1>
      rotate <0,0,90>
      warp {repeat 0.5*x flip x}
      warp {repeat 0.5*y flip y}
      scale <1,pi,1>
      colour_map {
         [0, rgbf 0]
         [1, rgbf <1,1,1,0.6>]
      }
   }
   finish {
      specular 0.4
      roughness 0.05
      irid {
         0.3
         thickness 0.2
         turbulence 0.1
      }      
   }
   scale 7
   rotate <135,0,0>
   rotate <0,-25,0>
}


