#version 3.5;
#include "param.inc"

global_settings {assumed_gamma 1.0}

//klein-ish
#declare Fx= function(U,V){cos(U)*(cos(U/2)*(sqrt(2)+cos(V))+(sin(U/2)*sin(V)*cos(V)))}
#declare Fy= function(U,V){sin(U)*(cos(U/2)*(sqrt(2)+cos(V))+(sin(U/2)*sin(V)*cos(V)))}
#declare Fz= function(U,V){-1*sin(U/2)*(sqrt(2)+cos(V))+cos(U/2)*sin(V)*cos(V)}
  
#declare Umin= -2*pi;
#declare Umax=  2*pi;
#declare Vmin= -2*pi;
#declare Vmax=  2*pi;

#declare Iter_U= 50;
#declare Iter_V= 50;
//#declare WriteReadMesh = "klein_mesh.msh"
Parametric()

camera {location <0,0.5,-6> look_at <0,0,0>} 
light_source { <500,500,-500> rgb <1,0.9,0.8> }
light_source { <-100,100,-500> rgb <0.3,0.3,0.5> }

object{ 
   Surface
   uv_mapping
   pigment{rgb 1}
   pigment {
      marble
      turbulence <0.15,0,0>
      translate <-0.5,-0.5,0>
      scale <.1,.1,1>
      rotate <45,0,0>
      warp {repeat 0.5*x flip x}
      warp {repeat 0.5*y flip y}
      scale <2*pi,2*pi,1>
      colour_map {
         [0, rgbf 0]
         [1, rgbf <1,1,1,0.6>]
      }
   }
   finish {
      specular 0.4
      roughness 0.05
      irid {
         0.3
         thickness 0.2
         turbulence 0.1
      }      
   }
   rotate <-90,0,0>
   rotate <0,45,0>
}


