#version 3.5;

#include "param.inc"

global_settings {assumed_gamma 1.0}

#declare Crack= function {
  pigment {
    crackle
    colour_map{
      [0, rgb <0.3,0.5,0.8>]
      [1, rgb 1]
    }
  }
}
#declare R= function(U, V) {
  Crack(U, V, 0).gray
}
//Cylinder R=radius, Vmin to Vmax=height
#declare Fx= function(U,V){R(U,V)*cos(U)} 
#declare Fy= function(U,V){R(U,V)*sin(U)} 
#declare Fz= function(U,V){V}

// 0 =< U =< 2*pi  
#declare Umin= 0;                
#declare Umax= 2*pi; 

#declare Vmin= -1;               
#declare Vmax= 1;
                         
#declare Iter_U= 100;                  
#declare Iter_V= 50;
#declare WriteReadMesh = "cyl_mesh.msh"  
Parametric()

camera {
   location  <0,1,-10>
   look_at   <0,0,0>
   angle 20
} 

light_source { <500,500,-500> rgb <1,0.9,0.8> }
light_source { <-100,100,-500> rgb <0.3,0.3,0.5> }


object{ 
   Surface
   uv_mapping
   pigment{rgb 1}
   finish{specular 0.5}
   rotate <60,0,0>
}

