#version 3.5;

#include "param.inc"

global_settings {assumed_gamma 1.0}

#declare R=function(U,V){1}
#declare Fx= function(U,V){(4+R(U,V)*cos(U)+4*pow(cos(V*0.5),2))*cos(2*V)} 
#declare Fy= function(U,V){(4+R(U,V)*cos(U)+4*pow(cos(V*0.5),2))*sin(2*V)} 
#declare Fz= function(U,V){R(U,V)*sin(U)+(4*sin(V))}

// 0 =< U < 2*pi  
#declare Umin= 0;                
#declare Umax= 2*pi; 
//0 =< V < 2*pi
#declare Vmin= 0;               
#declare Vmax= 2*pi;
                         
#declare Iter_U= 50;                  
#declare Iter_V= 200;
//#declare WriteReadMesh = "bretzel_mesh.msh"  
Parametric()                                       

camera {
   location  <0,10,-16>
   look_at   <0,0,0>
} 

light_source { <500,500,-500> rgb <1,0.9,0.8> }
light_source { <-100,100,-500> rgb <0.3,0.3,0.5> }


object{ 
   Surface
   uv_mapping
   texture {
      pigment {
         marble
         turbulence <0.3,0,0>
         translate <-0.5,0,0>
         scale <0.05,1,1>
         rotate <0,0,45>
         warp {repeat 0.5*x flip x}
         warp {repeat 0.5*y flip y}
         scale <2*pi,2*pi,1>
         colour_map {
            [0, rgbf 0]
            [1, rgbf <1,1,1,0.6>]
         }
      }
      finish {
         specular 0.4
         roughness 0.05
         irid {
            0.3
            thickness 0.2
            turbulence 0.1
         }      
      }
   }
   rotate <90,0,0>
}

