#version 3.5;
#include "param.inc"
global_settings {assumed_gamma 1.0}

//info: http://astronomy.swin.edu.au/pbourke/geometry/sphericalh/
//lots of examples:    http://www.lifesmith.com/spharmin.html

//#declare M=array[8]{1,1,4,4,1,1,1,1}
//#declare M=array[8]{1,3,4,4,1,4,4,1}
//#declare M=array[8]{1,2,3,7,7,0,3,3}
//#declare M=array[8]{5,3,5,3,5,3,5,3}
//#declare M=array[8]{3,4,3,2,6,3,0,1}
//#declare M=array[8]{4,4,4,1,7,4,4,4}
#declare M=array[8]{1,4,4,4,4,4,4,4}


#declare R=function(phi,theta){
    (pow(sin(M[0]*phi),  M[1])
    +pow(cos(M[2]*phi),  M[3])
    +pow(sin(M[4]*theta),M[5])
    +pow(cos(M[6]*theta),M[7]))
}


#declare Fx= function(phi,theta){(1+R(phi,theta)) * sin(phi) * cos(theta)}
#declare Fy= function(phi,theta){(1+R(phi,theta)) * cos(phi)}
#declare Fz= function(phi,theta){(1+R(phi,theta)) * sin(phi) * sin(theta)}

#declare Umin=FromU(0);
#declare Umax=pi;
#declare Vmin=0;
#declare Vmax=2*pi;

#declare Iter_U=60;
#declare Iter_V=120;

/*        //uncomment to write mesh-file.
#declare eMs=""
#declare I=0;
#while (I<8)
   #declare eMs=concat (eMs,str(M[I],0,0))
   #debug concat("\neMs :",eMs,"\n")
   #declare I=I+1;
#end
#declare WriteReadMesh = concat("SH_",eMs,".msh")
*/

Parametric()

camera {location <0,6,-17> look_at <0,0,0> angle 45} 
light_source { <500,500,-500> rgb <1,0.9,0.8> }
light_source { <-100,100,-500> rgb <0.3,0.3,0.5> }

object{ 
   Surface
   uv_mapping
   pigment{
      gradient y 
      scale 2*pi
      colour_map {
         [0, rgb <1,0,0>]
         [0.5, rgb <0,0,1>]
         [1, rgb <1,0,0>]
      }
   }
   finish {specular 0.4}
   rotate <0,-25,0>
}

