#version 3.5;
#include "param.inc"
global_settings {assumed_gamma 1.0}

//umbilic torus
#declare Fx= function(U,V){sin((U/3)-(2*V)) + 2*sin((U/3)+V)}
#declare Fy= function(U,V){cos(U)*((7+cos((U/3)-(2*V))+(2*cos((U/3)+V))))}
#declare Fz= function(U,V){sin(U)*((7+cos((U/3)-(2*V))+(2*cos((U/3)+V))))}
 
#declare Umin= -pi;
#declare Umax=  pi;
#declare Vmin= -pi;
#declare Vmax=  pi;

#declare Iter_U= 50;
#declare Iter_V= 50;
//#declare WriteReadMesh = "umbilic_mesh.msh"
Parametric()

camera {location <0,0.5,-20> look_at <-1,0,0>} 
light_source { <500,500,-500> rgb <1,0.9,0.8> }
light_source { <-100,100,-500> rgb <0.3,0.3,0.5> }

object{ 
   Surface
   uv_mapping
   pigment {
      marble
      turbulence <0.1,0.1,0>
      scale <.05,1,1>
      warp {repeat 0.5*x flip x}
      warp {repeat 0.5*y flip y}
      translate <-0.5,-0.5,0>
      scale <2*pi,2*pi,1>
      colour_map {
         [0, rgbf 0]
         [1, rgbf <1,1,1,0.8>]
      }
   }
   finish {
      specular 0.4
      roughness 0.05
      irid {
         0.4
         thickness 0.2
         turbulence 0.05
      }      
   }
   rotate <0,55,0>
   rotate <25,0,0>
}


