#include "param.inc"
global_settings {assumed_gamma 1.0}

light_source {<500,500,-500> rgb <0.90,0.90,1>}
light_source {<-100,100,-500> rgb <0.5,0.4,0.4>}

camera {
   right x*image_width/image_height
   location <0,0,-3.2>
   look_at <0.1,0,0>
}

#declare Fx=function(u,v){cos(u)+v*cos(u/2)*cos(u)}
#declare Fy=function(u,v){sin(u)+v*cos(u/2)*sin(u)}
#declare Fz=function(u,v){v*sin(u/2)}              

#declare Umin= 0;
#declare Umax= 2*pi;
#declare Vmin= -0.5;
#declare Vmax=  0.5;

#declare Iter_U= 100;
#declare Iter_V= 50;
//#declare WriteReadMesh = "mobius_mesh.msh"
Parametric()

#declare Mob=text {
   ttf "timrom.ttf"
   "moebius"
   1,0
   translate -0.5*z
}

#declare Min=min_extent(Mob);
#declare Max=max_extent(Mob);
#debug vstr(3,Min,", ",0,-1)
#debug vstr(3,Max,", ",0,-1)

#declare Mob_pigm=pigment {
   object{Mob colour rgbf 1 colour rgb 1}
   rotate <0,0,-90>
   warp {repeat (Max.y+0.2)*x}
   scale 1/(Max.x-Min.x)
   translate 0.5*y
   scale 0.90
}

object{ 
   Surface
   no_shadow
   uv_mapping
   pigment {Mob_pigm}
   rotate <0,55,0>
   rotate <25,0,0>
}





 