#version 3.5;
#include "param.inc"

global_settings {assumed_gamma 1.0}

#declare a=2;
#declare Fx= function(U,V){(a+cos(U/2)*sin(V)-sin(U/2)*sin(2*V))*cos(U)}
#declare Fy= function(U,V){(a+cos(U/2)*sin(V)-sin(U/2)*sin(2*V))*sin(U)}
#declare Fz= function(U,V){sin(U/2)*sin(V)+cos(U/2)*sin(2*V)}
 
#declare Umin= -pi;
#declare Umax=  pi;
#declare Vmin= -pi;
#declare Vmax=  pi;

#declare Iter_U= 100;
#declare Iter_V= 100;
//#declare WriteReadMesh = "klein8_mesh.msh"
Parametric()

camera {location <0,0.5,-7> look_at <0,-0.3,0>} 
light_source { <500,500,-500> rgb <1,0.9,0.8> }
light_source { <-100,100,-500> rgb <0.3,0.3,0.5> }

object{ 
   Surface
   uv_mapping
   pigment {
      marble
      turbulence <0.15,0,0>
      translate <-0.5,0,0>
      scale <0.1,0.25,1>
      rotate <0,0,90>
      warp {repeat 0.5*x flip x}
      warp {repeat 0.5*y flip y}
      translate<-0.5,-0.5,0>
      scale <2*pi,2*pi,1>
      colour_map {
         [0, rgbf 0.0]
         [1, rgbf <1,1,1,0.8>]
      }
   }
   finish {
      specular 0.4
      roughness 0.05
      irid {
         0.3
         thickness 0.2
         turbulence 0.1
      }      
   }
   rotate<40,0,0>
   rotate<0,33,0>
}

