#version 3.5;
#include "param.inc"

global_settings {assumed_gamma 1.0}

//dini
#declare a= 1;
#declare b= 0.2;
#declare Fx= function(U,V){a*cos(U)*sin(V)}
#declare Fy= function(U,V){a*sin(U)*sin(V)}
#declare Fz= function(U,V){a*(cos(V)+ln(tan((V/2))))+b*U}
   
#declare Umin= 0;
#declare Umax= 6*pi;
#declare Vmin= FromV(0);
#declare Vmax= 2;

#declare Iter_U= 120;
#declare Iter_V=  50;
//#declare WriteReadMesh = "dini_mesh.msh"
Parametric()

camera {location <0,0,-5> look_at <1.3,0.9, 0>} 
light_source { <500,500,-500> rgb <1,0.9,0.8> }
light_source { <-100,100,-500> rgb <0.3,0.3,0.5> }

object{ 
   Surface
   uv_mapping
   pigment {
      marble
      turbulence <0.15,0,0>
      translate <-0.5,0,0>
      scale <0.125,1,1>
      rotate <0,0,90>
      warp {repeat 0.5*x flip x}
      warp {repeat 0.5*y flip y}
      scale <1,1*pi,1>
      colour_map {
         [0, rgbf 0]
         [1, rgbf <1,1,1,0.6>]
      }
   }
   finish {
      specular 0.4
      roughness 0.05
      irid {
         0.3
         thickness 0.2
         turbulence 0.1
      }      
   }
   rotate <-90,45,0>
   rotate <-50,0,0>
   rotate <0,0,-50>
}