#version 3.5;
#include "param.inc"
global_settings {assumed_gamma 1.0}

//Klein-bottle
#macro R(U)(4*(1-cos(U)/2))#end
#macro Fx(U,V)
   #if(U<=pi)
      (6*cos(U)*(1+sin(U))+(R(U)*cos(U)*cos(V)))
   #else
      (6*cos(U)*(1+sin(U))+(R(U)*cos(V+pi)))
   #end
#end
#macro Fy(U,V)
   #if(U<=pi)
      (16*sin(U)+(R(U)*sin(U)*cos(V)))
   #else
      (16*sin(U))
   #end
#end
#macro Fz(U,V)(R(U)*sin(V))#end
 
#declare Umin= 0;
#declare Umax= 2*pi;
#declare Vmin= 0;
#declare Vmax= 2*pi;

#declare Iter_U= 75;
#declare Iter_V= 75;
//#declare WriteReadMesh = "bottle1_mesh.msh"
Parametric()

object {
   Surface
   uv_mapping
   pigment {
      marble
      turbulence <0.15,0,0>
      translate <-0.5,0,0>
      scale <0.125,1,1>
      rotate <0,0,45>
      warp {repeat 0.5*x flip x}
      warp {repeat 0.5*y flip y}
      scale <2*pi,2*pi,1>
      colour_map {
         [0, rgbf 0]
         [1, rgbf <1,1,1,0.8>]
      }
   }
   finish {
      specular 0.4
      roughness 0.05
      irid {
         0.3
         thickness 0.2
         turbulence 0.1
      }      
   }
   rotate <0,95,0>
   rotate <65,0,0>
   rotate <0,-35,0>
}

camera {location <2,-6,-25> look_at <4,-2,0>} 
light_source { <500,500,-500> rgb <1,0.9,0.8> }
light_source { <-100,100,-500> rgb <0.3,0.3,0.5> }
