#macro TiledFloor(XMax,ZMax)

#local Finish1=finish {Glossy} // {Shiny}

#local Text3=texture{T_Stone10 scale 0.1 finish {Finish1} }  // small rhomboids
#local Text2=texture{T_Stone18 scale 0.15 finish {Finish1} }// star
#local Text1=texture{T_Stone41 scale 0.1  finish {Finish1} }// square
#local Text4=texture{T_Stone8 scale 0.05  finish {Finish1} }// large rhomboids
#local Text5=texture{T_Stone21 scale 0.1  finish {Finish1} }// cylinder

//#local XMax=4;
//#local ZMax=3;

#local P1=<-0.7,0>;
#local P2=<-0.2,0.2>;
#local P3=<0,0.7>;
#local P4=<0.2,0.2>;
#local P5=<0.7,0>;
#local P6=<0.2,-0.2>;
#local P7=<0,-0.7>;
#local P8=<-0.2,-0.2>;

#local halfstar=
prism { 0,0.1,6,P1,P2,P3,P4,P5,P1 }

#local diamond=
      prism {
         0.08,0.1,4,        
        < 0.2,0.2>, <0.25, 0.45>, < 0.45, 0.25>, < 0.2, 0.2>
        scale <1.0001,1,1.0001>
        texture {Text3}
      }      
#local diag=0.7/sqrt(2);   
#declare Block=
union {
     union {
      object { halfstar }
      object { halfstar matrix <1,0,0, 0,1,0, 0,0,-1, 0,0,0> translate <0,0,0.00001> }
      texture {Text2}
     }
     cylinder { <0,0.08,0>,<0,0.1001,0> 0.28 texture {Text5} }
      box { <-0.12,0.08,0.12> <0.12,0.10015,-0.12> rotate y*45  texture {Text4}}   // centre square
      box { <-diag,.08,-diag> <diag,0.099999,diag> scale <1.0001,1,1.0001> rotate y*45 texture {Text1}}
      object { diamond }
      object { diamond  rotate y*90 }      
      object { diamond  rotate y*180}      
      object { diamond  rotate y*270}      
      bounded_by { box{<-(diag+0.1),0.079,-(diag+0.1)><diag+0.1,0.101,diag+0.1> rotate y*45}}              
}
       
object {
difference{
   union{
      #local XCount = 0;
      #local ZCount = 0;        
      #while (ZCount<(ZMax*2)+2)
        #while (XCount<XMax+2)
         #local Offset=mod(ZCount,2);
         object { Block scale <1/1.4,1,1/1.4> translate <XCount+Offset*0.5,0,ZCount*.5> }   
         #local XCount = XCount + 1;
        #end
        #local XCount =0;
        #local ZCount = ZCount + 1;
      #end
      translate <-0.5,-0.1,-0.5>
   }
   box{<0,-.15,0> < XMax,.1,ZMax> inverse }
}
       
bounded_by { box{<-.001,-.079,-0.001> <XMax+0.001,0.0001,ZMax+0.001> } }
}

#end
