/*************************************************************************
 Persistance of Vision Raytracer V3.1 World definition file.

             COBBLESTONE GENERATOR FOR POV-Ray 3.1

 Created by: Thomas de Groot (the Netherlands)
     e-mail: t.degroot@inter.nl.net
         On: 15 May 1999; updated 7 August 1999
  Copyright: May be freely used and modified.
             Acknowledgement of author is appreciated.

  The cobblestone was generated for POV-Ray V3.1 by
  Moray V3.1 For Windows (c) 1991-1998 Lutz + Kretzschmar
  
  Patterns: Checkered_Cobblestones (false) and Bricked_Cobblestones (true)
 *************************************************************************/

// Total surface covered by the cobblestones:
#ifndef (OriginX) #declare OriginX=-5;   #end
#ifndef (OriginZ) #declare OriginZ=-5;   #end
#ifndef (EndX)    #declare EndX=5;       #end
#ifndef (EndZ)    #declare EndZ=5;       #end
// Number of the cobblestones:
#ifndef (N)       #declare N=4;          #end
// Cobblestone width:
#ifndef (R)       #declare R=0.3;        #end
// CrackW width:
#ifndef (CrackW)   #declare CrackW=0.01;   #end
// Crack depth;
#ifndef (CrackD)   #declare CrackD=0.02;   #end
// Cobblestone pattern:
#ifndef (Pattern) #declare Pattern=true; #end

default { texture {pigment {color <1,0,0>} } }


// ********  MATERIALS  *******

#declare Cement = color rgb<0.52,0.49,0.27>;

#declare RoughStone = 
// This texture was originally designed by Charles Fusner.
   material {   
     texture {      
       pigment {
         granite
 /*        color_map {     // grey cobbles
           [ 0.0     rgbft <0.5, 0.5, 0.5, 0.0, 0.0> ]
           [ 0.25    rgbft <0.65, 0.65, 0.65, 0.0, 0.0> ]
           [ 0.5     rgbft <0.5, 0.5, 0.5, 0.0, 0.0> ]
           [ 0.75    rgbft <0.7, 0.7, 0.7, 0.0, 0.0> ]
           [ 1.0     rgbft <0.5, 0.5, 0.5, 0.0, 0.0> ]
         }*/
        color_map {      // slightly warmer cobbles
           [ 0.0     rgbft <0.55, 0.51, 0.4, 0.0, 0.0> ]
           [ 0.25    rgbft <0.7, 0.7, 0.5, 0.0, 0.0> ]
           [ 0.5     rgbft <0.5, 0.5, 0.4, 0.0, 0.0> ]
           [ 0.75    rgbft <0.7, 0.7, 0.6, 0.0, 0.0> ]
           [ 1.0     rgbft <0.5, 0.5, 0.3, 0.0, 0.0> ]
         }         
         
         frequency 100.0
         ramp_wave
       }      
       normal {
         crackle , 2 //0.5
         warp {
           turbulence <0.500164, 0.500364, 0.499804>
           omega 0.500404
           lambda 1.999712
         }
   //      accuracy .0001
         scale 0.25
       }      
       finish {
         ambient 0.1
         diffuse 0.549996
         specular 0.100002
         roughness 1.0
       }      
     }
     scale 0.25
   }


// ********  SEEDS  *******

#declare Sx = seed(112358);
#declare Sy = seed(235813);
#declare Sz = seed(581321);


// ********  OBJECTS  *******

#declare Cobblestone =  //  0.5 cube with all corners and edges rounded with 0.1 radius
 merge {
  sphere { <0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, 0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, 0.4000>, 0.1000 }
  sphere { <0.4000, 0.4000, -0.4000>, 0.1000 }
  sphere { <0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, -0.4000, -0.4000>, 0.1000 }
  sphere { <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, -0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, -0.4000, -0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, -0.4000, -0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, 0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, 0.4000>, <0.4000, -0.4000, 0.4000>, 0.1000 }
  cylinder { <0.4000, 0.4000, -0.4000>, <0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, -0.4000>, <-0.4000, -0.4000, -0.4000>, 0.1000 }
  cylinder { <-0.4000, 0.4000, 0.4000>, <-0.4000, -0.4000, 0.4000>, 0.1000 }
  box { <-0.4000, -0.4000, -0.5000> <0.4000, 0.4000, 0.5000> }
  box { <-0.4000, -0.5000, -0.4000> <0.4000, 0.5000, 0.4000> }
  box { <-0.5000, -0.4000, -0.4000> <0.5000, 0.4000, 0.4000> }
  bounded_by { box{<-.501,-.501,-.501><.501,.501,.501>}}
 }
 
#declare HalfCobblestone =   // half x
 object { Cobblestone
   scale <0.5,1,1>
 }

// Width of the cobblestone pattern:
#declare Street_Width=EndX-OriginX;
// Vertical offset: (N=No. of Cobbles)
#declare VertOff=25*N;


// ************  COBBLESTONE TYPES  ************
#if (Pattern=false)

#declare Checkered_Cobblestones=
union {
#declare M=CrackW*(N-1);
#declare C_Length=(Street_Width-M)/N;
#declare C_Width=C_Length*R;

#declare T_Cobblestone =   // y=0.05
 object { Cobblestone
   scale <C_Length, 0.1, C_Width>
   translate <C_Length/2, 0, C_Width/2>
 }

#declare J=OriginZ;

 #while (J<=EndZ)
  #declare I=OriginX;
  #declare N1=1;
  
   #while (N1<=N)
      object { T_Cobblestone
        material {
          RoughStone
          rotate <rand(Sx), rand(Sy), rand(Sz)>
          translate <rand(Sx), rand(Sy), rand(Sz)>
        }
        
        #if (rand(Sy)<0.5)
            translate <I,-rand(Sy)/VertOff,J>}
        #else
            translate <I,rand(Sy)/VertOff,J>}
        #end
        
      #declare I=I+C_Length+CrackW;
      #declare N1=N1+1;
   #end
   
   #declare J=J+C_Width+CrackW;
 #end

  // Cement between the cobblestones:
  box {   
   <OriginX,0.0,OriginZ>, <EndX,0.05-CrackD,EndZ>
   pigment { color Cement }
  }
} // end of union



//---------------------------------------------------------
#else

#declare Bricked_Cobblestones=
union {
#declare M=CrackW*N;
// Number of half-stones:
#declare Half=(N*2)+1;
#declare C_Length=((Street_Width-M)/Half)*2;
#declare C_Width=C_Length*R;

#declare T_Cobblestone =
  object { Cobblestone
    scale <C_Length, 0.1, C_Width>
    translate <C_Length/2, 0, C_Width/2>
  }

#declare T_HalfCobblestone =
  object { HalfCobblestone
    scale <C_Length, 0.1, C_Width>
    translate <C_Length/4, 0, C_Width/2>
  }

#declare J=OriginZ;
#declare Offset=false;

   #while (J<=EndZ)
     #declare I=OriginX;
     
     #if (Offset=true)
       object { T_HalfCobblestone
         material {
           RoughStone
           rotate <rand(Sx), rand(Sy), rand(Sz)>
           translate <rand(Sx), rand(Sy), rand(Sz)>
         }
           
         #if (rand(Sy)<0.5)
           translate <I,-rand(Sy)/VertOff,J>}
         #else
           translate <I,+rand(Sy)/VertOff,J>}
         #end
         
     #end
     #declare N1=1;
     
     #while (N1<=N)
       object { T_Cobblestone
         material {
           RoughStone
           rotate <rand(Sx), rand(Sy), rand(Sz)>
           translate <rand(Sx), rand(Sy), rand(Sz)>
         }
         
         #if (Offset=true)
           #if (rand(Sy)<0.5)
             translate <I+(C_Length/2),-rand(Sy)/VertOff,J>}
           #else
             translate <I+(C_Length/2),rand(Sy)/VertOff,J>}
           #end
           
         #else
           #if (rand(Sy)<0.5)
             translate <I,-rand(Sy)/VertOff,J>}
           #else
             translate <I,rand(Sy)/VertOff,J>}
           #end
         #end
         
         #declare I=I+C_Length+CrackW;
         #declare N1=N1+1;
      #end
      
      #if (Offset=true)
        #declare Offset=false;
      #else
        object { T_HalfCobblestone
          material {
            RoughStone
            rotate <rand(Sx), rand(Sy), rand(Sz)>
            translate <rand(Sx), rand(Sy), rand(Sz)>
          }
          
          #if (rand(Sy)<0.5)
            translate <I,-rand(Sy)/VertOff,J>}
          #else
            translate <I,+rand(Sy)/VertOff,J>}
          #end
        
        #declare Offset=true;
      #end
      
      #declare J=J+C_Width+CrackW;
    #end
    
    // Cement between the cobblestones:
    box {
      <OriginX,0.0,OriginZ>, <EndX,0.05-CrackD,EndZ>
      pigment { color Cement }
    }
} // end of union
  

#end