// Persistence of Vision Ray Tracer Scene Description File
// File: Bottles.pov
// Vers: 3.1
// Desc: Glass bottle
// Date: 3 November 1999
// Auth: D.G.Wilkinson


#version 3.1;

#include "colors.inc"
#include "textures.inc"
#include "BottleOutline.inc"



camera
{ 
  location  <1.4,0.5,-12>
  direction 1.5*z
  right     4/3*x 
  look_at   <1.4,0.5,0>   
  angle 16
  orthographic 
}

light_source
{
  <0.7, 0.5, -30>
  color rgb 1
}

 
Reset()
#declare Th1=0.015;
#declare P3x=.2;
#declare P4x=P3x;
#declare P5x=P3x;
#declare P6x=0.08;
#declare P7x=P6x;
#declare P8x=P6x;
difference{
union{
   object { Bottle()
     pigment{White}
   }
   #declare Depth=0.8;
   object { Liquid() 
     pigment{Blue}
   }
}
plane { z,-0.01 pigment {White}}
plane { z,0.01 inverse}
}

Reset()
#declare Th1=0.015;
#declare P2x=0.2;
#declare P3x=0.3;
#declare P4x=0.4;
#declare P7x=0.12;
#declare P7y=0.9;
#declare P8x=0.12;
#declare P6x=0.12;
#declare Depth=0.5;
difference{
   union{
      object { Bottle()
        translate <0.7,0,0>
        pigment{White}
        }        
      object { Liquid()
        translate x*0.7
        pigment{Red}
      }
   }
   plane { z,-0.01 pigment {White}}
   plane { z,0.01 inverse}
}

Reset()
#declare Th1=0.015;
#declare P4x=0.2;
#declare P3x=0.25;
#declare P6x=0.1;
#declare P7y=0.88;
difference{
union{
object { Bottle()
  translate <1.4,0,0>
  pigment{White}
} 
#declare Depth=0.8; 
object { Liquid()
  translate <1.4,0,0>
  pigment{Green}
}
}
plane { z,-0.01 pigment {White}}
plane { z,0.01 pigment {White} inverse}
} 


Reset()
#declare P6x=0.07;
#declare P4y=0.1;
#declare P5x=0.3;
#declare P5y=0.3;
#declare P3y=0.025;
#declare P3x=0.3;
#declare P2x=0.2;
#declare P1y=0.005;
#declare Th1=0.005;
#declare Depth=0.9;
difference{
union{
object { Bottle()
  translate <2.1,0,0>
  pigment{White}
} 
#declare Depth=0.7; 
object { Liquid()
  translate <2.1,0,0>
  pigment{Green}
}
}
plane { z,-0.01 pigment {White}}
plane { z,0.01 pigment {White} inverse}
} 

Reset() //resets the macro parameters
#declare Th1=0.01; 
#declare P3x=.2;    
#declare P4x=P3x;
#declare P5x=0.08;
#declare P5y=0.55;
#declare P6x=0.1; 
#declare P6y=0.67;
#declare P8y=0.85; 
difference{
union{
object { Bottle()
  translate <2.8,0,0>
  pigment{White}
} 
#declare Depth=0.7; 
object { Liquid()
  translate <2.8,0,0>
  pigment{Green}
}
}
plane { z,-0.01 pigment {White}}
plane { z,0.01 pigment {White} inverse}
} 
