// Persistence of Vision Ray Tracer Scene Description File
// File: Bottles.pov
// Vers: 3.1
// Desc: Glass bottles
// Date: 19 November 1999
// Auth: D.G.Wilkinson


#version 3.1;

#include "colors.inc"
#include "textures.inc"
#include "woods.inc"
#include "stones.inc"
#include "BottleNew.inc"
#include "TiledFloor.inc"

#declare Ph=true; // True if photons
  
global_settings {
  adc_bailout 0.004
  assumed_gamma 0.8
  irid_wavelength <0.25,0.18,0.14>
  ambient_light 0
  max_intersections 15
  max_trace_level 15
  number_of_waves 10 

#if (Ph)
  #declare phd=1.4; 
      
  photons {
    gather 20, 1000
    radius .3*phd/2,2,0 }
#end

} // end of global settings

camera
{ 
  location  <.7,2.3,-12>
  direction 1.5*z
  right     4/3*x 
  look_at   <.7,0.5,0>   
  angle 10 
}

plane {z,-100 hollow pigment {White}}  // plane behind camera

light_source
{
  <-30, 30, -30>
  color rgb 1 
#if (Ph)  photons{refraction on}  #end
}

light_source
{
  <50, 30, -30>
  color rgb 1
#if (Ph)  photons{refraction on} #end
}

// DECLARATIONS:
// Start- and endpoints of cobblestoned surface:
#declare OriginX=-1;
#declare OriginZ=0;
#declare EndX=2; //length
#declare EndZ=1.5;// height

// Number of cobblestones in the x-direction:
#declare N=8;

// Ratio length/width of each cobblestone:
#declare R=0.45;

// Crack between the cobblestones:
#declare CrackW=0.02; // width
#declare CrackD=0.018; // depth

// Type of pattern (false= Checkered_Cobblestones; true= Bricked_Cobblestones:
#declare Pattern=true;

#include "Cobblestones.inc" 

object {Bricked_Cobblestones
 rotate -x*90
 translate z*2
}

 
object {
 TiledFloor(4,5)
 scale <0.75,1,0.75>
 translate <-0.55,0,-1.5>
}

// box { <-2,-.1,-2> <2,0,2> pigment { image_map { tga "FloorTile.tga"} rotate x*90 scale 0.75 }}

Reset()
#declare Th1=0.01;
#declare P3x=.2;
#declare P4x=P3x;
#declare P5x=P3x;
#declare P6x=0.08;
#declare P7x=P6x;
#declare P8x=P6x;

union{
   object { Bottle()
     pigment{rgbf<0.8 0.8 0.99 .99>}
     finish {
       specular 1
       roughness 0.001
       ambient 0
       diffuse 0
       reflection 0.1 
     }        
//     finish{phong 1 phong_size 90 reflection .2 }
     interior{ior 1.5 caustics .5 } // dispersion 1.2 disp_nelems 14 }
   
#if (Ph)     
     photons {
       separation 0.02*phd*1.5
       refraction on
//       reflection on
       ignore_photons
     }
#end
    
  }
   #declare Depth=0.4;
   object { Liquid()
     pigment{rgbf<.6 .9 0.9 .94>}
     finish{phong 1 phong_size 90 reflection .2}
     interior{ior 1.5 caustics .5 }

#if (Ph)     
     photons {
       separation 0.02*phd*1.5
       refraction on
//       reflection on
       ignore_photons
     }
#end
    
   }
     translate <0,0,0.1>    
}

Reset()
#declare Th1=0.01;
#declare P2x=0.2;
#declare P3x=0.3;
#declare P4x=0.4;
#declare P7x=0.12;
#declare P7y=0.9;
#declare P8x=0.12;
#declare P6x=0.12;
#declare Depth=0.25;

union {
   object { Bottle()
     pigment{rgbf<0.99 0.8 0.8 .99>}
     finish {
       specular 1
       roughness 0.001
       ambient 0
       diffuse 0
       reflection 0.1
     }        

     interior{ior 1.5 caustics .5} 
     
#if (Ph)    
     photons {
       separation 0.02*phd*1.5
       refraction on
       ignore_photons
     }
#end
         
   }   
   object { Liquid()
     pigment{rgbf<.9 .9 0.6 .99>}
     finish{phong 1 phong_size 90 reflection .2}
     interior{ior 1.5 caustics .5 }

#if (Ph)     
     photons {
       separation 0.02*phd*1.5
       refraction on
       ignore_photons
     }
#end
  
   }
   translate <0.9,0,0.7>   
}

Reset()
#declare Th1=0.01;
#declare P4x=0.2;
#declare P3x=0.25;
#declare P6x=0.1;
#declare P7y=0.88;

union {
   object { Bottle()
     pigment{rgbf<0.9 1 0.9 .9999>}
     finish {
       specular 1
       roughness 0.001
       ambient 0
       diffuse 0
       reflection 0.1
     }   
     interior{ior 1.5 caustics .5 }
    
#if (Ph)  
     photons {
       separation 0.02*phd*1.5
       refraction on
       ignore_photons
     }
#end
     
    }
    
   #declare Depth=0.6; 
   object { Liquid()
     pigment{rgbf<0.7 0.99 0.6 .99>}
     finish {
       specular 1
       roughness 0.001
       ambient 0
       diffuse 0
       reflection 0.1
     }   
     interior{ior 1.5 caustics .5 }
    
#if (Ph)
     photons {
       separation 0.02*phd*1.5
       refraction on
       reflection on
       ignore_photons
     }
#end
    
   }
   translate <1.4,0,-0.5>
}


Reset()
#declare P6x=0.07;
#declare P4y=0.1;
#declare P5x=0.3;
#declare P5y=0.3;
#declare P3y=0.025;
#declare P3x=0.3;
#declare P2x=0.2;
#declare P1y=0.005;
#declare Th1=0.005;
#declare Depth=0.9;
 
union{
   union {
    object { Bottle()  pigment{rgbf<.9, 1 ,.9, .99999>}
     finish {
       specular 1
       roughness 0.001
       ambient 0
       diffuse 0
       reflection 0.1
     }       
     interior{ior 1.5 caustics .5 }
#if (Ph)     
     photons {
       separation 0.02*phd*1.5
       refraction on
       ignore_photons
     }
#end     
     rotate -z*30
    }
       difference {
         object { Liquid() pigment{rgbf<1, 0.7 ,1, 0.99>}
           interior{ior 1.5  caustics .5 }
#if (Ph)           
           photons {
             separation 0.02*phd*1.5
             refraction on
             ignore_photons
           }
#end           
           rotate -z*30
         }
         plane { y,0.3 pigment{rgbf<1, 0.7 ,1, 0.99> } inverse }
       }
       translate y*0.13
   }
   box{<0,0,-0.5> <0.2,0.2,0.5>  translate -x*0.33 texture {T_Wood23 rotate y*2 scale 0.2} finish {Phong_Dull}}
   translate <0.2,0,-0.3> 
}
  