#include "Bottle.inc"  // the macro file (must be in the POV-Ray path for include files)
#include "glass.inc"  // standard textures (if needed)
global_settings {
  adc_bailout 0.004
  max_intersections 64
  max_trace_level 20
}
camera
{ 
  location  <0.35,2,-6>
  direction 1.5*z
  right     4/3*x 
  look_at   <0.35,0.5,0>
  angle 15   
}
light_source
{
  <-10, 3, -5>
  color rgb 0.8
}   
light_source
{
  <10, 3, -5>
  color rgb 0.8
}
plane{z,1.1 pigment {rgb 1} finish {ambient 0.3}}
plane{y,0 pigment {rgb <0.7,0.8,0.9>} finish {ambient 0.4}}

// 1st bottle - default values
Reset() //resets the macro parameters (essential before calling the Bottle macro)
object { Bottle() interior { ior 1.5 } texture {T_Green_Glass} }  // default bottle
object { Liquid() interior { ior 2 } pigment{rgbf<1.1 1.1 0.8 .96>}}

// 2nd bottle
Reset() //resets the macro parameters
#declare Th1=0.01; // change the thickness of the glass
#declare P3x=.2;    // making P3x=P4x=P5x gives a parallel barrel
#declare P4x=P3x;
#declare P5x=P3x;
#declare P6x=0.08; // making P6x=P7x=P8x gives a parallel neck
#declare P7x=P6x;
#declare P8x=P6x;
#declare Depth=0.4; // change the liquid depth
union{ 
 object { Bottle()  pigment{rgbf<0.8 0.8 0.95 .96>}
  finish{phong 1 phong_size 90 reflection .2}
  interior{ior 1.5 } } 
 object { Liquid() pigment{rgbf<1 0.6 0.6 0.96>}
   interior{ior 1.5 }}
 translate x*0.7
} 

cylinder{0,x,0.05 translate <-0.5,0.05,0.3> scale <2,1,1> pigment{rgb<1,0,0>}}