// Persistence of Vision Ray Tracer Scene Description File
// File: Bottle1.inc
// Vers: 3.1
// Desc: include file for constructing glass bottles
// Date: 6 November 1999
// Auth: D.G.Wilkinson <http://www.hamiltonite.mcmil.com> <davidwilkinson@cwcom.net>

#macro  Reset()
 #declare P1y=0;
 #declare P2x=0;
 #declare P3x=0; 
 #declare P3y=0; 
 #declare P4x=0; 
 #declare P4y=0; 
 #declare P5x=0; 
 #declare P5y=0; 
 #declare P6x=0; 
 #declare P6y=0; 
 #declare P7x=0; 
 #declare P7y=0;
 #declare P8x=0;
 #declare P8y=0;
 #declare Th1=0;
 #declare Depth=0;      
#end

// calculates control points & offset points for a ~circular segment
#macro  Bez_Circ(Pnt1,Pnt2,Pnt3,Offset)
#local Konst=0.4; // this regulates the length of the Bezier control point vector
#local D1=vlength(Pnt1-Pnt2);
#local D2=vlength(Pnt1-Pnt3);
#declare CPL1=D1*Konst;
#declare CPL2=D2*Konst;
#local A1=abs(asin((Pnt2.y-Pnt1.y)/D1));
#local S1=(pi-2*A1)/2;
#declare PT1=<Offset*cos(2*S1),Offset*sin(2*S1)>; // this is the offset point
// the following are the control point offsets
#declare Xa=CPL1*sin(2*S1);
#declare Ya=CPL1*cos(2*S1);
#declare Xb=CPL2*sin(2*S1);
#declare Yb=CPL2*cos(2*S1);
#end

#macro  Bottle()
// define lengths & radii
#if(!P1y) #local P1=<0,0.03>; #else #local P1=<0,P1y>; #end 
#if(!P2x) #local P2=<0.1,0>; #else #local P2=<P2x,0>;#end
#if(!P3x) #local P3=<0.2,0.05>; #else #local P3=<P3x,0.05>;#end
#if(P3y) #local P3=<P3.x,P3y>;#end
#if(!P4x) #local P4=<0.35,0.3>; #else #local P4=<P4x,0.3>;#end
#if(P4y) #local P4=<P4.x,P4y>;#end
#if(!P5x) #local P5=<0.2,0.6>; #else #local P5=<P5x,0.6>;#end
#if(P5y) #local P5=<P5.x,P5y>;#end
#if(!P6x) #local P6=<0.1,0.75>; #else #local P6=<P6x,0.75>;#end
#if(P6y) #local P6=<P6.x,P6y>;#end
#if(!P7x) #local P7=<0.07,0.95>; #else #local P7=<P7x,0.95>;#end
#if(P7y) #local P7=<P7.x,P7y>;#end         
#if(!P8x) #local P8=<0.07,1>; #else #local P8=<P8x,1>;#end
#if(P8y) #local P8=<P8.x,P8y>;#end   
#if(!Th1) #local Th1=0.01; #end // Glass thickness
#if(P8.y<=P7.y) #local P7=<P7.x,P8.y-.05>;#end 
#local CP12=<P2.x/2,P1.y>;
#local CP21=<P2.x/2,0>;
#local CP23=<P2.x+abs(vlength(P2-P3))/3,0>;
#local CP78=<P7.x,P7.y+(P8.y-P7.y)/2>;
#local CP87=<P8.x+(P8.y-P7.y)/1.5,P8.y>;
#local CP89=<P8.x/2,P8.y>;
#local P9=<0,P8.y>;
#local CP98=<P8.x/2,P9.y>;

#local PO1=<0,P1.y+Th1>;
#local PO2=<P2.x,Th1>;
#local CPO12=<P2.x/2,P1.y+Th1>;
#local CPO21=<P2.x/2,Th1>;
#local CPO23=<P2.x+vlength(P2-P3)/3,Th1>;
#local CPO78=<P7.x-Th1,P7.y+(P8.y-P7.y)/2>;
#local PO8=<P8.x-Th1,P8.y+.1>;
#local CPO87=<P8.x-Th1,P7.y+(P8.y-P7.y)/2>; 
#local CPO89=<0,P8.y>;
#local PO9=<P9.x,P9.y+.1>;
#local CPO98=<P8.x/2,P9.y>;



// CP = Control Point (eg. CP34 is the control point for P3 pointing towards P4)
// CPO = Offset control point
Bez_Circ(P3,P4,P2,0)
#declare CP34=<P3.x+Xa,P3.y+Ya>;
#declare CP32=<P3.x-Xb,P3.y-Yb>;
#declare CP43=<P4.x,P4.y-CPL1>;
Bez_Circ(P5,P4,P6,0)
#if (P6.x<=P5.x) #declare CP54=<P5.x+Xa,P5.y-Ya>; #else #declare CP54=<P5.x,P5.y-(P5.y-P4.y)/2.2>; #end
#if (P6.x<=P5.x) #declare CP56=<P5.x-Xb,P5.y+Yb>; #else #declare CP56=<P5.x,P5.y+(P6.y-P5.y)/2>; #end
#declare CP45=<P4.x,P4.y+CPL1>;
Bez_Circ(P6,P7,P5,0)
#if (P6.x<=P5.x) #declare CP67=<P6.x-Xa,P6.y+Ya>; #else #declare CP67=<P6.x,P6.y+(P6.y-P5.y)/2>; #end
#if (P6.x<=P5.x) #declare CP65=<P6.x+Xb,P6.y-Yb>; #else #declare CP65=<P6.x,P6.y-(P6.y-P5.y)/2>; #end
#declare CP76=<P7.x,P7.y-CPL1>; 
Bez_Circ(P3,P4,P2,Th1)
#declare PO3=<P3.x-PT1.x,P3.y+PT1.y>;
#declare CPO34=<PO3.x+Xa,PO3.y+Ya>;
#declare CPO32=<PO3.x-Xb,PO3.y-Yb>;
#declare PO4=<P4.x-Th1,P4.y>;
#declare CPO43=<PO4.x,PO4.y-CPL1>;  
Bez_Circ(P5,P4,P6,Th1)
#if (P6.x<=P5.x) #declare PO5=<P5.x-PT1.x,P5.y-PT1.y>; #else #declare PO5=<P5.x-Th1,P5.y>; #end
#if (P6.x<=P5.x) #declare CPO54=<PO5.x+Xa,PO5.y-Ya>; #else #declare CPO54=<PO5.x,PO5.y-(P5.y-P4.y)/2>; #end
#if (P6.x<=P5.x) #declare CPO56=<PO5.x-Xb,PO5.y+Yb>; #else #declare CPO56=<PO5.x,PO5.y+(P6.y-P5.y)/2>; #end
#declare CPO45=<PO4.x,PO4.y+CPL1>;  
Bez_Circ(P6,P7,P5,Th1)
#if (P6.x<=P5.x) #declare PO6=<P6.x-PT1.x,P6.y-PT1.y>; #else #declare PO6=<P6.x-Th1,P6.y>; #end
#if (P6.x<=P5.x) #declare CPO67=<PO6.x-Xa,PO6.y+Ya>; #else #declare CPO67=<PO6.x,PO6.y+(P6.y-P5.y)/2>; #end
#if (P6.x<=P5.x) #declare CPO65=<PO6.x+Xb,PO6.y-Yb>; #else #declare CPO65=<PO6.x,PO6.y-(P6.y-P5.y)/2>; #end
#declare PO7=<P7.x-Th1,P7.y>;
#declare CPO76=<PO7.x,PO7.y-CPL1>;
union{
difference {
 lathe {
  bezier_spline
  32,
  // span 1
  P1,
  CP12,
  CP21,
  P2,
  // span 2
  P2,
  CP23,
  CP32,
  P3,
  // span 3
  P3,
  CP34,
  CP43,
  P4,    
  // span 4
  P4,
  CP45,
  CP54,
  P5,
  // span 5
  P5,
  CP56,
  CP65,
  P6,
  // span 6
  P6,
  CP67,
  CP76,
  P7,
  // span 7
  P7,
  CP78,  
  CP87,
  P8,
  // span 8
  P8,
  CP89,
  CP98,
  P9
  sturm
 }
 
 lathe {
  bezier_spline
  32, 
  // span 1
  PO1,
  CPO12,
  CPO21,
  PO2,
  // span 2
  PO2,
  CPO23,
  CPO32,
  PO3,
  // span 3
  PO3,
  CPO34,
  CPO43,
  PO4,    
  // span 4
  PO4,
  CPO45,
  CPO54,
  PO5,
  // span 5
  PO5,
  CPO56,
  CPO65,
  PO6,
  // span 6
  PO6,
  CPO67,
  CPO76,
  PO7,
  // span 7
  PO7,
  CPO78,
  CPO87,
  PO8,
  // span 8
  PO8,
  CPO89,
  CPO98,
  PO9
  sturm
  }
  bounded_by{ box{<-(P4.x+.1),-.01,-(P4.x+.1)><P4.x+.1,P8.y+.01,P4.x+.1> } }
 }

cylinder{<P1.x,P1.y,-0.01><P1.x,P1.y,0.01> 0.008 pigment {Red*2}}
cylinder{<P2.x,P2.y,-0.01><P2.x,P2.y,0.01> 0.008 pigment {Red*2}}
cylinder{<P3.x,P3.y,-0.01><P3.x,P3.y,0.01> 0.008 pigment {Red*2}}
cylinder{<P4.x,P4.y,-0.01><P4.x,P4.y,0.01> 0.008 pigment {Red*2}}
cylinder{<P5.x,P5.y,-0.01><P5.x,P5.y,0.01> 0.008 pigment {Red*2}}   
cylinder{<P6.x,P6.y,-0.01><P6.x,P6.y,0.01> 0.008 pigment {Red*2}} 
cylinder{<P7.x,P7.y,-0.01><P7.x,P7.y,0.01> 0.008 pigment {Red*2}}
cylinder{<P8.x,P8.y,-0.01><P8.x,P8.y,0.01> 0.008 pigment {Red*2}}
cylinder{<P9.x,P9.y,-0.01><P9.x,P9.y,0.01> 0.008 pigment {Red*2}}
 
cylinder{<CP12.x,CP12.y,-0.01><CP12.x,CP12.y,0.01> 0.008 pigment {Blue*2}}
cylinder{<CP21.x,CP21.y,-0.01><CP21.x,CP21.y,0.01> 0.008 pigment {Blue*2}}       
cylinder{<CP23.x,CP23.y,-0.01><CP23.x,CP23.y,0.01> 0.008 pigment {Blue*2}}
cylinder{<CP32.x,CP32.y,-0.01><CP32.x,CP32.y,0.01> 0.008 pigment {Blue*2}}      
cylinder{<CP34.x,CP34.y,-0.01><CP34.x,CP34.y,0.01> 0.008 pigment {Blue*2}}
cylinder{<CP43.x,CP43.y,-0.01><CP43.x,CP43.y,0.01> 0.008 pigment {Blue*2}} 
cylinder{<CP45.x,CP45.y,-0.01><CP45.x,CP45.y,0.01> 0.008 pigment {Blue*2}}
cylinder{<CP56.x,CP56.y,-0.01><CP56.x,CP56.y,0.01> 0.008 pigment {Blue*2}}  
cylinder{<CP54.x,CP54.y,-0.01><CP54.x,CP54.y,0.01> 0.008 pigment {Blue*2}}
cylinder{<CP65.x,CP65.y,-0.01><CP65.x,CP65.y,0.01> 0.008 pigment {Blue*2}}   
cylinder{<CP67.x,CP67.y,-0.01><CP67.x,CP67.y,0.01> 0.008 pigment {Blue*2}}
cylinder{<CP76.x,CP76.y,-0.01><CP76.x,CP76.y,0.01> 0.008 pigment {Blue*2}}  
cylinder{<CP78.x,CP78.y,-0.01><CP78.x,CP78.y,0.01> 0.008 pigment {Blue*2}}
cylinder{<CP87.x,CP87.y,-0.01><CP87.x,CP87.y,0.01> 0.008 pigment {Blue*2}}
cylinder{<CP89.x,CP89.y,-0.01><CP89.x,CP89.y,0.01> 0.008 pigment {Blue*2}} 
cylinder{<CP98.x,CP98.y,-0.01><CP98.x,CP98.y,0.01> 0.008 pigment {Blue*2}}
/* 
cylinder{<CPO12.x,CPO12.y,-0.01><CPO12.x,CPO12.y,0.01> 0.005 pigment {Blue*2}}
cylinder{<CPO21.x,CPO21.y,-0.01><CPO21.x,CPO21.y,0.01> 0.005 pigment {Blue*2}}       
cylinder{<CPO23.x,CPO23.y,-0.01><CPO23.x,CPO23.y,0.01> 0.005 pigment {Blue*2}}
cylinder{<CPO32.x,CPO32.y,-0.01><CPO32.x,CPO32.y,0.01> 0.005 pigment {Blue*2}}      
cylinder{<CPO34.x,CPO34.y,-0.01><CPO34.x,CPO34.y,0.01> 0.005 pigment {Blue*2}}
cylinder{<CPO43.x,CPO43.y,-0.01><CPO43.x,CPO43.y,0.01> 0.005 pigment {Blue*2}} 
cylinder{<CPO45.x,CPO45.y,-0.01><CPO45.x,CPO45.y,0.01> 0.005 pigment {Blue*2}}
cylinder{<CPO56.x,CPO56.y,-0.01><CPO56.x,CPO56.y,0.01> 0.005 pigment {Blue*2}}  
cylinder{<CPO54.x,CPO54.y,-0.01><CPO54.x,CPO54.y,0.01> 0.005 pigment {Blue*2}}
cylinder{<CPO65.x,CPO65.y,-0.01><CPO65.x,CPO65.y,0.01> 0.005 pigment {Blue*2}}   
cylinder{<CPO67.x,CPO67.y,-0.01><CPO67.x,CPO67.y,0.01> 0.005 pigment {Blue*2}}
cylinder{<CPO76.x,CPO76.y,-0.01><CPO76.x,CPO76.y,0.01> 0.005 pigment {Blue*2}}  
cylinder{<CPO78.x,CPO78.y,-0.01><CPO78.x,CPO78.y,0.01> 0.005 pigment {Blue*2}}
cylinder{<CPO87.x,CPO87.y,-0.01><CPO87.x,CPO87.y,0.01> 0.005 pigment {Blue*2}}
cylinder{<CPO89.x,CPO89.y,-0.01><CPO89.x,CPO89.y,0.01> 0.005 pigment {Blue*2}} 
cylinder{<CPO98.x,CPO98.y,-0.01><CPO98.x,CPO98.y,0.01> 0.005 pigment {Blue*2}}
*/
}
#end
 
#macro  Liquid()
#if(!P1y) #local P1=<0,0.03>; #else #local P1=<0,P1y>; #end
#if(!P2x) #local P2=<0.1,0>; #else #local P2=<P2x,0>;#end
#if(!P3x) #local P3=<0.2,0.05>; #else #local P3=<P3x,0.05>;#end
#if(P3y) #local P3=<P3.x,P3y>;#end
#if(!P4x) #local P4=<0.35,0.3>; #else #local P4=<P4x,0.3>;#end
#if(P4y) #local P4=<P4.x,P4y>;#end
#if(!P5x) #local P5=<0.2,0.6>; #else #local P5=<P5x,0.6>;#end
#if(P5y) #local P5=<P5.x,P5y>;#end
#if(!P6x) #local P6=<0.1,0.75>; #else #local P6=<P6x,0.75>;#end
#if(P6y) #local P6=<P6.x,P6y>;#end
#if(!P7x) #local P7=<0.07,0.95>; #else #local P7=<P7x,0.95>;#end
#if(P7y) #local P7=<P7.x,P7y>;#end         
#if(!P8x) #local P8=<0.07,1>; #else #local P8=<P8x,1>;#end
#if(P8y) #local P8=<P8.x,P8y>;#end  
#if(!Th1) #local Th1=0.02; #end // Glass thickness
#if(!Depth) #local Depth=0.55; #end // height of liquid from base
#if(P8.y<=P7.y) #local P7=<P7.x,P8.y-.05>;#end
#local P9=<0,P8.y>;
// define liquid slightly smaller than inside of bottle
#declare Th2=Th1+0.005;
#local PO1=<0,P1.y+Th2>;
#local PO2=<P2.x,Th2>;
#local CPO12=<P2.x/2,P1.y+Th2>;
#local CPO21=<P2.x/2,Th2>;
#local CPO23=<P2.x+vlength(P2-P3)/3,Th2>;
#local CPO78=<P7.x-Th2,P7.y+(P8.y-P7.y)/2>;
#local PO8=<P8.x-Th2,P8.y+.1>;
#local CPO87=<P8.x-Th2,P7.y+(P8.y-P7.y)/2>;
#local CPO89=<P8.x+P8.y-P7.y,P8.y>;
#local PO9=<P9.x,P9.y+.1>;
#local CPO98=<P8.x/2,P9.y>;
Bez_Circ(P3,P4,P2,Th2)
#declare PO3=<P3.x-PT1.x,P3.y+PT1.y>;
#declare CPO34=<PO3.x+Xa,PO3.y+Ya>;
#declare CPO32=<PO3.x-Xb,PO3.y-Yb>;
#declare PO4=<P4.x-Th2,P4.y>;
#declare CPO43=<PO4.x,PO4.y-CPL1>;  
Bez_Circ(P5,P4,P6,Th2)
#if (P6.x<=P5.x) #declare PO5=<P5.x-PT1.x,P5.y-PT1.y>; #else #declare PO5=<P5.x-Th2,P5.y>; #end
#if (P6.x<=P5.x) #declare CPO54=<PO5.x+Xa,PO5.y-Ya>; #else #declare CPO54=<PO5.x,PO5.y-(P5.y-P4.y)/2>; #end
#if (P6.x<=P5.x) #declare CPO56=<PO5.x-Xb,PO5.y+Yb>; #else #declare CPO56=<PO5.x,PO5.y+(P6.y-P5.y)/2>; #end
#declare CPO45=<PO4.x,PO4.y+CPL1>;  
Bez_Circ(P6,P7,P5,Th2)
#if (P6.x<=P5.x) #declare PO6=<P6.x-PT1.x,P6.y-PT1.y>; #else #declare PO6=<P6.x-Th2,P6.y>; #end
#if (P6.x<=P5.x) #declare CPO67=<PO6.x-Xa,PO6.y+Ya>; #else #declare CPO67=<PO6.x,PO6.y+(P6.y-P5.y)/2>; #end
#if (P6.x<=P5.x) #declare CPO65=<PO6.x+Xb,PO6.y-Yb>; #else #declare CPO65=<PO6.x,PO6.y-(P6.y-P5.y)/2>; #end
#declare PO7=<P7.x-Th2,P7.y>;
#declare CPO76=<PO7.x,PO7.y-CPL1>;

difference {
lathe {
  bezier_spline
  32, 
  // span 1
  PO1,
  CPO12,
  CPO21,
  PO2,
  // span 2
  PO2,
  CPO23,
  CPO32,
  PO3,
  // span 3
  PO3,
  CPO34,
  CPO43,
  PO4,    
  // span 4
  PO4,
  CPO45,
  CPO54,
  PO5,
  // span 5
  PO5,
  CPO56,
  CPO65,
  PO6,
  // span 6
  PO6,
  CPO67,
  CPO76,
  PO7,
  // span 7
  PO7,
  CPO78,
  CPO87,
  PO8,
  // span 8
  PO8,
  CPO89,
  CPO98,
  PO9
  sturm
  } 
plane { y, Depth inverse}
  bounded_by{ box{<-(P4.x+.1),-.01,-(P4.x+.1)><P4.x+.1,Depth+.01+.01,P4.x+.1> } }
}
#end