#declare schmuckpunkt = array[10000]
#declare sp_index = 0;
#declare sp_abstand = 3;
   
#declare holztex = texture
{
	pigment{color rgb <0.3,0.2,0>}
}

#declare nadeltex = texture
{
	pigment{color rgb <0.2,0.4,0>}
	finish
	{
		specular 0.7
	}
}

#if(testbaum)
	cone{<0,0,0>,height/3/10,<0,height/10,0>,0 pigment{color rgbt <0,1,0,0.7>}}
	
#else

#declare ast = cone
{
	<0,0,0>,0.1,<0,1,0>,0.1
	texture{holztex}
}

#declare nadel = object
{       
	#if(hiresneedles)
	blob
	{
		cylinder{<0,0,0>,<1,0,0>,0.05,1 translate  z*0.025}
		cylinder{<0,0,0>,<1,0,0>,0.05,1 translate -z*0.025}
		cylinder{<0,0,0>,<1.03,0,0>,0.05,1 translate  y*0.001}
		threshold 0.4
	}
	#else
		cylinder{<0,0,0>,<1,0,0>,0.04}
	#end	

	scale <1,0.5,1>
		
	texture{nadeltex}
}

#declare S2 = seed(2);
#macro diff(R)
	(1-(rand(S2)-0.5)*R)
#end


#macro aeste(n,l)
union
{	
	object{ast scale <1,l,1>}
	
	#if(needles)
	#local i=0.7; #while(i<l)
		object
		{
			nadel
			rotate z*nadelangle
			rotate y*360*rand(S)
			translate y*i
		}
	#local i=i+nadelabstand;#end
        
	#local i=nadelangle; #while(i<70)
		object
		{
			nadel
			rotate z*i
			rotate y*360*rand(S)
			translate y*l
		}
	#local i=i+nadeldegreeabstand;#end
	#end

        // bounded_by
        
	#if(n>0 & l>astabstand)
		#local i=astabstand; #while(i<l)
			object
			{
				aeste(n-1,(l-i)*l_ratio*diff(0.5))
				rotate z*70*diff(0.5)
				rotate x*(rand(S)-1)*20 // -0.5
				translate y*i
			}

			object
			{
				aeste(n-1,(l-i)*l_ratio*diff(0.5))
				rotate -z*70*diff(0.5)
				rotate x*(rand(S)-0.5)*20
				translate y*i
			}

		#local i=i+astabstand;#end
	#end
}
#end

union
{
	cone
	{
		<0,0,0>,height/40,<0,height,0>,0.1
		texture{holztex}
	}
        
        #if(needles)
	#local i=0.7; #while(i<height)
		object
		{
			nadel
			rotate z*nadelangle
			translate x*(height-i)/40
			rotate y*360*rand(S3)
			translate y*i
		}
	#local i=i+nadelabstand;#end
        
	#local i=nadelangle; #while(i<70)
		object
		{
			nadel
			rotate z*i
			rotate y*360*rand(S3)
			translate y*height
		}
	#local i=i+nadeldegreeabstand;#end
        #end
	
	#declare stamm_astabstand = stamm_astabstand_start;
	#declare j=stamm_astabstand; #while(j<height)
	
		object
		{       
			#local l = (height-j)*0.5*diff(0.2);
			#local xr = 70*diff(0.3); 
			#local yr = rand(S3)*360; 

			aeste(4,l)
			rotate x*xr
			rotate y*yr
			translate y*j
                        
                        #local k=sp_abstand; #while(k<l-sp_abstand/4)
				#declare schmuckpunkt[sp_index] = vrotate(vrotate(<0,k,0>,x*xr),y*yr) + y*j;
				#declare sp_index = sp_index+1;
			#local k=k+sp_abstand; #end 

		}


		#declare stamm_astabstand = stamm_astabstand_start - j*(stamm_astabstand_start-stamm_astabstand_end)/height;	
	#declare j=j+stamm_astabstand; #end
	
	scale 0.1
	rotate y*10
}
#end