#version unofficial MegaPov 0.6;

/*
--------------------------------------------------------------------------------------------------------
Quality Settings
*/
#declare hiresneedles = 0;
#declare needles = 1;
#declare testbaum = 0;
#declare sterne = 1;
#declare noiso = 0;
#declare kerzenlicht = 1;
#declare areaspotlight = 1;
/*
--------------------------------
*/


global_settings
{
	assumed_gamma 1.0
	radiosity{}
	ambient_light 0
}

camera
{
	location  <0, 4,-8>
	look_at   <0, 3, 0>
}


light_source
{
	<-40,30,-30>
	color rgb 1 * 0.3
	spotlight
	falloff 20
	point_at <0,0,0>
	#if(areaspotlight)
		area_light y,x-z,5,5
	#end
}

#if(noiso)
plane
{
	y, 0
	
	pigment
	{
		color rgb 2
	}
	
	finish
	{
		ambient 0
	}
}
#else
isosurface
{       
	function
	{
		sqrt(x*x+(y+999)^2+z*z) + 2*noise3d(0.1*x,0.1*y,0.1*z) + noise3d(0.3*x,0.3*y,0.3*z) + 0.2*noise3d(x,y,z)
	}
	contained_by
	{
		box
		{
			<-100,-50,-100>, <100, 1, 100>
		}
	}

	threshold 1000

	texture
	{
		pigment
		{
			color rgb 2
		}
		
		finish
		{
			specular 0.7
			roughness 0.01
			brilliance 0.5
			ambient 0
		}
	}
	
	normal{bozo 0.05 scale 0.2}

	translate -x*2
	
	rotate -y*20
}

plane
{
	y, -2
	
	pigment
	{
		color rgb 0
	}
	
	finish
	{
		ambient 0
	}
}
#end


// Baumspitze
glow
{
	type 1 // | 1 | 2 | 3
  	location <0,5.5,0>
	size 0.001
	radius 10
	fade_power 1
	color rgb <1,1,0.5>
}

// "Sterne"
#if(sterne)
#declare Sg = seed(187);
#local star_num = 1000;
#local i=0; #while(i<star_num)
glow
{
	type 1 // | 1 | 2 | 3
  	location <0,0,1000>
	size 0.4 * (rand(Sg)^2)
	radius 15
	fade_power 3
	color rgb <1,1,1.7>
	
	rotate -x*90*(1-cos(rand(Sg)*90))
	rotate y*(rand(Sg)-0.5)*90
}
#local i=i+1;#end

// Filter sphere zum Sterne verblassen am Horizont
sphere
{
	<0,0,0>,1
	hollow
	
	texture
	{
		pigment
		{
			gradient y
			pigment_map
			{
				[0.0 color rgbt <0,0,0,0>]
				[0.2 color rgbt <0,0,0,1>]
				[1.0 color rgbt <0,0,0,1>]
			}
		}
		
		finish
		{
			ambient 0
		}
	}
	
	scale 900
	
}
#end

// Kugel

#declare weihnachtskugel =
isosurface
{       
	function
	{
		(sqrt(x*x+y*y+z*z)-1)*(if(y,sqrt(x*x+z*z)-0.1,1)) - 0.005
	}
	contained_by
	{
		box
		{
			<-1.1,-1.1,-1.1>, <1.1, 1.3, 1.1>
		}
	}

	threshold 0
	hollow
}

/*
Kerze
*/
#macro candle(X,Y,Z,S)

#if(kerzenlicht)
#local imax=5;
#local i=0;#while(i<imax)
glow
{
	type 1 // | 1 | 2 | 3
  	location <0,3-i/imax,0> + 0.1*noise3d(5*<0,1-i/imax,0>)
	size pow((i/imax),1/2) * .003 / imax *S 
	radius 10 * S
	fade_power 2
	color rgb <1,1,0.5>

	scale S
	translate <X,Y,Z>
}
#local i=i+1;#end

light_source
{
	<0,-0.2,0>
	color rgb <1,1,0.5>*0.3
	fade_distance 1
	fade_power 3
	translate y*2
	scale S
	translate <X,Y,Z>
}
#end

cone
{
	<0,-0.2,0>,0.2,<0,-2,0>,0.2
	// no_shadow

	texture
	{
		pigment{color rgb <1,0,0>}
		finish
		{
			specular 1
			roughness 0.1
		}
	}
	
	normal{bumps 0.2 scale 0.1}
	translate y*2
	scale S
	translate <X,Y,Z>
}

cone
{
	<0,-0.2,0>,0.01,<0,0,0>,0.01
	no_shadow
	pigment{color rgb <0,0,0>}
	translate y*2
	scale S
	translate <X,Y,Z>
} 
#end 


/*
Zeug frn Tanne
*/

// Fr die ste
#declare astabstand = 5;       // 4
#declare nadelabstand = 0.03;
#declare nadelangle = 20;
#declare nadeldegreeabstand = 5;
#declare l_ratio = 0.7;
#declare S = seed(1);

// Fr den Stamm
#declare S3 = seed(4187);
#declare height = 55;
#declare stamm_astabstand_start = 2;
#declare stamm_astabstand_end = 1.5;

#include "tanne3.inc" 

/*
Das wars mit Tanne
*/

// Versuch die Kugeln "aufzuhngen"

#declare Sk = seed(31295);
#declare Skr = seed(143);

#local i=0; #while(i<sp_index)

	#if(rand(Skr) <0.6)
	object
	{
		weihnachtskugel
                
                #local R = rand(Sk); 
		texture
		{
			pigment
			{       
				#if (R<0.3)
					color rgb <1,0,0>
				#else #if (R<0.5)
					color rgb <0,1,0>
				#else
					color rgb <0,0,1>
				#end #end
			}
		
			finish
			{
				specular 1
				roughness 0.0002
				brilliance 3
				ambient 0
				reflection 1
				metallic
				reflect_metallic
			}
		}
		
		#if (R<0.3)
			scale 0.1
		#else
			scale 0.075
		#end
		
		translate schmuckpunkt[i]*0.1 - y*0.15
	}
	
	#else
		candle(schmuckpunkt[i].x*0.1,schmuckpunkt[i].y*0.1,schmuckpunkt[i].z*0.1,0.075)
	#end	
	#local i=i+1;
#end
