//  Persistence of Vision Raytracer V3.1
//  World definition file.
//
//  Contains 0 lights, 5 materials and 39 primitives.
//
//  This file was generated for POV-Ray V3.1 by
//  Moray V3.2 For Windows Copyright (c) 1993-2000 Lutz + Kretzschmar
//

//  Date : 09/28/2000    (28.09.2000)
//

/*
  The text between these two comments is in MorayPOV.INC and is
  automatically included in all POV files that Moray exports.
*/

#version 3.1;

default {
  texture {
    pigment { rgb <1,0,0> }
  }
}

/* // Scene Comment

This scene was created with Moray For Windows.

*/ // End Scene Comment

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.9
  hf_gray_16 off
  irid_wavelength <0.247059,0.176471,0.137255>
  max_intersections 64
  max_trace_level 20
  number_of_waves 10
  radiosity {
    brightness       3.0
    count            750
    distance_maximum 20.0
    error_bound      0.8
    gray_threshold   0.4
    low_error_factor 0.7
    minimum_reuse    0.015
    nearest_count    8
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <    -11.127,     -12.856,       8.784>
  sky       <    0.00000,     0.00000,     1.00000> // Use right handed-system 
  up        <        0.0,         0.0,         1.0> // Where Z is up
  right     <    1.35836,         0.0,         0.0> // Right Vector is adjusted to compensate for spherical (Moray) vs. planar (POV-Ray) aspect ratio
  angle         40.00000    // Vertical      30.000
  look_at   <     -0.364,      -0.333,       2.388>
}


//
// ********  MATERIALS  *******
//

#include "tv_watcher.inc"


//
// ********  REFERENCED OBJECTS  *******
//

#declare GlowObj4 = merge {
#version unofficial megapov 0.5;
	glow
	{
		type 0
		location <0.000,0.000,12.500>
		color rgb <0.200,0.200,0.200>
	}
//This is necessary as otherwise there may not be any objects in the Scene
box{0,0}
}
#declare CSG001 = union {
  object { GlowObj4 }
  object { // GlowObj5->GlowObj4
    GlowObj4
    translate  -2.0*y
  }
  object { // GlowObj6->GlowObj4
    GlowObj4
    translate  -4.0*y
  }
  object { // GlowObj7->GlowObj4
    GlowObj4
    translate  -6.0*y
  }
  object { // GlowObj8->GlowObj4
    GlowObj4
    translate  -8.0*y
  }
  object { // GlowObj9->GlowObj4
    GlowObj4
    translate  -10.0*y
  }
}




//
// ********  OBJECTS  *******
//

union { // Area_Light
  object { CSG001 }
  object { // CSG002->CSG001
    CSG001
    translate  5.0*x
  }
  object { // CSG003->CSG001
    CSG001
    translate  -5.0*x
  }
}


union { // Eyeball1
  sphere { // Sphere003
    <0,0,0>,1
    material {
      Eye_White
    }
  }
  sphere { // Sphere004
    <0,0,0>,1
    material {
      Eye_Pupil
    }
    scale 0.5
    translate  -0.7*y
  }
  scale 0.15
  translate  <0.3, 0.65, 3.7>
}


union { // Eyeball
  sphere { // Sphere001
    <0,0,0>,1
    material {
      Eye_White
    }
  }
  sphere { // Sphere002
    <0,0,0>,1
    material {
      Eye_Pupil
    }
    scale 0.5
    translate  -0.7*y
  }
  scale 0.15
  translate  <-0.3, 0.65, 3.7>
}


#declare GlowObj3 = merge {
#version unofficial megapov 0.5;
	glow
	{
		type 0
		location <5.000,1.000,5.100>
		color rgb <0.040,0.040,0.040>
	}
//This is necessary as otherwise there may not be any objects in the Scene
box{0,0}
}
union { // Standard_Lamp
  cone { // Cone008
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.2>
    translate  <-5.0, 1.0, 1.2>
  }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 4.0>
    translate  <-5.0, 1.0, 1.0>
  }
  cylinder { // Cylndr006
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.2>
    translate  <-5.0, 1.0, 1.0>
  }
  object { GlowObj3 }
  material {
    White_Room_Tex
  }
  translate  10.0*x
}


#declare GlowObj2 = merge {
#version unofficial megapov 0.5;
light_source
{<0.000,-12.000,2.000>
	glow
	{
		type 0
		color rgb <0.150,0.150,0.600>
	}
fade_distance   0
fade_power   0
}
}
union { // Low_Lamp
  cone { // Cone006
    <0,0,0>, 0.5, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.3>
    translate  1.0*z
  }
  cone { // Cone007
    <0,0,0>, 0.2, <0,0,1>, 0.0
    translate  1.0*z
  }
  object { GlowObj2 }
  material {
    White_Room_Tex
  }
  translate  -12.0*y
}


#declare Top = union {
  torus { // Torus001
    1.0, 0.05  rotate -x*90
    material {
      White_Room_Tex
    }
    scale <3.0, 1.7, 1.0>
    translate  <0.0, -3.0, 2.05>
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1 
    material {
      White_Room_Tex
    }
    scale <3.0, 1.7, 0.1>
    translate  <0.0, -3.0, 2.0>
  }
}
union { // Table
  cone { // Cone002
    <0,0,0>, 0.07, <0,0,1>, 0.08
    material {
      White_Room_Tex
    }
    translate  <2.07, -4.07, 1.0>
  }
  cone { // Cone003
    <0,0,0>, 0.07, <0,0,1>, 0.08
    material {
      White_Room_Tex
    }
    translate  <-2.07, -4.07, 1.0>
  }
  cone { // Cone004
    <0,0,0>, 0.07, <0,0,1>, 0.08
    material {
      White_Room_Tex
    }
    translate  <2.07, -1.93, 1.0>
  }
  cone { // Cone005
    <0,0,0>, 0.07, <0,0,1>, 0.08
    material {
      White_Room_Tex
    }
    translate  <-2.07, -1.93, 1.0>
  }
  cylinder { // Cylndr007
    <0,0,1>, <0,0,0>, 1 
    material {
      White_Room_Tex
    }
    scale <0.05, 0.05, 2.14>
    rotate -90.0*x
    translate  <-2.07, -4.07, 1.5>
  }
  cylinder { // Cylndr008
    <0,0,1>, <0,0,0>, 1 
    material {
      White_Room_Tex
    }
    scale <0.05, 0.05, 2.14>
    rotate -90.0*x
    translate  <2.07, -4.07, 1.5>
  }
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1 
    material {
      White_Room_Tex
    }
    scale <0.05, 0.05, 4.14>
    rotate -90.0*y
    translate  <2.07, -4.07, 1.25>
  }
  cylinder { // Cylndr009
    <0,0,1>, <0,0,0>, 1 
    material {
      White_Room_Tex
    }
    scale <0.05, 0.05, 4.14>
    rotate -90.0*y
    translate  <2.07, -1.93, 1.25>
  }
  object { Top }
  translate  -1.0*y
}


#declare GlowObj1 = merge {
#version unofficial megapov 0.5;
	glow
	{
		type 0
		location <-5.000,1.000,5.100>
		color rgb <0.040,0.040,0.040>
	}
//This is necessary as otherwise there may not be any objects in the Scene
box{0,0}
}
union { // Standard_Lamp2
  cone { // Cone001
    <0,0,0>, 1.0, <0,0,1>, 0.0
    scale <1.0, 1.0, 0.2>
    translate  <-5.0, 1.0, 1.2>
  }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1 
    scale <0.08, 0.08, 4.0>
    translate  <-5.0, 1.0, 1.0>
  }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1 
    scale <1.0, 1.0, 0.2>
    translate  <-5.0, 1.0, 1.0>
  }
  object { GlowObj1 }
  material {
    White_Room_Tex
  }
}


union { // Sofa
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.0, 1.0>
    translate  <3.0, 0.0, 2.0>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 1.0, 1.0>
    translate  <-3.0, 0.0, 2.0>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 1.0, 0.25>
    translate  <0.0, -0.1, 2.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <2.75, 0.25, 1.0>
    rotate -10.0*x
    translate  <0.0, 0.8, 2.9>
  }
  material {
    White_Room_Tex
  }
}


difference { // Room
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <20.0, 15.0, 10.0>
    translate  10.0*z
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <19.0, 14.0, 6.0>
    translate  <0.0, -11.0, 7.0>
  }
  material {
    White_Room_Tex
  }
}


