// Persistence of Vision Ray Tracer Scene Description File
// File: spikybox.pov
// Vers: 3.1
// Desc: standard scene for some "spiky" boxes
// Date: 99/10/23
// Auth: ReVerSi (reinhard.rettelbach.KH@t-online.de)



// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions



#declare camera_location = <0, 3, -4>;
#declare camera_look_at = <0, 0, 0>;

camera
{
  location  camera_location
  look_at   camera_look_at
}





// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red .80  green .80  blue .80  // light's color
  translate <-20, 10, -20>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-300, 300, -200>
}

background{rgb<0.98, 0.75, 0.7>}


//*******************************************************************************************
//find below a small collection of "spiky" functions as starting points for further experiments.
//remove commentation slashes for any one of the predeclared functions and comment out the other
//ones.
//*********************************************************************************************
#declare Foo = function{
//        (abs(x+0.8*y*z))^.6+(abs(z-0.8*y*x))^.6-abs(sin(12*y)) 
//        (abs(x+1.3*exp(-2*y)*z))^.45+(abs(z-1.3*exp(-2*y)*x))^.45-abs(sin(36*y))
//        (abs(x+0.8*y*z))^.6+(abs(z-0.8*y*x))^.6-abs(y*sin(12*y)+0.2)
          (abs(x+0.8*y*z))^(0.3+abs(.6*y))+(abs(z-0.8*y*x))^(0.3+abs(.6*y))-abs(sin(9*y))
//        ((abs(x))^.6+(abs(z))^.6-abs(cos(2*y))^6)*((abs(x+2*y*z))^.6+(abs(z-2*y*x))^.6-abs(cos(4*y))^6)
        }   
//***********************************************************************************************


                                                                    
isosurface {function {Foo}
        threshold 0.001 max_gradient 50000                                 
        scale 1.65
        bounded_by {box {-6, 6}} 
        pigment {gradient y color_map{
                [0 rgb <0.95, .5, 0.4>]
                [1 rgb <0.9, 0.95, 0.3>]}
                sine_wave
                scale<1, 3.5, 1> translate <0, 1.75, 0>}
        finish{specular 0.2 reflection 0.15 ambient 0.3}
        rotate <15, 60, 0>
        }   

    