
// Persistence of Vision Ray Tracer Scene Description File
// File: noisbox.pov
// Vers: 3.1
// Desc: standard scene for some "noisy" boxes
// Date: 99/10/18
// Auth: ReVerSi (reinhard.rettelbach.KH@t-online.de)



// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions    


#declare camera_location = <0, 3.5, -5>;
#declare camera_look_at = <0, 0, 0>;

camera
{
  location  camera_location
  look_at   camera_look_at
}





// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 10, -20>
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 40, -20>
}


sphere{0, 50 inverse
        pigment{rgb <0.85, 0.75, 0.95>}
        finish {reflection 0.65 diffuse 0.15}
        }

//*******************************************************************************************
//find below a small collection of "noisy" functions as starting points for further experiments.
//remove commentation slashes for any one of the predeclared functions and comment out the other
//ones.
//*********************************************************************************************
#declare Foo = 
//    function {noise3d(8*x, 12*y, .01)/3*noise3d(12*x, 8*y, .01)/3*noise3d(8*y, 12*z, .01)/3}
      function {(noise3d(8*x, 12*y, .01)*noise3d(12*x, .01, 8*z)*noise3d(.01, 8*y, 12*z))/3}    
//    function {noise3d((3*(y+z))^2, (3*(x+z))^2, (3*(x+y))^2)}
//    function {noise3d(sin(35*y*z), cos(35*x*z), (abs(sin(45*x*y)))^2)}                       
//*********************************************************************************************

isosurface {function {Foo}
        threshold 0.0001                                  
        scale 1.6
        bounded_by {box {-4, 4}} 
        pigment {rgb <0.75, .35, 0.95>}
        finish{specular 0.2 reflection 0.15}
        rotate <45, 45, 45>
        }