// =======================================================================
// Persistence Of Vision raytracer version 3.1 isosurface patch by R.Suzuki.
// =======================================================================
// Iso_plane_2.pov contains various isosurfacic functions that create a plane surface
// Examples by Gilles Tran, May 1999
// =======================================================================
camera {
   location <0, 80, -500>
   direction <0, 0,  1>
   look_at <0,0,0>
}

light_source {<150, 400, -820> color 1}
light_source {<-350, 200, -820> color 1}
#declare ComYw =   texture{
        pigment {color red 1.0 green 0.8 blue 0.5}
        finish {phong 0.6}
     }
#declare IsoWall1=isosurface  {
     function  {y+sin(exp(cos(x))*exp(cos(z+x/2)))*cos(exp(cos(x))*exp(cos(z)))}
     bounded_by{ box {<-2000,-20,-2000>,<2000,10,2000> }}
     sign 1
     threshold    0.050 // 10
     rotate x*-90
     scale <10,10,2>
      texture{ComYw}
  }
#declare IsoWall2=isosurface  {
     function  {y+sin(exp(cos(x+y))*exp(cos(z+x/2)))*cos(exp(cos(x+y/2))*exp(cos(20*max(cos(z),cos(x)))))}
     bounded_by{ box {<-2000,-20,-2000>,<2000,10,2000> }}
     sign 1
     threshold    0.050 // 10
     rotate x*-90
     scale <10,10,2>
      texture{ComYw}
  }
#declare IsoWall3=isosurface  {
     function  {y+sin(exp(cos(x+y))*exp(cos(z+x/2)))*cos(exp(cos(x+y/2))*exp(cos(20*max(cos(z),cos(x))) +sin(10*min(cos(z),cos(x)))  ))}
     bounded_by{ box {<-2000,-20,-2000>,<2000,10,2000> }}
     sign 1
     threshold    0.050 // 10
     rotate x*-90
     scale <10,10,2>
      texture{ComYw}
  }
#declare IsoWall4=isosurface  {
function  {y+cos(exp(cos(8*z+y))*exp(sin(z/3+y*4/2)))*sin(exp(cos(4*x+y/2))*exp(cos(20*min(sin(z),cos(x))) +sin(10*max(sin(z),cos(x)))  ))}
     bounded_by{ box {<-2000,-20,-2000>,<2000,10,2000> }}
     sign 1
     threshold    0.050 // 10
     rotate x*-90
     scale <10,10,2>
      texture{ComYw}
  }

#declare scPan=0.3
#declare xPan=20
#declare eMur=3

#declare IsoWall5=isosurface{
function   z + noise3d(2*x,y*2,2*z)*0.3 + noise3d(x,y,z)*0.03
bounded_by{ box {<-20,-20,-1>,<20,20,1>}}
scale <1,1,-1>
texture{ComYw}
scale 10
}


object{IsoWall1 translate z*-280}
//object{IsoWall2 translate z*-380}
//object{IsoWall3 translate z*-380}
//object{IsoWall4 translate z*-440}
//object{IsoWall5 translate z*-370}
background {color red 0.184314 green 0.309804 blue 0.309804}

