// A cigarette with some function media smoke.
// Made and copyright by Anders Haglund 1999.

camera {
   location <7,4,-9>
   look_at <0,3,0>
}

light_source { <20,30,-25> color rgb 1 }

#declare burned = 0.2; // How long it's burned (0-1). Haven't realy tried this so it may not work...
#declare noisegain = 0.5; // Noise gain in y axis
#declare noisestart = 0.5; // Starting noise
// The smoke function. Could probably be done better but it works....
#declare smoke = function { sqrt(sqr(x+noisegain*(y+noisestart)*(noise3d(x,y,z)-0.5))+sqr(z+noisegain*(y+noisestart)*(noise3d(z,y,z)-0.5))) }

// The texture for the glow
#declare g1 = 
texture { 
   pigment { 
      granite
      color_map {
         [0 color rgb <1,0,0>]
         [1 color rgb <1,0.5,0>]
      }
   }
   finish {
      ambient 1
   }
}
#declare g2 = 
texture {
         pigment {
            crackle
            turbulence 0.5
            color_map {
               [0.05 color rgbt <0,0,0,0.5>]
               [0.15 color rgbt <0.2,0.2,0.2,0>]
            }
            scale 0.1
         }
      }
#declare glow =
texture { g1 }
texture { g2 }

union { // Cigarette
   union {
      cylinder { <0,0,0>,<5.9,0,0>,0.4
         pigment {
            gradient x
            turbulence <0.06,1,1>
            color_map {
               [burned/2 color rgbt <0,0,0,1>]
               [burned/2+0.01 color rgb <0.4,0.2,0.0>]
               [burned/2+0.02 color rgb 1]
            }
            scale <11.6,1,1>
         }
         finish {
            diffuse 0.9
            brilliance 0.6
         }
         hollow
      }
      difference {
         cylinder { <5.9,0,0>,<8.3,0,0>,0.4
            pigment {
               bozo
               color_map {
                  [0.9  color rgb <0.7,0.5,0.2>]
                  [0.91 color rgb <0.9,0.7,0.3>]
               }
               scale <0.15,0.1,0.1>
            }
            finish {
               diffuse 0.9
               brilliance 0.6
            }
         }
         box { <8.2,0.5,0.5>,<8.4,-0.5,-0.5>
            pigment { color rgb 1 }
            finish {
               brilliance 0.6
               diffuse 1
            }
            normal {
               granite 0.03
               scale 0.1
            }
         }
      }
      isosurface { // The glow
         function { sqrt(x*x+y*y+z*z)+0.1*noise3d(x*10,y*10,z*10) }
         threshold 0.4
         bounded_by { sphere { <0,0,0>,0.4 } }
         translate (5.8*burned-0.35)*x
         texture { glow }
         scale <2,1,1>
      }
      translate -4.2*x
   }
   cylinder { <0,0,0>,<0,30,0>,2 // The container for the smoke media
      pigment { color rgbt 1 }
      hollow
      interior {
         media {
            samples 2,20
            intervals 30
            scattering { 2 color rgb 0.8 }
            density {
               function { min(smoke(x,y,z),1) }
               color_map {
                  [0 color rgb 1]
                  [0.5 color rgb 0]
               }
            }
         }
      }
      scale <1,2,1>
      translate (5.8*burned-4.2)*x 
   }
}