// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.1
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?[esp]
//

#version 3.1;

#include "colors.inc"

global_settings
{
  assumed_gamma 1.0
}

// ----------------------------------------
camera
{
  location  <0.0, 0.5, -4.0>
  direction 1.5*z
  right     4/3*x
  look_at   <0.0, 0.0,  0.0>
}


  
sky_sphere
{
  pigment
  {
    gradient y  turbulence .3 lambda 3 frequency 3
    color_map { [0.0 color rgb 1]
                [0.5 color rgb <.2,.175,.3>*3]
                [1.0 color rgb 1] }
  }
  scale <2,1,1>
  rotate x*-20
}

light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------




camera {location <0,0,-3.5> look_at <0,.25,0>}
light_source {<-20,20,-20> rgb <.8,.8,1>}
light_source {<20,20,-20> rgb <1,.8,.8>/2}

#declare xx=function{
  pigment {
    image_map {
      //sys "sphere.bmp"
      tga"terrain" 
      interpolate 2
    } 
  rotate 90*x
  }
}

isosurface {
  function{y-xx(x,2*y,z)+.05*noise3d(15*x,30*y,15*z)} //was 80,100,80
  
  bounded_by {box {0,25}} //does this need to be big enough to contain the camera? or the hf is cut off ?
  eval                  
  translate -.5 
  scale <1,.5,1>
  scale 3.5
  texture {
    pigment { agate color_map{
    [0 color rgb <1,.5,.25>]
    //[.225 color rgb <.2,.6,.1>]
    [.25 color rgb <.8,.4,.1>]
    [.5 color rgb <.6,.3,.1>]
    [.75 color rgb <.6,.2,.2>]
    [1 color rgb <1,.5,.25>]
    }
    agate_turb .3
    lambda 6 frequency 6 
    scale .1
    }
    finish {ambient .1}
    normal{granite.2 scale .01}
  }
}


plane{y,-0.4 pigment{color rgb<.2,.6,.5>}
        normal{bumps .5 scale 0.001}
        finish{specular 1 roughness .002 reflection .2}
        hollow
        }
        
  fog {
    distance 15 
    color rgb<0.8, 0.8, 0.8>
    fog_type 2
    fog_offset .5
    fog_alt .3  
    turbulence 10
    turb_depth .5 
  }        