#include "colors.inc"
#include "textures.inc"

#declare PdV=< 0 , 11 , -42>;
camera {
 location  PdV
 direction <0.0 , 0.0 , 3 >
 up        <0 , 1 , 0>
 right     <4/3 , 0.0  , 0.0>
 look_at   < 0 , 11, 0>
}
#declare colTree=rgb<0.52,0.46,0.43>;

light_source { <-300, 1040, -520> color colTree*2}
light_source { <-1000, 1040, -1020> color rgb<1,.5,0.3>}
light_source { PdV color  colTree}

#declare txtTree=texture{
        pigment{
                granite
                color_map{
                        [0 color colTree*2]
                        [0.5 color colTree*1]
                        [1 color colTree*0.5]
                }
        }
        normal{wrinkles 2 scale 0.3}
        finish{ambient 0.2}
        scale <1,6,1>*0.3
}
         
background{White}         

// Tree macro                                    
// Based on the tree macro bundled in R. Suzuki's isosurface patch (1997)
// Quick and dirty adaptation by Gilles Tran                                             
// Please modify & improve !
// L = length of branches                           
// B = broadness of branches                           
// D = level of recursion (can be VERY long to parse if D>8)
// rX,rY,rZ : several parameters (!)
// yL = dummy used in macro to transfer the branch length between recursion levels, leave it to 0
// s1 : starts the random process before the macro
#declare s1=seed(8991); 

#macro mTree(L, B, D,rX,rY,rZ,yL)
#if (D > 0)
        union{
                #declare r1=0.5+rand(s1)/3;
                #declare r2=0.4+rand(s1)/3;
                #declare r3=0.4+rand(s1)/3;
                #declare r4=0.5-rand(s1);
                #local New_D = D - 1;
                #local New_B = B*r1;
                #local New_L = L*r1;
                #declare i=1;
                #declare Va=<0,0,0>;
                #declare Ba=B;
                #declare nSeg=D+3;

                #while (i<nSeg)
                        #declare r5=0.5-rand(s1);
                        #declare r6=0.5-rand(s1);
                        #if (i=nSeg)
                                #declare Vb=y*L;
                        #else
                                #declare Vb=<r5*B*1.5,L*i/nSeg,r6*B*1.5>;
                        #end

                #if (D=1)
                        #declare FinB=0.01;
                #else
                        #declare FinB=New_B;
                #end
                
                #declare Bb=B+(FinB-B)*i/nSeg;
                
                cone{Va,Ba,Vb,Bb     texture { txtTree}}
                sphere{0,Bb translate Vb     texture { txtTree}}

                #declare i=i+1;
                #declare Va=Vb;
                #declare Ba=Bb;
        #end
        mTree( New_L, New_B, New_D,65*r1,10*r2,10*r4,L)
        mTree( New_L, New_B, New_D,-65*r2,-70*r3,10*r4,L)
        mTree( New_L, New_B, New_D,-65*r3,70*r2,10*r4,L)
        rotate x*rX rotate y*rY rotate y*rZ translate y*L
        }
#end
#end          

#declare Tree1=mTree( 6, .4, 4,15,0,0,0)
#declare Tree2=mTree( 6, .4, 4,5,20,0,0)
#declare Tree3=mTree( 6, .4, 4,-5,0,20,0)

object{Tree1}
object{Tree2 rotate y*30 translate -x*4}
object{Tree3 rotate -y*70 translate x*4}

