// ==== Standard POV-Ray Includes ====
#include "colors.inc"	// Standard Color definitions
#include "textures.inc"	// Standard Texture definitions
#include "metals.inc"

// Set a color of the background (sky)
background { color red 0.1 green 0.3 blue 0.8 }

global_settings { assumed_gamma 1.0 }

#declare camera_location = <7,12,-20.0>
#declare camera_look_at = <0,0,0>
#declare camera_direction = <0,0,2.5>

camera
{
  location  camera_location
  direction camera_direction
  look_at   camera_look_at
}

// create a regular point light source
light_source
{
  0*x // light's position (translated below)
  color red 1.0  green 1.0  blue 1.0  // light's color
  translate <-20, 40, -20>
}

light_source { 0 colour rgb 1/2 translate camera_location shadowless fade_distance 10 fade_power 1 }

#declare FN_S = function { "sphere", <1> }

// Basic 'landform'.
#declare FN_Base = function { 1/(1+sqr(FN_S(x*2,0,z))) }

// Add some noise to get a shape.
#declare FN_Shape = function { FN_Base(x,0,z)*(1+noise3d(x*10,0,z*10)*0.01) }

#declare O_Land = isosurface {
	function { y - FN_Shape(x,0,z) }
	accuracy 0.001
	eval
	bounded_by { box { <-3,0,-3>,<3,1.1,3> } }
}
#declare PI = pi
#declare I_PI = 1/pi
#declare OFF = 0.01
#declare I_OFF = 0.5/OFF

#declare FN_Dx = function { FN_Base(x+OFF,0,z)-FN_Base(x-OFF,0,z) }
#declare FN_Dz = function { FN_Base(x,0,z+OFF)-FN_Base(x,0,z-OFF) }

#declare FN_Gradient = function {
	sqrt(sqr(FN_Dx(x,0,z))+sqr(FN_Dz(x,0,z)))*I_OFF
}

#declare FN_Radial   = function {
	0.5+0.5*I_PI*min(PI,max(-PI,atan(FN_Dx(x,0,z)/FN_Dz(x,0,z))))
}

#declare CM_Shade = colour_map { [0 Red][1/3 Green][2/3 Blue][1 Red] }

object { O_Land
	texture {
		pigment { function { y*0.99 } colour_map { CM_Shade } }
		finish { Dull }
	}
	translate <3,0,3>
}

object { O_Land
	texture {
		pigment { function { 0.75*FN_Gradient(x,0,z) } colour_map { CM_Shade } }
		finish { Dull }
	}
	translate <0,0,-3>
}

object { O_Land
	texture {
		pigment { function { 10*FN_Radial(x,0,z) } colour_map { CM_Shade } }
		finish { Dull }
	}
	translate <-3,0,3>
}
