//=====================================//
//                                     //
// Isosurface snowscape.               //
//                                     //
// By Mike Andrews.                    //
//  Released 2/9/99                    //
//                                     //
// Uses Superpatch specific code:      //
//     isosurface { ... },             //
//     function { pigment { ... } },   //
//     slope pattern,                  //
//     parallel light sources.         //
//                                     //
//=====================================//

global_settings { assumed_gamma 1.0 max_trace_level 5 }

// Raw sky colour.
background { color rgb <0.2,0.3,0.9> }

#declare camPos = <0.0, 2.0, -20>;
#declare camLookAt = <0,0,0>;
#declare camAngle = 90;

#declare lightDir = vrotate(vnormalize(<5,3,-1>), 0);
#declare lightLen = 10000;
#declare lightRad = lightLen*2*sin(radians(0.25));

camera {
	up <0, 1, 0>
	right <4/3, 0, 0>
	location  camPos
	direction <0.0, 0.0, 1>
	angle     camAngle
	look_at   camLookAt
}

// Main 'sun' light.
light_source {
	0*x
	colour rgb <1.0,.98,.96>
	translate lightDir*lightLen
	parallel
	point_at camLookAt
	media_attenuation on
}

// 'Sky' light. Shadowless for no specular highlights.
light_source {
	0*x
	colour rgb <0.2,0.3,0.9>*0.5
	translate y*lightLen
	parallel
	point_at -y
	shadowless
	media_interaction off
}

// Low, short haze for blue mountains.
fog {
	fog_type 2
	colour rgb (0.4+<0.2,0.3,0.9>)*0.5
	distance 30
	fog_alt 6
}

// High, far haze for yellowed horizon.
fog {
	fog_type 2
	colour rgb (1-<0.2,0.3,0.9>)*0.5
	distance 500
	fog_alt 15
}

// Ridged multifractal definition.
#declare L = 3;
#declare H = 1.1;
#declare P = 1;
#declare G = 1;

// I really wish you could use arrays and #while loops in functions ...
#declare F1 = L;
#declare F2 = F1*L;
#declare F3 = F2*L;
#declare F4 = F3*L;
#declare F5 = F4*L;
#declare F6 = F5*L;

#declare V1 = pow(F1,-H);
#declare V2 = pow(F2,-H);
#declare V3 = pow(F3,-H);
#declare V4 = pow(F4,-H);
#declare V5 = pow(F5,-H);
#declare V6 = pow(F6,-H);

#declare IMV = 1 / ((1+G*V1*P*P)*(1+G*V2*P*P)*(1+G*V3*P*P)*(1+G*V4*P*P)*(1+G*V5*P*P)*(1+G*V6*P*P));

#declare rge = function { sqr(P-abs(2*noise3d(x,y,z)-1)) }
#declare gaussTorus = function { exp(-sqr(sqrt(x*x+z*z)-2.5)) }

#declare rmf = function {
	rge(x,y,z) * 
	(1 + G*V1*rge(x*F1,y*F1,z*F1)) *
	(1 + G*V2*rge(x*F2,y*F2,z*F2)) *
	(1 + G*V3*rge(x*F3,y*F3,z*F3)) *
	(1 + G*V4*rge(x*F4,y*F4,z*F4)) *
	(1 + G*V5*rge(x*F5,y*F5,z*F5)) *
	(1 + G*V6*rge(x*F6,y*F6,z*F6)) *
	IMV
}

// Landscape. Ridged multi-fractal modified by a Gaussian torus function.
// Textured by slope to give snow on level, rock on steep.
isosurface {
	function { y-max(0,min(1,gaussTorus(x*0.5,0,z*0.5)*rmf(x*0.5,0,z*0.5))) }
	bounded_by { box { <-100,-0.1,-10>, <100,1,100> } }
	eval <3,1.2,0.92>
	max_gradient 10
	texture { 
		slope y 
		texture_map{ 
			[0.85 
				pigment {
					bozo octaves 1 
					frequency 4 triangle_wave
					colour_map { 
						[0.00 rgb 0.25]
						[0.03 rgb <1,.7,.3>*0.25]
						[0.40 rgb <1,.7,.3>*0.75]
						[0.40 rgb <1,.4,.4>*0.25]
						[0.42 rgb <1,.7,.3>*0.5]
						[1.00 rgb <1,.7,.3>*0.25]
					}
					scale <1,0.03,1> rotate <23,0,30>
				}
				finish { ambient 0 diffuse 0.7 brilliance 10 specular 0.4 roughness 1 metallic reflection 0.2 reflect_metallic }
				normal { 
					average 
					normal_map { 
						[1 bozo 0.6 octaves 1 frequency 4 scallop_wave scale <1,0.01,1> rotate <23,0,30>]
						[0.3 granite 0.2 scale 0.00001] 
					} 
				} 
				
			]
			[0.85 
				pigment { colour rgb 1 }
				finish { ambient 0 diffuse 1 brilliance 0.1 specular 0.5 roughness 0.001 reflection 0.3 }
				normal { wrinkles 0.1 scale 0.00001 }
			]
		} 
	}
	scale 3
}

// Clouds. Average two pigments, then put the colour map on afterwards.
#declare R = 6371;

sphere {
	0, R+10
	pigment {
		function {
			pigment {
				average
				pigment_map {
					[1 
						granite 
						scale 5 
						warp { turbulence 0.5 lambda 5 omega 0.5 octaves 5 }
						scale 3 
					]
					[1 bozo scale <75,75,30> rotate <0,30,0> triangle_wave colour_map {[0 rgb 1][1 rgb 0]} ]
				}
			}
		}
		colour_map {[0.35 rgbf 1][0.45 rgbf <1,1,1,0.8>][1 rgbf <1,1,1,0.3>] } 
	}
	finish { ambient 2 }
	translate -R*y
	hollow
}