#include "colors.inc"
#include "textures.inc"

global_settings { assumed_gamma 1.0 }

#declare camera_location = <3,4,-20.0>
#declare camera_look_at = <0,0.5,0>
#declare camera_direction = <0,0,2>

camera
{
  location  camera_location
  direction camera_direction
  look_at   camera_look_at
}

light_source { 0 color rgb 1 translate <-200, 400, 200> }

light_source { 0 colour rgb 1/2 translate camera_location shadowless }

#declare FN_Asteroids = function { (noise3d(x,y,z) & noise3d(x,y+100,z))-0.01 }

#declare T_Rock = texture {
	pigment {
	    granite
	    turbulence 0.2
	    frequency 4
	    color_map {
	        [ 0.0 Tan ]
	        [ 0.3 DustyRose ]
	        [ 0.6 Flesh ]
	        [ 1.0 DarkOliveGreen ]
	    }
	    scale 0.1
		rotate 20*x
	}
	finish { Dull metallic ambient 0 roughness 10 }
}

isosurface {
	function { FN_Asteroids(x,y,z) }
	accuracy 0.001
	eval
	bounded_by { sphere { 0,10 } }
	texture { T_Rock }
}
