// rgb<->hsi conversion macros
/*
	rgb2hsi(rgbcol) to convert RGB to HSI
	
		the vector rgbcol must contain at least 3 values <r,g,b> where r,g, & b in the range [0,1] (if your colour vector contains f or t they will be ignored.
	
		returns a three value vector <h,s,i> where h,s, & i in the range [0,1]

	hsi2rgb(hsicol) will convert HSI to RGB using the same constraints as rgb2hsi.
	
	desat(rgbcol,sat) will return the colour rgbcol with it's saturation multiplied by sat.

		This macro is designed to de-saturate colours, using it to increase colour saturation will produce undefined results.
*/

#ifndef(hsi_rgb)
	#declare hsi_rgb=1;
	#macro rgb2hsi(rgbcol)
		#local rgb_r=rgbcol.x;
		#local rgb_g=rgbcol.y;
		#local rgb_b=rgbcol.z;
		#local comc=rgb_r+rgb_g+rgb_b;
		#local hsi_i=comc/3;
		#local minc=min(min(rgb_r,rgb_g),rgb_b);
		#if (hsi_i>0)
			#local hsi_s=1-((3/comc)*minc);
		#else
			#local hsi_s=0;
		#end
		#if (hsi_s>0)
			#local hsi_h = 0.5*((rgb_r-rgb_g)+(rgb_r-rgb_b));
			#local hsi_h = hsi_h/sqrt(((rgb_r-rgb_g)^2)+ (rgb_r-rgb_b)*(rgb_g-rgb_b));
			#local hsi_h = acos(hsi_h)/(2*pi);
		#else
			#local hsi_h = 0;
		#end
		#if (rgb_b>rgb_g)
			#local hsi_h=1-hsi_h;
		#end
		<hsi_h,hsi_s,hsi_i>
	#end
	
	#macro hsi2rgb(hsicol)
		#local hsi_h=mod(hsicol.x,1);
		#local hsi_s=hsicol.y;
		#local hsi_i=hsicol.z;
		#local hsi_h=hsi_h*2*pi;
		#if (hsi_h<(2*pi/3))
			#local rgb_b=(1-hsi_s)/3;
			#local rgb_r=(1+((hsi_s*cos(hsi_h))/cos(pi/3-hsi_h)))/3;
			#local rgb_g=1-(rgb_r+rgb_b);
		#end
		#if (((2*pi/3)<=hsi_h) & (hsi_h<(4*pi/3)))
			#local hsi_h = hsi_h-(2*pi/3);
			#local rgb_r=(1-hsi_s)/3;
			#local rgb_g=(1+((hsi_s*cos(hsi_h))/cos(pi/3-hsi_h)))/3;
			#local rgb_b=1-(rgb_r+rgb_g);
		#end
		#if ((4*pi/3)<=hsi_h)
			#local hsi_h = hsi_h-(4*pi/3);
			#local rgb_g=(1-hsi_s)/3;
			#local rgb_b=(1+((hsi_s*cos(hsi_h))/cos(pi/3-hsi_h)))/3;
			#local rgb_r=1-(rgb_g+rgb_b);
		#end
		#local rgb_r=rgb_r*3*hsi_i;
		#local rgb_g=rgb_g*3*hsi_i;
		#local rgb_b=rgb_b*3*hsi_i;
		<rgb_r,rgb_g,rgb_b>
	#end
	
	#macro desat(rgbcol,sat)
		#local colvect=rgb2hsi(rgbcol);
		#local colvect=<colvect.x,colvect.y*sat,colvect.z>;
		hsi2rgb(colvect)	
	#end
#else
	#warning "HSI_RGB.INC already loaded"
#end
