//*****************************************************************************************************************************
// scene environment
//*****************************************************************************************************************************
#version unofficial MegaPov 0.7;
#local quality = 0;

#declare pov = vnormalize(<0,sin(clock*2*pi),cos(clock*2*pi)*0.5-0.6>)*30;
#declare poi = <0,0,0>;

camera {
	location pov
	sky y
	right 4/3*x
	look_at poi
}

sphere {
	pov 60
	hollow
}

global_settings {
	max_trace_level 30
	number_of_waves 20
	post_process {
//		focal_blur{vlength(pov-poi),vlength(pov-poi), 8, 1/2}
//		soft_glow{1,8}
	}
	#if (quality >=1)
		#if(quality >= 2)
	  		// High Quality - slow rendering
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=8"
		  	ini_option "Preview_End_Size=4"
		  
		  	radiosity{
			    count 80             // CHANGE range from 20 to 150
			    nearest_count 6      // CHANGE range from 3 to 10
			    error_bound 1        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16 (or 8 for high quality)
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 4    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
		  	}
		#else
		  	// Medium Quality - works for most scenes
		  	ini_option "+QR"
		  	ini_option "Preview_Start_Size=16"
		  	ini_option "Preview_End_Size=8"
		  
		  	radiosity{
			    count 40             // CHANGE range from 20 to 150
			    nearest_count 3      // CHANGE range from 3 to 10
			    error_bound 3        // CHANGE - range from 1 to 3 - should correspond with Preview_End_Size
			                         //   1 : preview_end_size = 4
			                         //   3 : preview_end_size = 8
			                         //   use preview_start_size = 16
			                         // you can go lower than 1, but then you probably will want to set
			                         // preview_end_size to 2, which is really slow
			    recursion_limit 3    // CHANGE
			    
			    low_error_factor .5  // leave this
			    gray_threshold 0.0   // leave this
			    minimum_reuse 0.015  // leave this
			    brightness 1         // leave this
			    
			    max_sample 1         // CHANGE - this should be the same as the brightest object
			    adc_bailout 0.01/1   // CHANGE - use adc_bailout = 0.01 / brightest_ambient_object
			    normal on
			}
		#end
	#end
}


union {
	sphere { 0,4 }
	cone { 0 4 y*-10 0 }
	cone { 0 4 vrotate(y*-10,z*120) 0 }
	cone { 0 4 vrotate(y*-10,z*240) 0 }
	rotate y*clock*360
	texture {
		pigment { rgb <0,0,0> }
		finish {
			//reflection_type 1
			//conserve_energy
			ambient 0
			diffuse 0
			reflection 0.5
		}
	}
	interior { ior 2 }
}

#local gcount=0;

#local sp1=seed(24);
#macro _split(p1,p2,c1,c2)
	#local p3= p1+(p2-p1)/2+vrotate((<rand(sp1),rand(sp1),rand(sp1)>-0.5)*vlength(p2-p1)/5,vnormalize(p2-p1)*clock*360);
	#if (lsz>0) #local p3=vnormalize(p3)*lsz; #end
	#local c3=(c1+c2)/2;
	glow { location p3 size lsi type 0 colour hsi2rgb(c3) }
	#declare gcount=gcount+1;
	#if (vlength(p3-p1)>llev) _split(p1,p3,c1,c3) #end
	#if (vlength(p2-p3)>llev) _split(p3,p2,c3,c2) #end
#end

#macro split(p1,p2,si,lev,c1,c2,sz)
	glow { location p1 size si type 0 colour hsi2rgb(c1) }
	glow { location p2 size si type 0 colour hsi2rgb(c2) }
	#declare gcount=gcount +2;
	#declare lsi=si*0.7;
	#declare llev=lev;
	#declare lsz=sz;
	_split(p1,p2,c1,c2)
#end

#include "hsi_rgb.inc"
split(<0,-10,0>,vrotate(vrotate(<0,-10,0>,z*120),y*clock*360),1/100,0.2,<clock,1/2,1>,<clock+1/3,1/2,1>,10)
split(vrotate(vrotate(<0,-10,0>,z*120),y*clock*360),vrotate(vrotate(<0,-10,0>,z*240),y*clock*360),1/100,0.2,<clock+1/3,1/2,1>,<clock+2/3,1/2,1>,10)
split(vrotate(vrotate(<0,-10,0>,z*240),y*clock*360),<0,-10,0>,1/100,0.2,<clock+2/3,1/2,1>,<clock+1,1/2,1>,10)

split(<0,-10,0>,<0,-10,0>*2,1/100,0.2,<clock,1/2,1>,<clock,1/2,0>,0)
split(vrotate(vrotate(<0,-10,0>,z*120),y*clock*360),vrotate(vrotate(<0,-10,0>,z*120),y*clock*360)*2,1/100,0.2,<clock+1/3,1/2,1>,<clock+1/3,1/2,0>,0)
split(vrotate(vrotate(<0,-10,0>,z*240),y*clock*360),vrotate(vrotate(<0,-10,0>,z*240),y*clock*360)*2,1/100,0.2,<clock+2/3,1/2,1>,<clock+2/3,1/2,0>,0)

#warning concat("Glow count is:",str(gcount,0,0),"\n")



