
// ******************************************************************
// POV Ray Tracer Scene Description File
//
         #version 3.0
//
//     File Name: CardBack1.pov
// Date Finished: mm/dd/yy
//        Author: ??
//
//       Notices:  Permission is given to copy, distribute, and use
//                 this file provided that this notice and the above
//                 notice of authorship remain intact.  Permission
//                 is given to modify and distribute this file
//                 provided that all modifications are clearly noted
//                 and that original code is left intact in comments.
//
//                 The author accepts no responsibility for any
//                 damages, direct or indirect, arising from the use
//                 of this file and/or the objects defined herein.
//
//   Description:
//
//   Rendering Options:  +W71 +H96 +FS
// ******************************************************************
//
// ==== Internal Rendering Switches ====
   #declare View_POV_Include_Stack = 1

//
// ==== Standard POV-Ray Includes ====
   #include "colors.inc"         // Standard Color definitions
   #include "textures.inc"       // Standard Texture definitions

//
// ==== GLOBAL SETTINGS ====
   default { finish { ambient .08 diffuse .92 } }

   global_settings {
      adc_bailout       0.0039216
      ambient_light     <1.0,1.0,1.0>         //White
      assumed_gamma     1.0
      hf_gray_16        off
      irid_wavelength   <0.25,0.18,0.14>
      max_intersections 200
      max_trace_level   20
      number_of_waves   10
   }
//
// ==== CAMERA ====
   camera {
      location <-80, 35, -140>
      right    71/96*x
      up       y
      look_at  <25, 10, 0>
   }
//
// ==== LIGHTS ====
   light_source { <60, 120, -170> rgb 1 }
//
// ==== SKY ====

// Set a color of the background (sky)
background { color  blue 0.35 }

//
// ==== FLOOR ====
plane // The maze-textured ground
   {
   y, 0

   pigment
      {
      image_map { iff "maze.iff" }
      quick_colour rgb <0, 0, 08>
      rotate x*90
      scale 1600
      translate <-196, 0, 160>
      }

   finish { reflection .5 }
   }
//
// ==== DECLARES ====

//
// ==== OBJECTS ====

//
// ************************** The Scene *****************************
union // Pac Man
   {
   intersection // Body
      {
      sphere { 0, 30 }
      sphere { 0, 28 inverse }

      union
         {
         plane { y, 0 rotate -35*x }
         plane { -y, 0 rotate 10*x }
         }

      sphere { -29*z, 1.5 inverse rotate <16, -4, 0> }
      sphere { -29*z, 1.5 inverse rotate <16, 4, 0> }

      pigment { rgb <.83, .67, 0> }
      finish { specular .5 roughness .1 }
      }

   intersection // Mouth
      {
      sphere { 0, 28 }

      union
         {
         plane { y, -2 rotate -35*x }
         plane { -y, -2 rotate 10*x }
         }

      pigment { rgb <.29, 0, 0> }
      finish { ambient .05 diffuse .95 }
      }

   union // Tongue
      {
      sphere { <3, 0, -15>, 10 }
      sphere { <-3, 0, -15>, 10 }

      rotate -45*x

      pigment { rgb <1, 0, 0> }
      normal { wrinkles .5 scale .5 }
      finish { reflection .5 }
      }

   union // Right eye
      {
      union
         {
         sphere { 0, 6 pigment { rgb 1 } }
         sphere { -2.3*z, 4 pigment { rgb <.11, .19, .67> } }
         sphere { -5.5*z, 1 pigment { rgb 0 } }

         finish { reflection .5 }
         }

      sphere
         {
         0, 1

         scale <9, 2, 9>
         translate <0, 8, 6>
         rotate -10*z

         pigment { rgb 0 }
         }

      rotate <-25, -20, 0>
      translate -26*z
      rotate <25, 20, 0>
      }

   union // Left eye
      {
      union
         {
         sphere { 0, 6 pigment { rgb 1 } }
         sphere { -2.3*z, 4 pigment { rgb <.11, .19, .67> } }
         sphere { -5.5*z, 1 pigment { rgb 0 } }

         finish { reflection .5 }
         }

      sphere
         {
         0, 1

         scale <9, 2, 9>
         translate <0, 8, 6>
         rotate 10*z

         pigment { rgb 0 }
         }

      rotate <-25, 20, 0>
      translate -26*z
      rotate <25, -20, 0>
      }

   translate 32*y
   }

// Food

union
   {
   sphere { <0, 27, -25>, 4 }
   sphere { <0, 27, -45>, 4 }
   sphere { <0, 27, -65>, 4 }
   sphere { <0, 27, -85>, 4 }
   sphere { <0, 27, -105>, 4 }

   pigment { rgb 1 }
   finish { specular 2 roughness .01 reflection .6 }
   }
