// planet.inc -- creates an earthlike planet with atmosphere.  Based on
// photos of Earth from the NASA photo gallery.
//
// Written April 1998 by Jeff Lee <shipbrk@gate.net>
//
// Part of the texture involves fading to blue in the +Z direction, so
// this particular planet should *not* be rotated.
//
// If the variable Quick is defined (the value is irrelevant), a plain
// blue sphere is produced (halos and complex textures are ignored).
//
//----------------------------------------------------------------------
// Land textures.  Mostly tan and green, with a bluish cast.
//
#declare p_land1 = pigment {
  bozo
  colour_map {
    [0.00 colour rgb <0.534,0.534,0.450>]
    [0.07 colour rgb <0.534,0.560,0.450>]
    [0.15 colour rgb <0.500,0.560,0.450>]
    [0.22 colour rgb <0.534,0.534,0.450>]
    [0.30 colour rgb <0.534,0.560,0.450>]
    [0.35 colour rgb <0.500,0.560,0.450>]
    [0.50 colour rgb <0.600,0.600,0.600>]
    [0.75 colour rgb <0.600,0.750,0.600>]
    [1.00 colour rgb <0.550,0.700,0.600>]
  }
  turbulence 1.75
  lambda 3.0
  omega 0.75
  scale 0.25
}

//----------------------------------------------------------------------
// Polar ice caps.
//
#declare p_land2 = pigment { colour rgb <1,1,1> }

//----------------------------------------------------------------------
// Gradient to give us ice at the poles.
//
#declare LandTexture = texture {
  pigment {
    gradient y
    pigment_map {
      [0.00 p_land2]
      [0.10 p_land2]
      [0.10 p_land1]
      [0.90 p_land1]
      [0.90 p_land2]
      [1.00 p_land2]
    }
    translate y*-0.5
    scale <1,2,1>
    turbulence y*0.2
  }
  normal { bumps 0.5 turbulence 0.5 scale 0.01 }
  rotate <5,0,-10>
}

//----------------------------------------------------------------------
// Light-blue water texture.  It lightens as it approaches the land
// masses, to simulate changes in depth.  The land shows through the
// clear spots
//
#declare WaterTexture = texture {
  pigment { bozo 
    colour_map {
      [0.00 colour rgb <0.20,0.50,0.95>]
      [0.30 colour rgb <0.25,0.60,0.95>]
      [0.60 colour rgb <0.30,0.65,0.99>]
      [0.64 colour rgb <0.60,0.85,1.00>]
      [0.64 colour rgbt <1,1,1,1>]
      [1.00 colour rgbt <1,1,1,1>]
    }
    turbulence 1.0
    lambda 2.35
    omega 0.75
    scale 0.5
  }
  rotate <15,25,-5>
}

//----------------------------------------------------------------------
// Combination of the land and water elements.
//
#declare PlanetSphere = sphere { <0,0,0>, 1
  #ifndef (Quick)
    texture { LandTexture }
    texture { WaterTexture }
  #else
    pigment { colour rgb <0.25,0.60,0.95> }
  #end
}

//----------------------------------------------------------------------
// Clouds.
//
#declare CloudTexture = texture {
  pigment { bozo
    colour_map {
      [0.00 colour rgbt <0,0,0,1>]
      [0.10 colour rgbt <0,0,0,1>]
      [0.14 colour rgbt <0.75,0.75,0.75,1.00>]
      [1.00 colour rgbt <1,1,1,0>]
    }
    turbulence 5.0
    lambda 3.0
    omega 0.55
    scale <1,0.55,0.5>
  }
}

//----------------------------------------------------------------------
// Simulate atmospheric haze; transparent wash of blue intensifying
// in the +Z direction.
//
#declare BlueFade = texture {
  pigment {
    gradient z
    colour_map {
      [0.00 colour rgbt <0.5,1,1,1>]
      [0.30 colour rgbt <0.5,1,1,1>]
      [0.65 colour rgbt <0,1,1,0.5>]
      [1.00 colour rgbt <0,1,1,0.5>]
    }
    translate z*-0.5
    scale 2.5
  }
}


//----------------------------------------------------------------------
// The cloud sphere is a combination of the cloud texture and the
// "blue fade".  Land and water seen through the clouds are also
// affected by the blue fade.
//
#declare PlanetCloudSphere0 = sphere { <0,0,0>, 1.001
  texture { CloudTexture }
  texture { BlueFade }
  rotate x*-10
}

//----------------------------------------------------------------------
// A thin blue halo, becoming lighter as it approaches the planet's
// surface.
//
#declare PlanetAtmosphere = sphere { <0,0,0>, 1
  pigment { colour rgbt <1,1,1,1> }
  halo {
    glowing
    spherical_mapping
    linear
    colour_map {
      [0.00 colour rgbt <0,0,2,1>]
      [0.05 colour rgbt <2,2,2,0>]
      [1.00 colour rgbt <2,2,2,0>]
    }
    samples 10
  }
  hollow
  scale 1.05
}  


#declare Planet = union {
  object { PlanetSphere }
  #ifndef (Quick)
    object { PlanetCloudSphere0 }
    object { PlanetAtmosphere }
  #end
}
