//#declare E1701_No_Lights=1
//#declare Quick=1

#include "colors.inc"
#include "ncc1701.inc"
#include "planet.inc"

// Based on the Starfield texture from the POV-Ray distribution.
//
#declare jslStarfield =
texture {
  pigment {
    granite
    color_map {
      [0.00 0.76 color Black  color Black]
      [0.80 0.82 color Gray20 color Gray40]
      [0.82 0.84 color Gray40 color Gray60]
      [0.84 0.86 color Gray60 color Gray80]
      [0.86 0.88 color Gray80 color Gray95]
      [0.88 0.91 color Gray95 color White]
      [0.91 1.00 color Black  color Black]
    }
    scale .015
  }
  finish { ambient 1 diffuse 0 }
}

#declare StarSphere = sphere { <0,0,0>, 100000
  inverse
  texture { jslStarfield scale 100000 }
}

object { Enterprise_1701 rotate z*-5 rotate y*-37.5 translate <-15,0,-15>}
object { StarSphere }
object { Planet scale 2250 translate <1928,-1250,2298> }

camera { location <0,-10,-75> look_at <0,0,0> }
light_source { <-5000, 10000,-10000> colour rgb <1,1,1> }          // primary light source
light_source { <5000, -5000,-10000> colour rgb <0.3,0.3,0.3> }     // fill light
light_source { <-5000, -5000,-10000> colour rgb <0.15,0.15,0.15> } // fill light
