//************************************************************************************
// ncc1701.inc -- USS Enterprise from the original "Star Trek" TV series.
//
// Written April 1998 by Jeff Lee <shipbrk@gate.net>
//
// Permission is granted to use these include files for any noncommercial
// purpose, as long as credit is given to the original author.  When
// distributing these files, please distribute the original archive only,
// or clearly label the files as modified from the original versions,
// retaining the original author's name and email address and adding the
// name of the modifier.
//
//============================================================================
//============================================================================
//
// This POV-Ray 3.0 include file produces an object called Enterprise_1701,
// a model of the USS Enterprise "built" from the blueprints drawn by Franz
// Joseph (published by Ballantine Books, 1973).  The beam lies along the
// Z axis, with the bow in -Z, and the stern in Z.  The top of the vessel
// is +Y.  Please see the description of the variable E1701_Scale at the end
// of the next section for information pertaining to scaling the object.
//
//============================================================================
//
// The following section describes the variables which can be declared
// prior to including this file.  They control the various features of the
// Enterprise, primarily for use in animations.
//
// E1701_No_Lights (values: irrelevant;  default: undeclared)
//
//    By default, the include file uses nine light sources to enhance the
//    realism of the Enterprise.  This has the effect of slowing down the
//    render.  For test renders, the user may wish to define the variable
//    E1701_No_Lights, to prohibit the use of these light sources.
//
// Quick (values: irrelevant;  default: undeclared)
//
//    For performing test renders, it may be desirable to avoid adding
//    the surface normals, reflective finishes, image maps and windows.
//    Setting the variable Quick to any value will produce this result.
//
// E1701_Nacelle_Type (values: 0, 1, 2;  default: 2)
//
//    The texture of the collector globe at the front of the warp nacelles
//    may be selected by setting this value.  Type 0 is a plain dark brown,
//    usually (but not always) shown when the Enterprise is not at warp.
//    Type 1 is similar to the appearance of the collector in the animated
//    series.  Type 2 is a fairly close rendition of the collectors'
//    appearance when the warp engines are active.  Types 1 and 2 can
//    rotate during animations (see below).
//
// E1701_Nacelle_Rotate (values: 0 through 1;  default: 0)
//
//    With a nacelle type of 1 or 2, the rotation of the collector texture
//    may be controlled by this variable.  The values may be any real
//    number between 0 and 1, which is multiplied by a value of 360 to
//    produce the rotation.  If the value is set to the POV-Ray clock,
//    the texture will rotate one full turn throughout the animation;
//    if set to clock*2, it will rotate twice, and so forth.  The port and
//    starboard nacelles rotate in opposite directions.  Values greater
//    than 1 are effectively the value modulo 1 (1.5 is treated as 0.5).
//
// E1701_Lights_On (values: 0,1;  default: 1)
//
//    The formation lights and landing beacon are controlled by this
//    variable.  When the value is 0, the "unlit" texture is used, and no
//    light source is created.  When the value is 1, the "lit" texture is
//    used, and the light sources are created (unless the variable
//    E1701_No_Lights is defined).
//
// E1701_Shuttle_Bay_Open (values: 0 through 1;  default: 0)
//
//    The shuttle bay doors can open and close.  At this time, there is
//    not yet an actual shuttle bay inside, but the author does plan to
//    create one in the future.  However, setting this value to any range
//    between 0 (closed) and 1 (open) will set the doors appropriately.
//    It is not recommended to set this value outside the specified range.
//
// E1701_Scale (values: any valid scaling term;  default:1 [<1,1,1>])
//
//   Because the light sources for the beacons and sensors use a falloff
//   to limit their range, scaling the object without scaling their
//   falloff values will produce unsatisfactory results.  Therefore,
//   declare the scaling factors using this term, and the object will be
//   scaled and the falloff radii modified appropriately.
//
//============================================================================
//============================================================================
//
// Set defaults.
//
#ifndef (E1701_Nacelle_Type)
  #declare E1701_Nacelle_Type=2
#end
#ifndef (E1701_Nacelle_Rotate)
  #declare E1701_Nacelle_Rotate=0
#end
#ifndef (E1701_Lights_On)
  #declare E1701_Lights_On=1
#end
#ifndef (E1701_Shuttle_Bay_Open)
  #declare E1701_Shuttle_Bay_Open=0
#end
#ifndef (E1701_Scale)
  #declare E1701_Scale=1
#end

//============================================================================
// Include the subfiles
//
#include "1701colr.inc" // textures
#include "1701hul1.inc" // primary hull (saucer)
#include "1701hul2.inc" // secondary hull (cigar) and dorsal
#include "1701nacl.inc" // warp nacelles and pylons

//============================================================================
// Declare the object.
//
#declare Enterprise_1701 = union {
  object { E1701_Hull1 translate z*-16 }
  object { E1701_Hull2 translate <0.0,-9.5,-6.0> }
  object { E1701_Starboard_Nacelle translate <-11.7,2.6,4> }
  object { E1701_Starboard_Pylon translate <0,2.75,0> rotate z*45 translate <0,-9.3,12.1> }
  object { E1701_Port_Nacelle translate < 11.7,2.6,4> }
  object { E1701_Port_Pylon translate <0,2.75,0> rotate z*-45 translate <0,-9.3,12.1> }
  scale E1701_Scale
}
