//************************************************************************************
// 1701nacl.inc -- Warp nacelles for the original USS Enterprise.
//
// Written April 1998 by Jeff Lee <shipbrk@gate.net>
//
//============================================================================
//============================================================================
//
// Collector dome, port nacelle.  I had to do each collector separately,
// because when animated, the starboard and port collector textures rotate
// in opposite directions.
//
#declare E1701_Nacelle_Tip_Port = intersection {
  sphere { 0, 1 }
  plane { z, 0 }
  #switch (E1701_Nacelle_Type)
    #case (1)
      texture { t_NacTip4 rotate 360*z*E1701_Nacelle_Rotate }
    #break
    #case (2)
      texture { t_NacTip5Port }
    #break
    #else
      texture { t_NacTip1 }
  #end
  scale 2.0
}

//============================================================================
// Collector dome, starboard nacelle.
//
#declare E1701_Nacelle_Tip_Starboard = intersection {
  sphere { 0, 1 }
  plane { z, 0 }
  #switch (E1701_Nacelle_Type)
    #case (1)
      texture { t_NacTip4 rotate 360*z*-E1701_Nacelle_Rotate }
    #break
    #case (2)
      texture { t_NacTip5Starboard }
    #break
    #else
      texture { t_NacTip1 }
  #end
  scale 2.0
}


//============================================================================
// The "flux constrictors" are the three boxy things on the bottom of the
// nacelle, just aft of the collector domes.
//
#declare E1701_Nacelle_Flux_Constrictor = union {
  cylinder { <-0.6,-2.0, 0.95>, <0.6,-2.0,0.95>, 0.25 }
  box { <-0.6,-2.25,0.95>, <0.6,-1.75,3.30> }
  intersection {
    box { <-0.6,-2.25,3.30>, <0.6,-1.75,4.00> }
    plane { -y, 0 rotate x*-15 translate <0,-2.25,3.30> }
  }
  translate y*-0.1
}

//============================================================================
// The sensors are just little silver bulges where the collector domes meet
// the collar.
//
#declare E1701_Nacelle_Sensor = sphere {
  <0,-4,0>, 0.225
  scale <1,0.5,1>
  texture { t_nacelle_sensor }
}

//============================================================================
// The collar assembly includes the sensors, flux constrictors, and the little
// inset ridges just before the main nacelle body.
//
#declare E1701_Nacelle_Collar = union {
  difference {
    union {
      cone { <0,0,0.3>, 2.20, <0,0,0>, 2.00 }
      cylinder { <0,0,0.3>, <0,0,1.25>, 2.20 }
    }
    cylinder { <0,0,-0.001>, <0,0,1.251>, 1.95 }
  }
  union {
    difference {
      cylinder { <0,0,1.25>, <0,0,1.95>, 2.00 }
      cylinder { <0,0,1.25>, <0,0,1.96>, 1.95 }
    }
    torus { 2.00, 0.05 rotate x*-90 translate z*1.35 }
    torus { 2.00, 0.05 rotate x*-90 translate z*1.50 }
    torus { 2.00, 0.05 rotate x*-90 translate z*1.65 }
    torus { 2.00, 0.05 rotate x*-90 translate z*1.80 }
    texture { t_dark_hull }
  }

  object { E1701_Nacelle_Sensor }
  object { E1701_Nacelle_Sensor rotate z*120 }
  object { E1701_Nacelle_Sensor rotate z*-120 }
 
  object { E1701_Nacelle_Flux_Constrictor }
  object { E1701_Nacelle_Flux_Constrictor rotate z*-45}
  object { E1701_Nacelle_Flux_Constrictor rotate z*45}
}

//============================================================================
// The intercoolers are the tubelike things protruding out from the main
// nacelle body.  There are three versions: one for the two intercoolers at
// the aft of the nacelle, one for the inboard assembly on the port nacelle,
// and one for the inboard assembly on the starboard nacelle.  The difference
// is in the little bits that stick out or up where the intercooler meets the
// nacelle body.
//
#declare E1701_Intercooler_Edge = union {
  cylinder { <0,0,0>, <0,1,0>, 0.25 }
  intersection {
    torus { 0.5, 0.25 rotate z*-90 }
    box { <-0.3,0,-0.8>, <0.3,0.8,0> }
    translate <0,1,0.5>
  }
  scale <1,1,2>
}

#declare E1701_Intercooler = union {
  object { E1701_Intercooler_Edge }
  object { E1701_Intercooler_Edge rotate y*180 translate z*6.9 }
  cylinder { <0,1.5,1.0>, <0,1.5,5.9>, 0.25 }
}

#declare E1701_Intercooler_Bit = union {
  cylinder { <0,0,0>, <0,0,0.95>, 0.075 }
  sphere { <0,0,0.95>, 0.075 }
  translate y*0.525
}

#declare E1701_Intercooler1 = union {
  object { E1701_Intercooler translate y*-0.25 }
  object { E1701_Intercooler_Bit rotate y*180 }
  object { E1701_Intercooler_Bit translate z*6.9 }
}

#declare E1701_Intercooler2 = union {
  object { E1701_Intercooler translate y*-0.65 }
  object { E1701_Intercooler_Bit rotate y*90 }
  object { E1701_Intercooler_Bit rotate y*90 translate z*6.9 }
  rotate <3.0,0,90>
  translate <-1.9,0,8.4>
}

#declare E1701_Intercooler3 = union {
  object { E1701_Intercooler translate y*-0.65 }
  object { E1701_Intercooler_Bit rotate y*-90 }
  object { E1701_Intercooler_Bit rotate y*-90 translate z*6.9 }
  rotate <3.0,0,-90>
  translate <1.9,0,8.4>
}

//============================================================================
// The "chillers" are just grilles.
//
#declare E1701_Nacelle_Chillers = box {
  <-1.80,-0.625,30.325>, <1.80,0.625,33.1>
  texture { t_grille }
}

#declare E1701_Nacelle_SmallChillers = union {
  box { <-0.10,-0.47,0.00>, <0.10,0.47,2.05> }
  box { <-0.15,-0.42,0.05>, <0.15,0.42,2.00> texture { t_grille2 }}
}

#declare E1701_Nacelle_Chiller_Array = union {
  object { E1701_Nacelle_SmallChillers }
  object { E1701_Nacelle_SmallChillers translate z*2.05 }
  object { E1701_Nacelle_SmallChillers translate z*4.10 }
  object { E1701_Nacelle_SmallChillers translate z*8.50 }
  object { E1701_Nacelle_SmallChillers translate z*10.55 }
  object { E1701_Nacelle_SmallChillers translate z*12.60 }
  object { E1701_Nacelle_SmallChillers translate z*14.65 }
  object { E1701_Nacelle_SmallChillers translate z*16.70 }
}

//============================================================================
// Scoop cut out of the inboard side.
//
#declare E1701_Nacelle_Scoop = union {
  cylinder { <-8.04,0,7.4>, <-6.8,0,28.0>, 1 scale <0.25,0.65,1.0> }
  sphere { 0,1 scale <0.25,0.65,1> translate <-1.7,0,28.0> }
  texture { t_dark_hull }
}

//============================================================================
// The inboard intercooler connects to the reactor block.
//
#declare E1701_Nacelle_ReactorBlock = intersection {
  box { <-2.3,-0.4,6.3>, <-1,0.4,8.8> }
  plane { -x, 0 rotate y*-30 translate <-2.0,0,6.3> }
}

//============================================================================
// The main body consists of everything that can be rotated 180 degrees to
// form either the port or starboard nacelle.  Everything else must be added
// separately so that it's oriented properly.
//
#declare E1701_Nacelle_Body = union {
  difference {
    cone { <0,0,1.95>, 2.20, <0,0,33.75>, 1.65 }
    object { E1701_Nacelle_Scoop }
    cylinder { <0,0,1.9>, <0,0,5.0>, 1.95 }
  }
  object { E1701_Nacelle_Chillers }
  object { E1701_Nacelle_Chiller_Array rotate y*1.0 translate <-1.8,0,8.8> }
  object { E1701_Nacelle_ReactorBlock }
}

//============================================================================
// The cowl is the aft end of the nacelle.  They used several different models
// in the TV series, some of which had different nacelle cowls.  The one here
// is taken from the blueprints.
//
#declare E1701_Nacelle_Cowl =  union {
  cone { <0,0,33.85>, 1.65, <0,0,34.05>, 1.63 }
  cone { <0,0,33.75>, 1.63, <0,0,34.15>, 1.61 texture { t_dark_hull }}
  difference {
    intersection { 
      cone { <0,0,34.15>, 1.63, <0,0,37.0>, 1.60
        texture { t_nacelle_cowl }
      }
      union {
        box { <-1.7,-1.7,34.1>, <1.7,1.7,35.4> }
        cylinder { <-1.7,2.40,34.40>, <1.7,2.40,34.40>, 2.5 }
      }
    }
    cone { <0,0,34.14>, 1.53, <0,0,37.01>, 1.50 }
    cylinder { <-1.7,-2.25,37.45>, <1.7,-2.25,37.45>, 3.10 }
  }
  sphere { <0,0,34.80>, 1.35 }
}

//============================================================================
// Port and starboard nacelles constructed of the various parts.
//
#declare E1701_Port_Nacelle = union {
  object { E1701_Nacelle_Tip_Port }
  object { E1701_Nacelle_Collar }
  object { E1701_Nacelle_Body }
  object { E1701_Nacelle_Cowl }
  object { E1701_Intercooler2 }
  object { E1701_Intercooler1 rotate x*1 translate <0,1.25,26.0> rotate z*-45 }
  object { E1701_Intercooler1 rotate x*1 translate <0,1.25,26.0> rotate z* 45 }
  texture { t_nacelle_streaky }
  #ifndef (Quick)
    texture { t_port_nacelle_label }
  #end
}

#declare E1701_Starboard_Nacelle = union {
  object { E1701_Nacelle_Tip_Starboard }
  object { E1701_Nacelle_Collar }
  object { E1701_Nacelle_Body rotate z*180 }
  object { E1701_Nacelle_Cowl }
  object { E1701_Intercooler3 }
  object { E1701_Intercooler1 rotate x*1 translate <0,1.25,26.0> rotate z*-45 }
  object { E1701_Intercooler1 rotate x*1 translate <0,1.25,26.0> rotate z* 45 }
  texture { t_nacelle_streaky }
  #ifndef (Quick)
    texture { t_starboard_nacelle_label }
  #end
}

//============================================================================
// Grille on the inboard face of the nacelle pylons.
//
#declare E1701_Pylon_Grille = box { 
  <-0.05, -1.0, -0.5>, <0.05,1.0,0.5>
}

//============================================================================
// Assembly of all four grilles. 
//
#declare E1701_Pylon_Grilles = union { 
  object{ E1701_Pylon_Grille translate y*2.7 }
  object{ E1701_Pylon_Grille translate y*5.25 }
  object{ E1701_Pylon_Grille translate y*7.8 }
  object{ E1701_Pylon_Grille translate y*10.35 }
  texture { t_grille }
  translate y*-0.5
}

//============================================================================
// Outboard windows on the pylons.
//
#declare E1701_Pylon_Window = box{ <-0.0125,-0.1,-0.5>, <0.0125,0.1,-0.8> 
  texture { t_dark_window }
}

//============================================================================
// Main shape for the pylons.
//
#declare E1701_Pylon_Base = union {
  cylinder{ <0,-0.5,-0.9>, <0,12.5,-0.9>, 0.3 }
  box{ <-0.3,-0.5,-0.9>, <0.3,12.5,0.9> }
  cylinder{ <0,-0.5,0.9>, <0,12.5,0.9>, 0.3 }
}

//============================================================================
// Add the grilles and windows.
//
#declare E1701_Starboard_Pylon = union {
  difference{ 
    object{ E1701_Pylon_Base }
    object{ E1701_Pylon_Window translate <-0.3, 2.625, 0.0> }
    object{ E1701_Pylon_Window translate <-0.3, 10.95, 0.0> }
    object{ E1701_Pylon_Window translate <-0.3,  9.90, 0.0> }
  }
  object{ E1701_Pylon_Grilles translate <0.3,0,0> }
  texture{ t_Hull_BasicTexture }
}

//============================================================================
// Put the grilles and windows on the port and starboard pylons.
//
#declare E1701_Port_Pylon = union {
  difference{ 
    object{ E1701_Pylon_Base }
    object{ E1701_Pylon_Window translate <0.3, 2.625, 0.0> }
    object{ E1701_Pylon_Window translate <0.3, 10.95, 0.0> }
    object{ E1701_Pylon_Window translate <0.3,  9.90, 0.0> }
  }
  object{ E1701_Pylon_Grilles translate <-0.3,0,0> }
  texture{ t_Hull_BasicTexture }
}
