//************************************************************************************
// 1701hul2.inc -- Secondary hull (cigar section) of the original USS
// Enterprise.
//
// Written April 1998 by Jeff Lee <shipbrk@gate.net>
//
// Permission is granted to use these include files for any noncommercial
// purpose, as long as credit is given to the original author.  When
// distributing these files, please distribute the original archive only,
// or clearly label the files as modified from the original versions,
// retaining the original author's name and email address and adding the
// name of the modifier.
//
//====================================================================================
//============================================================================
//
// Sensor dish.
//
#declare E1701_Hull2_Dish = union {
  difference {
    sphere { <0,0,-4.13>, 3.56 }
    sphere { <0,0,-5.05>, 4.35 }
    bounded_by { cylinder { <0,0,-1.5>, <0,0,0.65>, 2.3 }}
  }
  torus { 1.60, 0.05 rotate x*90 translate z*-1.0 }
  torus { 1.25, 0.05 rotate x*90 translate z*-0.9 }
  torus { 0.90, 0.05 rotate x*90 translate z*-0.8 }
  texture { t_sensor_dish }
}

//============================================================================
// Sensor dish with antenna/stem added.
//
#declare E1701_Hull2_Sensor = union {
  object { E1701_Hull2_Dish }
  cylinder { <0,0,0.6>, <0,0,-0.6>, 0.25 }
  cone { <0,0,-0.6>, 0.2, <0,0,-0.95>, 0.15 }
  cone { <0,0,-0.95>, 0.10, <0,0,-2.30>, 0.05 }
  cylinder { <0,0,-2.30>, <0,0,-2.50>, 0.10 }
  texture { t_sensor_antenna }
}

//============================================================================
// Bay behind sensor dish.
//
#declare E1701_Hull2_SensorBay = union {
  difference {
    cylinder { <0,0,0>, <0,0,0.6>, 2.3 }
    cylinder { <0,0,-0.1>, <0,0,0.5>, 2.25 }
  }
  torus { 2.275, 0.1 rotate x*90 }
  texture { t_sensor_bay }
}

//============================================================================
// First set of stuff behind sensor bay
//
#declare E1701_Hull2_Layer1 = difference {
  sphere { <0,0,0>, 2.9 scale <1,1,1.7> translate z*2.05 }
  plane { z, 0.4 }
  cylinder { <0,0,0.35>, <0,0,0.6>, 2.5 }
  texture { t_hull2_streaky }
}

//============================================================================
// Second set of stuff behind sensor bay
//
#declare E1701_Hull2_Layer2 = union {
  cylinder { <0,0,2.0>, <0,0,2.7>, 3.25 }
  torus { 3.2,0.45 rotate x*90 translate z*3 }
  texture { t_hull2_streaky }
}

//============================================================================
// The main shape for the secondary hull.
//
#declare E1701_Hull2_Cigar_Lathe = lathe {
  cubic_spline 42,
  <2.90,13.10>, <2.50,16.75>, <2.44,17.78>, <1.94,18.61>, <1.15,19.63>, 
  <0.40,21.74>, <0.24,23.15>, <0.29,24.43>, <0.53,25.20>, <1.09,25.49>, 
  <1.74,25.62>, <2.36,25.44>, <2.60,25.05>, <2.60,24.15>, <2.60,23.30>, 
  <2.70,20.60>, <2.80,18.20>, <2.85,17.25>, <2.90,16.50>, <3.00,15.40>,
  <3.20,13.60>, <3.40,11.85>, <3.60,10.15>, <3.70, 9.10>, <3.80, 7.45>,
  <3.85, 6.40>, <3.85, 5.80>, <3.80, 4.70>, <3.75, 3.90>, <3.65, 3.00>,
  <3.55, 2.65>, <3.45, 2.20>, <3.06, 2.04>, <2.85, 2.55>, <3.15, 3.30>,
  <3.30, 4.30>, <3.45, 5.60>, <3.35, 7.55>, <3.15,10.30>, <2.90,13.10>,
  <2.50,16.75>, <2.44,17.78>
//  sturm
  rotate x*90
}

//============================================================================
// The secondary hull cut off in the fore and aft positions.
//
#declare E1701_Hull2_Cigar = intersection {
  object { E1701_Hull2_Cigar_Lathe }
  cylinder { <0,0,3.0>, <0,0,23.30>, 3.86 }
  bounded_by { cylinder { <0,0,2.999>, <0,0,23.301>, 3.861 }}
}

//============================================================================
// Windows for the secondary hull.  R-type windows are rectangular, S are
// square, T are smaller squares, and C are circular portholes.
//
#declare E1701_Hull2_WindowR = box { <4,-0.0875,0>, <2.4,0.0875,0.300> }
#declare E1701_Hull2_WindowS = box { <4,-0.0875,0>, <2.4,0.0875,0.200> }
#declare E1701_Hull2_WindowT = box { <4,-0.0875,0>, <2.4,0.0875,0.175> }
#declare E1701_Hull2_WindowC = cylinder { <4,0,0.05>, <2.4,0,0.05>, 0.05 }

#declare E1701_Hull2_Windows_Lit = intersection {
  object { E1701_Hull2_Cigar_Lathe scale <1.001,1.001,1.000> }
  union {
    object { E1701_Hull2_WindowC translate z* 3.20 rotate z*-35 } // port
    object { E1701_Hull2_WindowT translate z* 3.20 rotate z*-40 }
    object { E1701_Hull2_WindowR translate z* 3.80 rotate z*-60 }
    object { E1701_Hull2_WindowR translate z* 4.20 rotate z*-60 }
    object { E1701_Hull2_WindowR translate z* 6.15 rotate z* 50 }
    object { E1701_Hull2_WindowT translate z* 7.15 rotate z* 30 }
    object { E1701_Hull2_WindowC translate z* 7.40 rotate z*-30 }
    object { E1701_Hull2_WindowR translate z* 7.70 rotate z* 15 }
    object { E1701_Hull2_WindowR translate z* 7.70 rotate z*-25 }
    object { E1701_Hull2_WindowR translate z* 8.50 rotate z* 15 }
    object { E1701_Hull2_WindowC translate z* 8.50 rotate z*-15 }
    object { E1701_Hull2_WindowR translate z* 9.15 rotate z* 15 }
    object { E1701_Hull2_WindowT translate z* 9.20 rotate z*-40 }
    object { E1701_Hull2_WindowC translate z* 9.25 rotate z*-35 }
    object { E1701_Hull2_WindowR translate z* 9.30 rotate z*  5 }
    object { E1701_Hull2_WindowR translate z* 9.75 rotate z*-10 }
    object { E1701_Hull2_WindowR translate z*10.20 rotate z* 15 }
    object { E1701_Hull2_WindowR translate z*10.20 rotate z*-10 }
    object { E1701_Hull2_WindowT translate z*12.40 rotate z*-25 }
    object { E1701_Hull2_WindowT translate z*12.55 rotate z* 15 }
    object { E1701_Hull2_WindowR translate z*13.90 rotate z*-10 }
    object { E1701_Hull2_WindowR translate z*14.80 rotate z*  5 }
    object { E1701_Hull2_WindowR translate z*15.20 rotate z*  5 }
    object { E1701_Hull2_WindowR translate z*15.25 rotate z*-10 }
    object { E1701_Hull2_WindowT translate z*15.25 rotate z*-40 }
    object { E1701_Hull2_WindowC translate z*15.30 rotate z*-35 }
    object { E1701_Hull2_WindowS translate z*16.10 rotate z*-10 }
    object { E1701_Hull2_WindowS translate z*16.95 rotate z* 35 }
    object { E1701_Hull2_WindowR translate z*17.40 rotate z*-10 }
    object { E1701_Hull2_WindowC translate z*20.35 rotate z* 55 }
    object { E1701_Hull2_WindowR translate z*21.40 rotate z* 30 }
    object { E1701_Hull2_WindowR translate z*21.80 rotate z* 30 }
    object { E1701_Hull2_WindowT translate z*21.95 rotate z*-10 }
    object { E1701_Hull2_WindowC translate z*21.95 rotate z* 50 }
    object { E1701_Hull2_WindowC translate z*22.00 rotate z*-10 }
    object { E1701_Hull2_WindowC translate z* 3.20 rotate z*215 } // starboard
    object { E1701_Hull2_WindowT translate z* 3.20 rotate z*220 }
    object { E1701_Hull2_WindowR translate z* 3.80 rotate z*240 }
    object { E1701_Hull2_WindowR translate z* 4.20 rotate z*240 }
    object { E1701_Hull2_WindowR translate z* 6.15 rotate z*130 }
    object { E1701_Hull2_WindowT translate z* 7.15 rotate z*150 }
    object { E1701_Hull2_WindowC translate z* 7.40 rotate z*210 }
    object { E1701_Hull2_WindowR translate z* 7.70 rotate z*165 }
    object { E1701_Hull2_WindowR translate z* 7.70 rotate z*205 }
    object { E1701_Hull2_WindowR translate z* 8.50 rotate z*165 }
    object { E1701_Hull2_WindowC translate z* 8.50 rotate z*195 }
    object { E1701_Hull2_WindowR translate z* 9.15 rotate z*165 }
    object { E1701_Hull2_WindowT translate z* 9.20 rotate z*220 }
    object { E1701_Hull2_WindowC translate z* 9.25 rotate z*215 }
    object { E1701_Hull2_WindowR translate z* 9.30 rotate z*175 }
    object { E1701_Hull2_WindowR translate z* 9.75 rotate z*190 }
    object { E1701_Hull2_WindowR translate z*10.20 rotate z*165 }
    object { E1701_Hull2_WindowR translate z*10.20 rotate z*190 }
    object { E1701_Hull2_WindowT translate z*12.40 rotate z*205 }
    object { E1701_Hull2_WindowT translate z*12.55 rotate z*165 }
    object { E1701_Hull2_WindowR translate z*13.90 rotate z*190 }
    object { E1701_Hull2_WindowR translate z*14.80 rotate z*175 }
    object { E1701_Hull2_WindowR translate z*15.20 rotate z*175 }
    object { E1701_Hull2_WindowR translate z*15.25 rotate z*190 }
    object { E1701_Hull2_WindowT translate z*15.25 rotate z*220 }
    object { E1701_Hull2_WindowC translate z*15.30 rotate z*215 }
    object { E1701_Hull2_WindowS translate z*16.10 rotate z*190 }
    object { E1701_Hull2_WindowS translate z*16.95 rotate z*145 }
    object { E1701_Hull2_WindowR translate z*17.40 rotate z*190 }
    object { E1701_Hull2_WindowC translate z*20.35 rotate z*125 }
    object { E1701_Hull2_WindowR translate z*21.40 rotate z*150 }
    object { E1701_Hull2_WindowR translate z*21.80 rotate z*150 }
    object { E1701_Hull2_WindowT translate z*21.95 rotate z*190 }
    object { E1701_Hull2_WindowC translate z*21.95 rotate z*130 }
    object { E1701_Hull2_WindowC translate z*22.00 rotate z*190 }
  }
  texture { t_lit_window }
}

#declare E1701_Hull2_Windows_Dark = intersection {
  object { E1701_Hull2_Cigar_Lathe scale <1.001,1.001,1.000> }
  union {
    object { E1701_Hull2_WindowT translate z* 6.85 rotate z*-30 } // port
    object { E1701_Hull2_WindowR translate z* 9.75 rotate z*-15 }
    object { E1701_Hull2_WindowS translate z* 9.90 rotate z*  5 }
    object { E1701_Hull2_WindowR translate z*13.45 rotate z*-10 }
    object { E1701_Hull2_WindowR translate z*16.80 rotate z*-10 }
    object { E1701_Hull2_WindowC translate z*20.30 rotate z*-15 }
    object { E1701_Hull2_WindowT translate z* 6.85 rotate z*150 } // starboard
    object { E1701_Hull2_WindowR translate z* 9.75 rotate z*165 }
    object { E1701_Hull2_WindowS translate z* 9.90 rotate z*175 }
    object { E1701_Hull2_WindowR translate z*13.45 rotate z*190 }
    object { E1701_Hull2_WindowR translate z*16.80 rotate z*190 }
    object { E1701_Hull2_WindowC translate z*20.30 rotate z*165 }
  }
  texture { t_dark_window }
}

//============================================================================
// The fiddly bits at the aft end: the hood and landing deck for the shuttle
// bay.
//
#declare E1701_Hull2_Cove = union {
  difference {
    cone { <0,0,23.29>, 2.60, <0,0,24.85>, 2.55 }
    cone { <0,0,23.28>, 2.50, <0,0,24.86>, 2.45 }
    plane { y, -0.1 }
    plane { -z, -24.0 }
    cylinder { <-2.7,0,0>, <2.7,0,0>, 0.665 scale <1,2.774436,1> translate <0,-0.03,24.19> }
    bounded_by { box { <-2.61,-0.56,23.28>, <2.61,2.61,24.87> }}
  }
  intersection {
    cylinder { <0,-0.10,22.26>,<0,-0.55,22.26>, 2.585 }
    box { <-2.586,-0.099,23.299>, <2.586,-0.551,24.846> }
    bounded_by { box { <-2.587,-0.098,23.298>, <2.586,-0.551,24.847> }}
  }
  difference {
    box { <-2.60,-0.10,23.0>, <-1.95,-0.55,23.85> }
    cylinder { <-2.78,-0.09,24.5>, <-2.78,-0.56,24.5>, 1.0 }
    bounded_by { box { <-2.601,-0.099,22.999>, <-1.949,-0.551,23.851> }}
  }
  difference {
    box { <2.60,-0.10,23.0>, <1.95,-0.55,23.85> }
    cylinder { <2.78,-0.09,24.5>, <2.78,-0.56,24.5>, 1.0 }
    bounded_by { box { <2.601,-0.099,22.999>, <1.949,-0.551,23.851> }}
  }
}

//============================================================================
// One segment of the "clamshell" shuttle bay doors.
//
#declare E1701_Hull2_DoorSegment = intersection {
  sphere { <0,0,0>, 2.245 }
  sphere { <0,0,0>, 2.145 inverse }
  plane { -z, 0 rotate y*75 }
  plane { -z, 0 rotate y*-75 }
  box { <-0.6,1.96,1.0>, <0.6,-0.1,2.25> }
  bounded_by { box { <-0.601,1.95,0.999>, <0.601,-0.099,2.251> }}
  texture { t_clamshell }
}

//============================================================================
// The doors.  These can open and close during animations by setting
//  E1701_Shuttle_Bay_Open to a value between 0 (closed) and 1 (open).
//
#declare E1701_Hull2_Clamshell = union {
  object { E1701_Hull2_DoorSegment scale 0.925 rotate y*-(60+(30*E1701_Shuttle_Bay_Open)) }
  object { E1701_Hull2_DoorSegment scale 0.950 rotate y*-(45+(45*E1701_Shuttle_Bay_Open)) }
  object { E1701_Hull2_DoorSegment scale 0.975 rotate y*-(30+(60*E1701_Shuttle_Bay_Open)) }
  object { E1701_Hull2_DoorSegment rotate y*-(15+(75*E1701_Shuttle_Bay_Open)) }
  object { E1701_Hull2_DoorSegment rotate y*(15+(75*E1701_Shuttle_Bay_Open)) }
  object { E1701_Hull2_DoorSegment scale 0.975 rotate y*(30+(60*E1701_Shuttle_Bay_Open)) }
  object { E1701_Hull2_DoorSegment scale 0.950 rotate y*(45+(45*E1701_Shuttle_Bay_Open)) }
  object { E1701_Hull2_DoorSegment scale 0.925 rotate y*(60+(30*E1701_Shuttle_Bay_Open)) }
  scale <1.15,1.15,1>
  translate z*22.30
}

//============================================================================
// Bottom "prong" at the forward end of the section.
//
#declare E1701_Hull2_Prong1 = intersection {
  sphere { <0,0,0>, 3.845 scale <1,1,2.25877763> translate z*4.85 }
  box { <-0.7,-2.6,1.1>, <0.7,-3.9,5.7> }
}

//============================================================================
// Tubes for the lateral "prongs".  These do not appear on the blueprints,
// but since they're visible in the TV show, I decided to add them.
//
#declare E1701_Hull2_Prong_Tubes = union {
  cylinder { <0,-3.7,2.4>, <0,-3.4,1.15>, 0.05 }
  cylinder { <0,-3.2,1.15>, <0,-3.4,1.15>, 0.05 }
  sphere { <0,-3.4,1.15>, 0.05 }
  texture { t_hull2_prongtubes }
}

//============================================================================
// Lateral prongs.
//
#declare E1701_Hull2_Prong2 = union {
  difference {
    intersection {
      sphere { <0,0,0>, 3.845 scale <1,1,2.25877763> translate z*4.85 }
      box { <-0.7,-2.6,1.1>, <0.7,-3.9,5.7> }
    }
    box { <-0.35,-3.8,1.099>, <0.35,-3.2,2.40> }
  }
  object { E1701_Hull2_Prong_Tubes translate x*-0.3 }
  object { E1701_Hull2_Prong_Tubes translate x*-0.2 }
  object { E1701_Hull2_Prong_Tubes translate x*-0.1 }
  object { E1701_Hull2_Prong_Tubes }
  object { E1701_Hull2_Prong_Tubes translate x*0.1 }
  object { E1701_Hull2_Prong_Tubes translate x*0.2 }
  object { E1701_Hull2_Prong_Tubes translate x*0.3 }
}

//============================================================================
// The main bulk of the secondary hull.  The cove is scooped out of the bottom
// aft, and all the doors, windows, prongs and such are added.
//
#declare E1701_Hull2_Layer3 = union {
  difference {
    object { E1701_Hull2_Cigar }
    prism { linear_sweep cubic_spline -2.7, 2.7, 29, 
      <0.55,24.52>, <0.55,25.00>, <0.63,25.16>, <0.88,25.30>, <1.20,25.34>, 
      <1.72,25.34>, <2.36,25.21>, <2.91,24.72>, <3.29,24.03>, <3.42,22.90>, 
      <3.48,21.64>, <3.58,20.38>, <3.62,19.04>, <3.53,18.55>, <3.36,18.43>, 
      <3.20,18.42>, <3.00,18.51>, <2.44,18.77>, <1.98,19.13>, <1.63,19.56>, 
      <1.27,20.19>, <1.02,20.83>, <0.85,21.41>, <0.72,22.00>, <0.59,22.92>,
      <0.55,23.92>, <0.55,24.52>, <0.55,25.00>, <0.63,25.16>
//      sturm
      rotate z*-90
    }
    intersection {
      cylinder { <0,0,17.60>, <0,0,23.35>, 2.40 }
      plane { -y, 0.55 }
    }
  }
  object { E1701_Hull2_Prong1 }
  object { E1701_Hull2_Prong2 rotate z*90}
  object { E1701_Hull2_Prong2 rotate z*-90}
  #ifndef (Quick)
    object { E1701_Hull2_Windows_Lit }
    object { E1701_Hull2_Windows_Dark }
  #end
  texture { t_hull2_streaky }
  #ifndef (Quick)
    texture { t_Hull2_HullTexture }
  #end
}

//============================================================================
// Aft homing beacon.  This blinks on and off with the formation lights, which
// are controlled by the variable E1701_Lights_On.  A real light source is
// used, unless E1701_No_Lights is set (value irrelevant).
//
#declare E1701_Hull2_Beacon = union {
  torus { 0.35, 0.1 translate <0,2.6,23.0> }
  difference {
    cylinder { <0,2.6,23.0>, <0,1.9,23.0>, 0.45 }
    box { <-0.22,2.2,23.0>, <0.22,2.4,23.5> }
  }
  intersection {
    sphere { <0,2.4,23.0>, 0.45 }
    cylinder { <0,2.58,23.0>, <0,2.87,23.0>, 0.365 }
    texture { t_white_glass }
  }
  cylinder { <0,2.199,23.0>, <0,2.401,23.0>, 0.40
    texture { t_formation_lights }
  }
  #ifndef (E1701_No_Lights)
    #if (E1701_Lights_On=1)
      light_source { <0,2.9,23.0>
        colour rgb <2,2,2>
        fade_distance 7*E1701_Scale
        fade_power 2
      }
    #end
  #end
}

//============================================================================
// The interconnecting dorsal between the primary and secondary hulls.  The
// object is created in the vertical orientation, then sheared along the Z
// axis with the matrix transformation.
//
#declare E1701_Hull2_Dorsal_Hull = union {
  intersection {
    cylinder { <0,0,0>, <0,5.5,0>, 0.6 scale <1,1,8.3333> }
    box { <-0.7,0.0,4.5>, <0.7,5.5,-3.0> }
  }
  cylinder { <0,0,-3>, <0,5.5,-3>, 0.48 }
  matrix < 1, 0, 0,
           0, 1,-1,
           0, 0, 1,
           0, 0, 0 >
}

#declare E1701_Hull2_Dorsal_Window = box { <-0.65,0,0>, <0.65,0.175,-0.3> }

#declare E1701_Hull2_Dorsal_Lit_Windows = intersection {
  cylinder { <0,0,0>, <0,5.5,0>, 0.6 scale <1,1,8.3333>
    matrix <1,0,0,0,1,-1,0,0,1,0,0,0>
    scale 1.001 translate y*-1
  }
  union {
    cylinder { <-0.65,0.2,-1.9>, <0.65,0.2,-1.9>, 0.05 }
    object { E1701_Hull2_Dorsal_Window translate <0,0.40,-2.0> }
    object { E1701_Hull2_Dorsal_Window translate <0,1.05,-2.0> }
    object { E1701_Hull2_Dorsal_Window translate <0,1.05,-2.6> }
    object { E1701_Hull2_Dorsal_Window translate <0,1.05, 1.2> }
    object { E1701_Hull2_Dorsal_Window translate <0,1.05, 1.65> }
    object { E1701_Hull2_Dorsal_Window translate <0,1.70,-2.0> }
    object { E1701_Hull2_Dorsal_Window translate <0,1.70,-2.6> }
    object { E1701_Hull2_Dorsal_Window translate <0,1.70,-3.1> }
    object { E1701_Hull2_Dorsal_Window translate <0,1.70,-3.6> }
    object { E1701_Hull2_Dorsal_Window translate <0,1.70,-4.1> }
    object { E1701_Hull2_Dorsal_Window translate <0,2.35,-2.0> }
    object { E1701_Hull2_Dorsal_Window translate <0,2.35,-3.2> }
    object { E1701_Hull2_Dorsal_Window translate <0,3.00,-2.0> }
    object { E1701_Hull2_Dorsal_Window translate <0,3.00,-4.9> }
  }
  translate y*1
  texture { t_lit_window }
}

#declare E1701_Hull2_Dorsal_Dark_Windows = intersection {
  cylinder { <0,0,0>, <0,5.5,0>, 0.6 scale <1,1,8.3333>
    matrix <1,0,0,0,1,-1,0,0,1,0,0,0>
    scale 1.001 translate y*-1
  }
  union {
    object { E1701_Hull2_Dorsal_Window translate <0,0.40,-1.4> }
    object { E1701_Hull2_Dorsal_Window translate <0,2.35,-2.7> }
    object { E1701_Hull2_Dorsal_Window translate <0,3.00,-5.4> }
  }
  translate y*1
  texture { t_dark_window }
}

#declare E1701_Hull2_Dorsal = union {
  object { E1701_Hull2_Dorsal_Hull }
  #ifndef (Quick)
    object { E1701_Hull2_Dorsal_Lit_Windows }
    object { E1701_Hull2_Dorsal_Dark_Windows }
  #end
  translate <0,3,7>
}

//============================================================================
// Put all the components together.
//
#declare E1701_Hull2 = union {
  object { E1701_Hull2_Sensor }
  object { E1701_Hull2_SensorBay }
  object { E1701_Hull2_Layer1 }
  object { E1701_Hull2_Layer2 }
  object { E1701_Hull2_Layer3 }
  object { E1701_Hull2_Cove }
  object { E1701_Hull2_Clamshell }
  object { E1701_Hull2_Beacon }
  object { E1701_Hull2_Dorsal }
  texture { t_Hull_BasicTexture }
}
